///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// $Id: MimeMessageReader.h,v 1.10 2003/08/30 21:42:24 bburton Exp $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//

#ifndef _MimeMessageReader_h
#define _MimeMessageReader_h

#include "MD5Digester.h"
#include "MimeHeader.h"

class MimeMessageReader
{
public:
  MimeMessageReader(istream &in,
                    bool ignore_from,
                    bool use_content_length);
  ~MimeMessageReader();

  /// Reads the header for the next available message or returns false if none found.
  bool readNextHeader();

  /// Get character set if one is defined for the message
  bool getCharSet(string &value);

  /// Access first instance (if any) of specified header.
  bool getField(const string &name,
                string &value);

  /// Access all instances (if any) of specified header (useful for Received).
  bool getField(const string &name,
                vector<string> &values);

  int getFieldCount();

  bool getField(int index,
                string &value);

  bool getFieldName(int index,
                    string &name);

  const string &getMD5Digest();

  /**
     Reads the next chunk of text from the message ignoring binary
     attachments.  No distinction is made between the parts containing
     the text.  It is all run together because that is all that the
     spam filter needs to do its job.  Only lines from text/ parts are
     returned.  These chunks of text can and usually will contain multiple
     lines of text.  Multiple lines will be separated by whatever line
     breaks were in the original text so they could be CR, LF, or CRLF.
     If the text comes from a mime attachment content_type will contain
     the content-type header of the attachment.
  */
  bool readText(string &text,
                string &content_type);

  static void decodeText(string &text);
  static void unquoteText(string &text,
                          bool is_header);
  static void decodeHeader(string &text);

private:
  MimeHeader &outer();
  MimeHeader &current();
  bool readToBoundary(string *textp = 0);
  bool readNonMimeBody(string &text);
  void addStringToDigest(const string &value);
  void addFieldToDigest(const string &field_name);

private:
  /// Not implemented.
  MimeMessageReader(const MimeMessageReader &);

  /// Not implemented.
  MimeMessageReader& operator=(const MimeMessageReader &);

private:
  MimeLineReader m_reader;
  bool m_ignoreFrom;
  bool m_ignoreContentLength;
  bool m_atEnd;
  bool m_haveContentLength;
  int m_contentLength;
  vector<MimeHeader> m_headers;
  MD5Digester m_md5;
};

#endif // _MimeMessageReader_h
