///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: AutoTrainMailMessageReader.h 98 2004-11-19 23:22:49Z brian $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#ifndef _AutoTrainMessageReader_h
#define _AutoTrainMessageReader_h

#include <list>
#include <fstream>
#include "AbstractMailMessageReader.h"

class FileMailMessageReader;

class AutoTrainMailMessageReader : public AbstractMailMessageReader
{
public:
  AutoTrainMailMessageReader();
  ~AutoTrainMailMessageReader();

  void addMailboxFile(bool is_spam, const string &path);

  OWNED MailMessage *readMessage();

  bool messageWasSpam()
  {
    return m_messageWasSpam;
  }

  const string &messagePath()
  {
    return *m_messagePath;
  }

private:
  /// Not implemented.
  AutoTrainMailMessageReader(const AutoTrainMailMessageReader &);

  /// Not implemented.
  AutoTrainMailMessageReader& operator=(const AutoTrainMailMessageReader &);

private:
  bool shouldUseSpam();
  long countMessagesInFile(const string &path);
  void openFile(const string &path,
                NewPtr<FileMailMessageReader> &reader);
  bool readMessage(list<string> &paths,
                   string &path,
                   NewPtr<FileMailMessageReader> &reader,
                   NewPtr<MailMessage> &message);
  bool readMessage(bool is_spam,
                   NewPtr<MailMessage> &message);

private:
  long m_spamCount;
  long m_totalCount;
  list<string> m_spamPaths;
  list<string> m_goodPaths;
  bool m_ignoreFrom;
  bool m_ignoreContentLength;

  bool m_messageWasSpam;
  string *m_messagePath;
  string m_spamPath;
  string m_goodPath;
  NewPtr<FileMailMessageReader> m_spamReader;
  NewPtr<FileMailMessageReader> m_goodReader;
};

#endif // _AutoTrainMailMessageReader_h
