///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: BNRTokenSelector.h 56 2004-10-31 23:10:45Z brian $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#ifndef _BNRTokenSelector_h
#define _BNRTokenSelector_h

#include "TokenSelector.h"

class BNRTokenSelector : public TokenSelector
{
public:
  BNRTokenSelector();
  virtual ~BNRTokenSelector();

  virtual void selectTokens(const Message &msg,
                            vector<Token *> &tokens);

private:
  void getBaseTokens(const Message &msg,
                     vector<Token *> &tokens);
  void getTokensWithFlag(const Message &msg,
                         vector<Token *> &tokens,
                         int flag);
  void selectTokensWithFlag(const Message &msg,
                            vector<Token *> &tokens,
                            int flag);

  bool processToken(Token *tok, Token *prev_tok, Token *next_tok);
  bool isDubbingOn();
  bool isNeutral(Token *tok);
  bool isInteresting(Token *tok);
  bool isInnocent(Token *tok);
  bool isHighOrder(Token *tok);
  bool isLowOrder(Token *tok);
  Token *getToken(vector<Token *> &tokens,
                  int index);

private:
  int m_numDubbed;
  int m_nextIndex;
  int m_dubStart;
};


#endif // _BNRTokenSelector_h
