#include "CleanupManager.h"

CleanupManager::CleanupManager()
{
}

CleanupManager::CleanupManager(int junk_count,
                               int max_age)
{
  addLimit(junk_count, max_age);
}

CleanupManager::~CleanupManager()
{
}

void CleanupManager::addLimit(int junk_count,
                              int max_age)
{
  m_nodes.push_back(CleanupNode(junk_count, max_age));
  if (is_debug) {
    cerr << "CleanupManager added limit: count " << junk_count << " age " << max_age << endl;
  }
}

bool CleanupManager::shouldDelete(const WordData &word_data) const
{
  for (NodeIter_t i = m_nodes.begin(); i != m_nodes.end(); ++i) {
    if (word_data.totalCount() <= i->junk_count && word_data.age() > i->max_age) {
      if (is_debug) {
        cerr << "CleanupManager triggered limit:"
             << " count " << word_data.totalCount() << " <= " << i->junk_count
             << " age " << word_data.age() << " > " << i->max_age
             << endl;
      }
      return true;
    }
  }
  return false;
}
