///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: MailMessageList.h 56 2004-10-31 23:10:45Z brian $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#ifndef _MailMessageList_h
#define _MailMessageList_h

#include "NewVector.h"
#include "MailMessage.h"

class MailMessageList
{
public:
    ~MailMessageList()
    {
    }

    void addMessage(OWNED MailMessage *message)
    {
        m_messages.add(message);
    }

    int messageCount() const
    {
        return m_messages.size();
    }

    MailMessage *message(int index) const
    {
        return m_messages[index];
    }

private:
    NewVector<MailMessage> m_messages;
};

#endif

