#ifndef _HdlStatementConstraint_h
#define _HdlStatementConstraint_h

#include "util.h"

class HdlStatementConstraint
{
public:
  HdlStatementConstraint(const string &name)
    : m_name(name)
  {
  }

  virtual ~HdlStatementConstraint()
  {
  }

  virtual void validateStatement(const CRef<HdlStatement> &stmt) const;

  const string &name() const
  {
    return m_name;
  }

private:
  /// Not implemented.
  HdlStatementConstraint(const HdlStatementConstraint &);

  /// Not implemented.
  HdlStatementConstraint& operator=(const HdlStatementConstraint &);

private:
  string m_name;
};

#endif // _HdlStatementConstraint_h
