-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SparkLex;

package body AdjustFDL_RWs is

   procedure Possibly_Adjust (E_Str  : in out E_Strings.T;
                              Prefix : in     E_Strings.T) is
      Temp_Str : E_Strings.T;
   begin
      if SparkLex.Check_FDL_RW (Ex_Str => E_Str) then
         Temp_Str := Prefix;
         E_Strings.Append_String (E_Str => Temp_Str,
                                  Str   => "__");
         E_Strings.Append_Examiner_String (E_Str1 => Temp_Str,
                                           E_Str2 => E_Str);
         E_Str := Temp_Str;
      end if;
   end Possibly_Adjust;

end AdjustFDL_RWs;
