-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SPARK_IO;

use type SPARK_IO.File_Status;

--# inherit Ada.Characters.Handling,
--#         Casing,
--#         CommandLineData,
--#         ContextManager,
--#         Dictionary,
--#         ErrorHandler,
--#         Error_IO,
--#         Error_Types,
--#         ExaminerConstants,
--#         E_Strings,
--#         FileSystem,
--#         LexTokenLists,
--#         LexTokenManager,
--#         LexTokenStacks,
--#         Maths,
--#         ScreenEcho,
--#         SparkLex,
--#         SPARK_IO,
--#         SPExpectedSymbols,
--#         SPSymbols,
--#         Statistics,
--#         SystemErrors,
--#         XMLReport;

package ConfigFile
--# own State;
--# initializes State;
is

   procedure Read_Config_File (Opened_OK : out Boolean;
                               No_Errors : out Boolean);
   --# global in     CommandLineData.Content;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SparkLex.Curr_Line;
   --#        in out SPARK_IO.File_Sys;
   --#           out State;
   --# derives Dictionary.Dict,
   --#         ErrorHandler.Error_Context,
   --#         LexTokenManager.State,
   --#         No_Errors,
   --#         SPARK_IO.File_Sys,
   --#         State                      from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         SPARK_IO.File_Sys &
   --#         Opened_OK                  from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         SPARK_IO.File_Sys &
   --#         SparkLex.Curr_Line         from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         SPARK_IO.File_Sys;

   procedure Output_Config_File (To_File : in SPARK_IO.File_Type);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out XMLReport.State;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys,
   --#         XMLReport.State            from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         SPARK_IO.File_Sys,
   --#                                         State,
   --#                                         To_File,
   --#                                         XMLReport.State;

end ConfigFile;
