-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with Cells;
with Dictionary;
with Heap;
with LexTokenManager;
with SPARK_IO;
with STree;

use type Dictionary.Symbol;
use type Dictionary.Abstractions;
use type Dictionary.Modes;
use type Dictionary.Scopes;
use type Cells.Cell_Kind;
use type LexTokenManager.Str_Comp_Result;
use type SPARK_IO.File_Status;
use type STree.SyntaxNode;

--# inherit Cells,
--#         Clists,
--#         CommandLineData,
--#         ContextManager,
--#         CStacks,
--#         DAG_IO,
--#         Debug,
--#         Dictionary,
--#         ErrorHandler,
--#         ExaminerConstants,
--#         E_Strings,
--#         FileSystem,
--#         Graph,
--#         Heap,
--#         Labels,
--#         LexTokenManager,
--#         Maths,
--#         Pairs,
--#         ScreenEcho,
--#         SeqAlgebra,
--#         SPARK_IO,
--#         SPSymbols,
--#         Statistics,
--#         StmtStack,
--#         STree,
--#         Structures,
--#         SystemErrors;

package DAG is

   -- Traverses the Syntax Tree of a subprogram and produces a complete
   -- labelled Basic Path Graph in the state Graph.Table
   procedure BuildGraph
     (StartNode                 : in     STree.SyntaxNode;
      SubprogSym                : in     Dictionary.Symbol;
      Scope                     : in     Dictionary.Scopes;
      OutputFile                : in     SPARK_IO.File_Type;
      EndPosition               : in     LexTokenManager.Token_Position;
      VCGFailure                : in out Boolean;
      VCGHeap                   : in out Cells.Heap_Record;
      FlowHeap                  : in out Heap.HeapRecord;
      SemanticErrorInSubprogram : in     Boolean;
      DataFlowErrorInSubprogram : in     Boolean;
      Type_Check_Exports        : in     Boolean);
   --# global in     CommandLineData.Content;
   --#        in     STree.Table;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out Graph.Table;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#           out StmtStack.S;
   --# derives Dictionary.Dict,
   --#         Graph.Table,
   --#         LexTokenManager.State,
   --#         Statistics.TableUsage,
   --#         VCGFailure,
   --#         VCGHeap                    from *,
   --#                                         CommandLineData.Content,
   --#                                         DataFlowErrorInSubprogram,
   --#                                         Dictionary.Dict,
   --#                                         FlowHeap,
   --#                                         Graph.Table,
   --#                                         LexTokenManager.State,
   --#                                         Scope,
   --#                                         SemanticErrorInSubprogram,
   --#                                         StartNode,
   --#                                         STree.Table,
   --#                                         SubprogSym,
   --#                                         Type_Check_Exports,
   --#                                         VCGHeap &
   --#         ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         DataFlowErrorInSubprogram,
   --#                                         Dictionary.Dict,
   --#                                         EndPosition,
   --#                                         ErrorHandler.Error_Context,
   --#                                         FlowHeap,
   --#                                         Graph.Table,
   --#                                         LexTokenManager.State,
   --#                                         OutputFile,
   --#                                         Scope,
   --#                                         SemanticErrorInSubprogram,
   --#                                         SPARK_IO.File_Sys,
   --#                                         StartNode,
   --#                                         STree.Table,
   --#                                         SubprogSym,
   --#                                         Type_Check_Exports,
   --#                                         VCGHeap &
   --#         FlowHeap,
   --#         StmtStack.S                from CommandLineData.Content,
   --#                                         DataFlowErrorInSubprogram,
   --#                                         Dictionary.Dict,
   --#                                         FlowHeap,
   --#                                         Graph.Table,
   --#                                         LexTokenManager.State,
   --#                                         Scope,
   --#                                         SemanticErrorInSubprogram,
   --#                                         StartNode,
   --#                                         STree.Table,
   --#                                         SubprogSym,
   --#                                         VCGHeap;

   -- Builds a DAG representing the expression (which might
   -- be a complete aggregate) that initializes a constant. This is
   -- used to build the FDL replacement rule for composite constants,
   -- as controlled by the -rules switch.
   procedure BuildConstantInitializationDAG
     (StartNode : in     STree.SyntaxNode;
      Scope     : in     Dictionary.Scopes;
      TheHeap   : in out Cells.Heap_Record;
      DAGRoot   :    out Cells.Cell);
   --# global in     CommandLineData.Content;
   --#        in     STree.Table;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out Graph.Table;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out StmtStack.S;
   --# derives DAGRoot,
   --#         Dictionary.Dict,
   --#         Graph.Table,
   --#         LexTokenManager.State,
   --#         StmtStack.S,
   --#         TheHeap                    from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         Graph.Table,
   --#                                         LexTokenManager.State,
   --#                                         Scope,
   --#                                         StartNode,
   --#                                         StmtStack.S,
   --#                                         STree.Table,
   --#                                         TheHeap &
   --#         ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         Graph.Table,
   --#                                         LexTokenManager.State,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         StartNode,
   --#                                         StmtStack.S,
   --#                                         STree.Table,
   --#                                         TheHeap &
   --#         Statistics.TableUsage      from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         Graph.Table,
   --#                                         LexTokenManager.State,
   --#                                         Scope,
   --#                                         StartNode,
   --#                                         StmtStack.S,
   --#                                         STree.Table,
   --#                                         TheHeap;

end DAG;
