-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with E_Strings;

--# inherit E_Strings;

package Date_Time
is
   --  This is the return-type for Compare_Timestamps.
   type Timestamp_Comparison_Result_T is (Malformed_Timestamps, A_Less_Than_B, A_Equals_B, A_Greater_Than_B);

   --  We use short month names in a few places (including in POGS),
   --  so it makes sense to define them in a central place to avoid
   --  duplication.
   subtype Seconds_T is Natural range 0 .. 59;
   subtype Minutes_T is Natural range 0 .. 59;
   subtype Hours_T is Natural range 0 .. 23;
   subtype Days_T is Positive range 1 .. 31;
   subtype Months_T is Positive range 1 .. 12;
   subtype Years_T is Natural range 1000 .. 9999; -- TODO: Raise ticket in 9999BC and extend range

   subtype String_3_Positions is Positive range 1 .. 3;
   subtype String_3_T is String (String_3_Positions);
   type Month_Names_T is array (Months_T) of String_3_T;
   Month_Names : constant Month_Names_T :=
     Month_Names_T'("JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC");

   --  This function compares two timestamps and returns
   --  A_Less_Than_B, A_Equals_B or A_Greater_Than_B.
   --  The timestamps must be in the following format:
   --
   --     30-SEP-2010, 10:15:24
   --
   --  The comma after the date is optional.
   --
   --  Any characters afterwards are ignored. In case of any parsing
   --  error in either timestamps the special Malformed_Timestamps
   --  value is returned. This function assumes the month abbreviation
   --  is in English.
   function Compare_Timestamps (Timestamp_A : E_Strings.T;
                                Timestamp_B : E_Strings.T)
                               return Timestamp_Comparison_Result_T;

end Date_Time;
