-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

---------------------------------------------------------------------------------------
--                                                                            --
-- Useful debug routines.  They all "derive null ..." to minimize impact on   --
-- self-analysis.                                                             --
--                                                                            --
--------------------------------------------------------------------------------

with Cells;
with Dictionary;
with Heap;
with LexTokenManager;
with SeqAlgebra;
with STree;

use type Dictionary.Symbol;

--# inherit Cells,
--#         Dictionary,
--#         E_Strings,
--#         Heap,
--#         LexTokenManager,
--#         SeqAlgebra,
--#         SPARK_IO,
--#         STree;

package Debug is

   procedure PrintMsg (Msg     : in String;
                       NewLine : in Boolean);
   --# derives null from Msg,
   --#                   NewLine;

   -- Prints Sym to Standard_Output
   procedure Print_Sym_Raw (Sym : in Dictionary.Symbol);
   --# derives null from Sym;

   -- Prints Msg, Sym, and a New_Line to Standard_Output
   procedure Print_Sym (Msg : in String;
                        Sym : in Dictionary.Symbol);
   --# derives null from Msg,
   --#                   Sym;

   procedure PrintScope (Msg   : in String;
                         Scope : in Dictionary.Scopes);
   --# derives null from Msg,
   --#                   Scope;

   procedure PrintInt (Msg : in String;
                       I   : in Integer);
   --# derives null from I,
   --#                   Msg;

   procedure PrintBool (Msg : in String;
                        B   : in Boolean);
   --# derives null from B,
   --#                   Msg;

   procedure Print_Lex_Str (Msg : in String;
                            L   : in LexTokenManager.Lex_String);
   --# derives null from L,
   --#                   Msg;

   -- The_Heap needs to be "in out" here for DAG_IO.PrintDAG...
   procedure PrintDAG
     (Msg      : in     String;
      DAG      : in     Cells.Cell;
      The_Heap : in out Cells.Heap_Record;
      Scope    : in     Dictionary.Scopes);
   --# derives The_Heap from * &
   --#         null     from DAG,
   --#                       Msg,
   --#                       Scope;

   procedure Print_Sym_Seq (Msg      : in String;
                            Seq      : in SeqAlgebra.Seq;
                            The_Heap : in Heap.HeapRecord);
   --# derives null from Msg,
   --#                   Seq,
   --#                   The_Heap;

   procedure PrintSeq (Msg      : in String;
                       Seq      : in SeqAlgebra.Seq;
                       The_Heap : in Heap.HeapRecord);
   --# derives null from Msg,
   --#                   Seq,
   --#                   The_Heap;

   procedure PrintNode (Msg : in String;
                        N   : in STree.SyntaxNode);
   --# derives null from Msg,
   --#                   N;

   procedure PrintTraceback (Msg   : in String;
                             Depth : in Natural);
   --# derives null from Depth,
   --#                   Msg;

end Debug;
