-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (ErrorHandler)
procedure AppendSym (Error : in out Error_Types.StringError;
                     Sym   : in     SPSymbols.SPSymbol) is
   --# hide AppendSym;

   procedure Append_Reserved_Word (S : String)
   --# global in out Error;
   --# derives Error from *,
   --#                    S;
   is
   begin
      Append_String (E_Str => Error,
                     Str   => S (S'First + 2 .. S'Last));
   end Append_Reserved_Word;

   ------------------------------------------

begin --AppendSym
   case Sym is
      when SPSymbols.RWabort .. SPSymbols.RWxor =>
         Append_String (E_Str => Error,
                        Str   => "reserved word """);
         Append_Reserved_Word (S => SPSymbols.SPSymbol'Image (Sym));
         Append_String (E_Str => Error,
                        Str   => """");
      when SPSymbols.ampersand =>
         Append_String (E_Str => Error,
                        Str   => """&""");
      when SPSymbols.apostrophe =>
         Append_String (E_Str => Error,
                        Str   => """'""");
      when SPSymbols.left_paren =>
         Append_String (E_Str => Error,
                        Str   => """(""");
      when SPSymbols.right_paren =>
         Append_String (E_Str => Error,
                        Str   => """)""");
      when SPSymbols.multiply =>
         Append_String (E_Str => Error,
                        Str   => """*""");
      when SPSymbols.plus =>
         Append_String (E_Str => Error,
                        Str   => """+""");
      when SPSymbols.comma =>
         Append_String (E_Str => Error,
                        Str   => """,""");
      when SPSymbols.minus =>
         Append_String (E_Str => Error,
                        Str   => """-""");
      when SPSymbols.point =>
         Append_String (E_Str => Error,
                        Str   => """.""");
      when SPSymbols.divide =>
         Append_String (E_Str => Error,
                        Str   => """/""");
      when SPSymbols.colon =>
         Append_String (E_Str => Error,
                        Str   => """:""");
      when SPSymbols.semicolon =>
         Append_String (E_Str => Error,
                        Str   => """;""");
      when SPSymbols.less_than =>
         Append_String (E_Str => Error,
                        Str   => """<""");
      when SPSymbols.equals =>
         Append_String (E_Str => Error,
                        Str   => """=""");
      when SPSymbols.greater_than =>
         Append_String (E_Str => Error,
                        Str   => """>""");
      when SPSymbols.vertical_bar =>
         Append_String (E_Str => Error,
                        Str   => """|""");
      when SPSymbols.tilde =>
         Append_String (E_Str => Error,
                        Str   => """~""");
      when SPSymbols.arrow =>
         Append_String (E_Str => Error,
                        Str   => """=>""");
      when SPSymbols.double_dot =>
         Append_String (E_Str => Error,
                        Str   => """..""");
      when SPSymbols.double_star =>
         Append_String (E_Str => Error,
                        Str   => """**""");
      when SPSymbols.becomes =>
         Append_String (E_Str => Error,
                        Str   => """:=""");
      when SPSymbols.not_equal =>
         Append_String (E_Str => Error,
                        Str   => """/=""");
      when SPSymbols.greater_or_equal =>
         Append_String (E_Str => Error,
                        Str   => """>=""");
      when SPSymbols.less_or_equal =>
         Append_String (E_Str => Error,
                        Str   => """<=""");
      when SPSymbols.box =>
         Append_String (E_Str => Error,
                        Str   => """<>""");
      when SPSymbols.implies =>
         Append_String (E_Str => Error,
                        Str   => """->""");
      when SPSymbols.is_equivalent_to =>
         Append_String (E_Str => Error,
                        Str   => """<->""");
      when SPSymbols.square_open =>
         Append_String (E_Str => Error,
                        Str   => """[""");
      when SPSymbols.square_close =>
         Append_String (E_Str => Error,
                        Str   => """]""");
      when others =>
         Append_String (E_Str => Error,
                        Str   => SPSymbols.SPSymbol'Image (Sym));
   end case;
end AppendSym;
