-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure CheckInterruptPropertyConsistency
  (HasInterruptProperty : in     Boolean;
   Sym                  : in     Dictionary.Symbol;
   TypeSym              : in     Dictionary.Symbol;
   ErrorNode            : in     STree.SyntaxNode;
   Consistent           :    out Boolean) is

   function TypeCanInterrupt (TypeSym : Dictionary.Symbol) return Boolean
   --# global in Dictionary.Dict;
   is
   begin
      -- To interrupt the type must be a protected type with an attach handler.
      --
      return Dictionary.TypeIsProtected (TypeSym)
        and then Dictionary.GetTypeHasPragma (Dictionary.GetRootType (TypeSym), Dictionary.AttachHandler);
   end TypeCanInterrupt;

begin

   Consistent := True;

   if Dictionary.IsDeclared (TypeSym) or Dictionary.IsPredefined (TypeSym) then

      if HasInterruptProperty and not TypeCanInterrupt (TypeSym) then

         -- We have an own variable with the interrupt property whose type
         -- cannot interrupt.
         --
         Consistent := False;
         ErrorHandler.Semantic_Error
           (Err_Num   => 936,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => ErrorNode),
            Id_Str    => Dictionary.GetSimpleName (Sym));

      elsif not HasInterruptProperty and TypeCanInterrupt (TypeSym) then

         -- We have an own variable without the interrupt property whose
         -- type can interrupt.
         --
         Consistent := False;
         ErrorHandler.Semantic_Error
           (Err_Num   => 935,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => ErrorNode),
            Id_Str    => Dictionary.GetSimpleName (Sym));

      end if;
   end if;
end CheckInterruptPropertyConsistency;
