-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure down_wf_aggregate_choice_rep
  (Node         : in     STree.SyntaxNode;
   Scope        : in     Dictionary.Scopes;
   EStack       : in out ExpStack.ExpStackType;
   HeapParam    : in out Lists.List_Heap;
   IsAnnotation : in     Boolean;
   Next_Node    :    out STree.SyntaxNode) is
   AGG_CHOICE_LOOKUP : constant Annotation_Symbol_Table :=
     Annotation_Symbol_Table'(False => SPSymbols.aggregate_choice_rep,
                              True  => SPSymbols.annotation_aggregate_choice_rep);

   NameExp, FieldInfo : Exp_Record;
   FieldIdentNode     : STree.SyntaxNode;
   FieldIdent         : LexTokenManager.Lex_String;
   FieldSymbol        : Dictionary.Symbol;
   AlreadyPresent     : Boolean;

   ----------------------------------------------------

   function RangeFound (Node : STree.SyntaxNode) return Boolean
   --# global in STree.Table;
   is
   begin
      return not (Next_Sibling (Child_Node (Child_Node (Node))) = STree.NullNode);
   end RangeFound;

   ----------------------------------------------------

   procedure CheckForBranches (StartNode, EndNode : in STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     IsAnnotation;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         EndNode,
   --#                                         ErrorHandler.Error_Context,
   --#                                         IsAnnotation,
   --#                                         LexTokenManager.State,
   --#                                         SPARK_IO.File_Sys,
   --#                                         StartNode,
   --#                                         STree.Table;
   is
      Next_Node : STree.SyntaxNode;

   begin
      Next_Node := StartNode;
      while Next_Node /= EndNode loop
         if Syntax_Node_Type (Node => Next_Node) = AGG_CHOICE_LOOKUP (IsAnnotation) then
            ErrorHandler.Semantic_Error
              (Err_Num   => 60,
               Reference => ErrorHandler.No_Reference,
               Position  => Node_Position (Node => Next_Sibling (Current_Node => Next_Node)),
               Id_Str    => LexTokenManager.Null_String);
         end if;
         Next_Node := Parent_Node (Current_Node => Next_Node);
      end loop;
   end CheckForBranches;

   ----------------------------------------------------

begin --down_wf_aggregate_choice_rep
   ExpStack.Pop (NameExp, EStack);
   if Dictionary.IsUnknownTypeMark (NameExp.Type_Symbol) then
      ExpStack.Push (NameExp, EStack);
      Next_Node := STree.NullNode;

   elsif Dictionary.TypeIsArray (NameExp.Type_Symbol) then
      ExpStack.Push (NameExp, EStack);
      Next_Node := Child_Node (Current_Node => Node);

   else --must be a record
      if RangeFound (Node) then
         ExpStack.Push (NameExp, EStack);
         ExpStack.Push (NullParameterRecord, EStack);
         ErrorHandler.Semantic_Error
           (Err_Num   => 60,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => Node),
            Id_Str    => LexTokenManager.Null_String);
      else
         FieldIdentNode := Last_Child_Of (Start_Node => Node);
         if Syntax_Node_Type (Node => FieldIdentNode) = SPSymbols.identifier then
            FieldIdent  := Node_Lex_String (Node => FieldIdentNode);
            FieldSymbol :=
              Dictionary.LookupSelectedItem
              (Prefix   => NameExp.Type_Symbol,
               Selector => FieldIdent,
               Scope    => Scope,
               Context  => Dictionary.ProgramContext);
            if FieldSymbol = Dictionary.NullSymbol then --no such field
               ExpStack.Push (NameExp, EStack);
               ExpStack.Push (NullParameterRecord, EStack);
               ErrorHandler.Semantic_Error
                 (Err_Num   => 8,
                  Reference => ErrorHandler.No_Reference,
                  Position  => Node_Position (Node => FieldIdentNode),
                  Id_Str    => FieldIdent);
            else --field name exists
               AddName (FieldIdent, NameExp.Param_List, HeapParam, AlreadyPresent);
               if AlreadyPresent then
                  ExpStack.Push (NameExp, EStack);
                  ExpStack.Push (NullParameterRecord, EStack);
                  ErrorHandler.Semantic_Error
                    (Err_Num   => 103,
                     Reference => ErrorHandler.No_Reference,
                     Position  => Node_Position (Node => FieldIdentNode),
                     Id_Str    => FieldIdent);
               else --no value thus far assigned
                  STree.Set_Node_Lex_String (Sym  => FieldSymbol,
                                             Node => FieldIdentNode);
                  FieldInfo              := NullParameterRecord;
                  FieldInfo.Other_Symbol := FieldSymbol;
                  ExpStack.Push (NameExp, EStack);
                  ExpStack.Push (FieldInfo, EStack);
               end if;
            end if;
         else --identifier not found
            ExpStack.Push (NameExp, EStack);
            ExpStack.Push (NullParameterRecord, EStack);
            ErrorHandler.Semantic_Error
              (Err_Num   => 102,
               Reference => ErrorHandler.No_Reference,
               Position  => Node_Position (Node => FieldIdentNode),
               Id_Str    => Dictionary.GetSimpleName (NameExp.Other_Symbol));
         end if;
         CheckForBranches (FieldIdentNode, Node);
      end if;
      Next_Node := STree.NullNode;
   end if;

end down_wf_aggregate_choice_rep;
