-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (SparkLex.Lex)
procedure LTIntro (Token : out SPSymbols.SPTerminal) is
   Ch1, Ch2 : Character;
begin
   LineManager.Accept_Char; -- less_than already recognised
   LineManager.Inspect_Char (Ch => Ch1);
   case Ch1 is
      when '=' =>
         Token := SPSymbols.less_or_equal;
         LineManager.Accept_Char;
      when '>' =>
         Token := SPSymbols.box;
         LineManager.Accept_Char;
      when '<' =>
         Token := SPSymbols.left_label_paren;
         LineManager.Accept_Char;
      when '-' =>
         LineManager.Lookahead_Char (Ch => Ch2);
         if Ch2 = '>' then
            Token := SPSymbols.is_equivalent_to;
            LineManager.Accept_Lookahead;
         else
            Token := SPSymbols.less_than;
            LineManager.Reject_Lookahead;
         end if;
      when others =>
         Token := SPSymbols.less_than;
   end case;
end LTIntro;
