-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with Ada.Characters.Latin_1;
with E_Strings;
with LexTokenManager;
with SPARK_IO;
with SPSymbols;

use type LexTokenManager.Line_Numbers; use type SPSymbols.SPSymbol;

--# inherit Ada.Characters.Handling,
--#         Ada.Characters.Latin_1,
--#         CommandLineData,
--#         Dictionary,
--#         ErrorHandler,
--#         E_Strings,
--#         LexTokenLists,
--#         LexTokenManager,
--#         SPARK_IO,
--#         SPSymbols,
--#         SystemErrors;
package SparkLex
--# own Curr_Line;
is

   type Line_Context is private;

   Null_Line_Context : constant Line_Context;

   procedure Clear_Line_Context;
   --# global out Curr_Line;
   --# derives Curr_Line from ;

   procedure Store_Line_Context (File_Line : out Line_Context);
   --# global in Curr_Line;
   --# derives File_Line from Curr_Line;

   procedure Restore_Line_Context (File_Line : in Line_Context);
   --# global out Curr_Line;
   --# derives Curr_Line from File_Line;

   -- Returns True iff ExStr is an FDL reserved word
   function Check_FDL_RW (Ex_Str : E_Strings.T) return Boolean;

   -- Scan ProgText and return next token found with class Token
   -- and value LexVal.  PunctToken is True iff the scanned token
   -- is deemed to be a "punctutation token" which can be ignored
   -- by the parser.
   --
   -- The exact list of "Punctutation Tokens" is defined in
   -- SPARKLex.Lex.IsPunctToken
   procedure Examiner_Lex
     (Prog_Text   : in     SPARK_IO.File_Type;
      Token       :    out SPSymbols.SPTerminal;
      Lex_Val     :    out LexTokenManager.Lex_Value;
      Punct_Token :    out Boolean);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in out Curr_Line;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives Curr_Line,
   --#         ErrorHandler.Error_Context,
   --#         LexTokenManager.State,
   --#         Lex_Val,
   --#         Punct_Token,
   --#         SPARK_IO.File_Sys,
   --#         Token                      from CommandLineData.Content,
   --#                                         Curr_Line,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Prog_Text,
   --#                                         SPARK_IO.File_Sys;

   -- This version behaves as ExaminerLex, but _allows_ identifiers
   -- beginning with $ to allow for pre-processing and macro-substitution
   -- of such identifiers by tools such as GNATPREP.
   procedure SPARK_Format_Lex
     (Prog_Text   : in     SPARK_IO.File_Type;
      Token       :    out SPSymbols.SPTerminal;
      Lex_Val     :    out LexTokenManager.Lex_Value;
      Punct_Token :    out Boolean);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in out Curr_Line;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives Curr_Line,
   --#         ErrorHandler.Error_Context,
   --#         LexTokenManager.State,
   --#         Lex_Val,
   --#         Punct_Token,
   --#         SPARK_IO.File_Sys,
   --#         Token                      from CommandLineData.Content,
   --#                                         Curr_Line,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Prog_Text,
   --#                                         SPARK_IO.File_Sys;

   -- Returns True if Token1 and Token2 are both
   --    Delimiters (such as operators, [ ], and %)
   -- or both Numbers (integers, real, based literals etc.)
   -- or both Character or String literals
   -- or both Identifiers
   -- or both Reserved Words
   -- or both "Others" (not falling into any of the catogories above)
   function Similar_Tokens (Token1, Token2 : SPSymbols.SPTerminal) return Boolean;

private

   type Program_Context is (In_Ada, In_Annotation);

   type Annotation_Context is (Start_Annotation, Mid_Annotation, Ended_Annotation);

   subtype Line_Lengths is Integer range 0 .. 255;

   type Line is array (Line_Lengths) of Character;

   type Line_Context is record
      Context                                              : Program_Context;
      Anno_Context                                         : Annotation_Context;
      Line_No                                              : LexTokenManager.Line_Numbers;
      Line_Length, Last_Token_Pos, Curr_Pos, Lookahead_Pos : Line_Lengths;
      Conts                                                : Line;
   end record;

   Null_Line_Context : constant Line_Context :=
     Line_Context'
     (Context        => In_Ada,
      Anno_Context   => Start_Annotation,
      Line_No        => LexTokenManager.Line_Numbers'First,
      Line_Length    => Line_Lengths'First,
      Last_Token_Pos => Line_Lengths'First,
      Curr_Pos       => Line_Lengths'First,
      Lookahead_Pos  => Line_Lengths'First,
      Conts          => Line'(others => Ada.Characters.Latin_1.NUL));
end SparkLex;
