-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (STree)
function FindLastItemInDependencyRelation (Node : SyntaxNode) return SyntaxNode
--     dependency_relation
--              |
--     dependency_relation_opt
--              |
--     dependency_relation_rep --- [& --- null_import_list]

--             or

--     dependency_relation
--              |
--     dependency_relation_opt
--              |
--        null_import_list

--             or

--     dependency_relation
--              |
--     dependency_relation_opt      (nothing below here in--# derives ; case)

--     dependency_relation_rep
--              |
--     {dependency_relation_rep --- & --- dependency_clause}
--              |
--       dependency_clause

--     dependency_clause
--              |
--     dependency_clause_optrep --- dependency_clause_opt

--     dependency_clause_opt
--              |
--        [*] --- [dependency_clause_optrep]   (or nothing)

--     dependency_clause_optrep
--              |
--     {dependency_clause_optrep --- entire_variable}
--              |
--       entire_variable

--     null_import_list
--              |
--             null --- dependency_clause_optrep ;

is
   TheNextNode : SyntaxNode;

   function FindLastImportOrExport (Node : SyntaxNode) return SyntaxNode
   --# global in Table;
   -- pre node type is SPSymbols.dependency_clause;
   is
      TheNextNode : SyntaxNode;
   begin
      --first see if there are any imports at all
      TheNextNode := Child_Node (Next_Sibling (Child_Node (Node)));
      if TheNextNode /= NullNode then
         --there are some imports
         --first find dependency_clause_optrep if there is one.
         --we must be pointing at one or at a star
         if Syntax_Node_Type (Node => TheNextNode) = SPSymbols.multiply and then Next_Sibling (TheNextNode) /= NullNode then
            TheNextNode := Next_Sibling (TheNextNode);
         end if;
         if Syntax_Node_Type (Node => TheNextNode) = SPSymbols.dependency_clause_optrep then
            --we need to find rightmost entire variable
            TheNextNode := Child_Node (TheNextNode);
            if Syntax_Node_Type (Node => TheNextNode) = SPSymbols.dependency_clause_optrep then
               TheNextNode := Next_Sibling (TheNextNode);
            end if;
         end if;
      else --there are no imports so look at the exports
         TheNextNode := Child_Node (Child_Node (Node));
         --either an entire_variable or a dependency_clause_optrep
         if Syntax_Node_Type (Node => TheNextNode) = SPSymbols.dependency_clause_optrep then
            TheNextNode := Next_Sibling (TheNextNode);
         end if;
      end if;
      return TheNextNode;
   end FindLastImportOrExport;

   function FindLastImportOfNullImportList (Node : SyntaxNode) return SyntaxNode
   --# global in Table;
   -- pre node type is SPSymbols.null_import_list;
   is
      TheNextNode : SyntaxNode;
   begin
      TheNextNode := Child_Node (Next_Sibling (Child_Node (Node)));
      -- TheNextNode is entire_variable or dependency_clause_optrep
      if Syntax_Node_Type (Node => TheNextNode) = SPSymbols.dependency_clause_optrep then
         TheNextNode := Next_Sibling (TheNextNode);
      end if;
      return TheNextNode;
   end FindLastImportOfNullImportList;

begin --Position to report error
      -- First see if there is a null_import_list.  If there is, we know it is the last clause
   TheNextNode := Child_Node (Child_Node (Node));
   if Syntax_Node_Type (Node => TheNextNode) /= SPSymbols.null_import_list then
      -- we don't have a singleton null_import_list but there might still be one to our right; thus:
      TheNextNode := Next_Sibling (Next_Sibling (TheNextNode));
   end if;
   if Syntax_Node_Type (Node => TheNextNode) = SPSymbols.null_import_list then
      --the place to report the error is the last import of the null_import_list
      TheNextNode := FindLastImportOfNullImportList (TheNextNode);
   else
      -- next choice is last of several derives imports if there is one
      TheNextNode := Next_Sibling (Next_Sibling (Child_Node (Child_Node (Child_Node (Node)))));
      if Syntax_Node_Type (Node => TheNextNode) = SPSymbols.dependency_clause then
         --first choice succeded
         TheNextNode := FindLastImportOrExport (TheNextNode);

      else --first choice failed, try single dependency clause
         TheNextNode := Child_Node (Child_Node (Child_Node (Node)));
         if Syntax_Node_Type (Node => TheNextNode) = SPSymbols.dependency_clause then
            --2nd choice succeeded
            TheNextNode := FindLastImportOrExport (TheNextNode);

         else --there is no derives so start trawling the globals

            --first move to mode_global node, if this fails then there 3rd and 4th choice fail
            TheNextNode := Child_Node (Child_Node (Parent_Node (Current_Node => Node)));
            if Syntax_Node_Type (Node => TheNextNode) = SPSymbols.global_definition_rep then
               --3rd or 4th choice are possibilities
               --TheNextNode is the topmost global_definition_rep; this is the new
               --start point for the search for a suitable reporting place.
               --find rightmost global_variable_clause
               if Syntax_Node_Type (Node => Next_Sibling (Child_Node (TheNextNode))) = SPSymbols.global_variable_clause then
                  TheNextNode := Next_Sibling (Child_Node (TheNextNode));
               else
                  TheNextNode := Child_Node (TheNextNode);
               end if;
               --TheNextNode is now rightmost global_variable_clause
               --now find right most gloabl variable in that clause
               --first advance to global_variable_list
               TheNextNode := Next_Sibling (Child_Node (TheNextNode));
               --now find rightmost global variable
               if Syntax_Node_Type (Node => Next_Sibling (Child_Node (TheNextNode))) = SPSymbols.global_variable then
                  TheNextNode := Next_Sibling (Child_Node (TheNextNode));
               else
                  TheNextNode := Child_Node (TheNextNode);
               end if;

            else --only place we can point is the subprogram declaration
               TheNextNode := Parent_Node (Current_Node => Parent_Node (Current_Node => Node));
            end if;
         end if;
      end if;
   end if;

   return TheNextNode;

end FindLastItemInDependencyRelation;
