-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-------------------------------------------------------------------------------
--                                                                           --
-- SPARK.Ada.Text_IO.Not_SPARK                                               --
--                                                                           --
-- Description                                                               --
--   This package provides the features of Ada.Text_IO which are not         --
--   compatible with SPARK. Please refer to the Ada LRM description of       --
--   Ada.Text_IO for usage information.                                      --
--                                                                           --
-------------------------------------------------------------------------------

package SPARK.Ada.Text_IO.Not_SPARK is

   function Name (File : File_Type) return String;
   function Form (File : File_Type) return String;

   procedure Set_Input (File : File_Type);
   procedure Set_Output (File : File_Type);
   procedure Set_Error (File : File_Type);

   function Current_Input return File_Type;
   function Current_Output return File_Type;
   function Current_Error return File_Type;

   type File_Access is new Standard.Ada.Text_IO.File_Access;

   function Standard_Input return File_Access;
   function Standard_Output return File_Access;
   function Standard_Error return File_Access;

   function Current_Input return File_Access;
   function Current_Output return File_Access;
   function Current_Error return File_Access;

   function Get_Line (File : File_Type) return String;
   pragma Ada_05 (Get_Line);

   function Get_Line return String;
   pragma Ada_05 (Get_Line);

   ------------------------------------------------
   -- Conversion functions from SPARK.Ada to Ada --
   ------------------------------------------------

   function To_File_Type
     (From : File_Type) return Standard.Ada.Text_IO.File_Type;
   function To_File_Mode
     (From : File_Mode) return Standard.Ada.Text_IO.File_Mode;
   function To_Type_Set
     (From : Type_Set) return Standard.Ada.Text_IO.Type_Set;

end SPARK.Ada.Text_IO.Not_SPARK;
