-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SPARK.Ada.Strings.Unbounded.Not_SPARK;
with SPARK.Ada.Text_IO.Not_SPARK;

package body SPARK.Ada.Text_IO.Unbounded_String is
   --# hide SPARK.Ada.Text_IO.Unbounded_String;

   pragma Warnings ("Y"); -- Turn off warnings for Ada 2005 features

   procedure Create
     (File :    out Text_IO.File_Type;
      Mode : in     Text_IO.File_Mode;
      Name : in     Strings.Unbounded.Unbounded_String;
      Form : in     Strings.Unbounded.Unbounded_String) is
   begin
      Standard.Ada.Text_IO.Create
        (File => Standard.Ada.Text_IO.File_Type (File),
         Mode => SPARK.Ada.Text_IO.Not_SPARK.To_File_Mode (From => Mode),
         Name => SPARK.Ada.Strings.Unbounded.Not_SPARK.To_String
           (Source => Name),
         Form => SPARK.Ada.Strings.Unbounded.Not_SPARK.To_String
           (Source => Form));
   end Create;

   procedure Open
     (File :    out Text_IO.File_Type;
      Mode : in     Text_IO.File_Mode;
      Name : in     Strings.Unbounded.Unbounded_String;
      Form : in     Strings.Unbounded.Unbounded_String) is
   begin
      Standard.Ada.Text_IO.Open
        (File => Standard.Ada.Text_IO.File_Type (File),
         Mode => SPARK.Ada.Text_IO.Not_SPARK.To_File_Mode (From => Mode),
         Name => SPARK.Ada.Strings.Unbounded.Not_SPARK.To_String
           (Source => Name),
         Form => SPARK.Ada.Strings.Unbounded.Not_SPARK.To_String
           (Source => Form));
   end Open;

   function Name
     (File : Text_IO.File_Type) return Strings.Unbounded.Unbounded_String is
   begin
      return SPARK.Ada.Strings.Unbounded.String_To_Unbounded_String
        (Source => Standard.Ada.Text_IO.Name
           (File => Standard.Ada.Text_IO.File_Type (File)));
   end Name;

   function Form
     (File : Text_IO.File_Type) return Strings.Unbounded.Unbounded_String is
   begin
      return SPARK.Ada.Strings.Unbounded.String_To_Unbounded_String
        (Source => Standard.Ada.Text_IO.Form
           (File => Standard.Ada.Text_IO.File_Type (File)));
   end Form;

   procedure Put_String_File
     (File : in out Text_IO.File_Type;
      Item : in     Strings.Unbounded.Unbounded_String) is
   begin
      Standard.Ada.Text_IO.Put
        (File => Standard.Ada.Text_IO.File_Type (File),
         Item => SPARK.Ada.Strings.Unbounded.Not_SPARK.To_String
           (Source => Item));
   end Put_String_File;

   procedure Put_String_Output (Item : in Strings.Unbounded.Unbounded_String)
   is
   begin
      Standard.Ada.Text_IO.Put
        (File => Standard.Ada.Text_IO.Standard_Output,
         Item => SPARK.Ada.Strings.Unbounded.Not_SPARK.To_String
           (Source => Item));
   end Put_String_Output;

   procedure Put_String_Error (Item : in Strings.Unbounded.Unbounded_String)
   is
   begin
      Standard.Ada.Text_IO.Put
        (File => Standard.Ada.Text_IO.Standard_Error,
         Item => SPARK.Ada.Strings.Unbounded.Not_SPARK.To_String
           (Source => Item));
   end Put_String_Error;

   procedure Procedure_Get_Line_File
     (File     : in out Text_IO.File_Type;
      Item     :    out Strings.Unbounded.Unbounded_String;
      Arg_Last :    out Natural) is
      Tmp_Item : constant String := Standard.Ada.Text_IO.Get_Line
        (File => Standard.Ada.Text_IO.File_Type (File));
   begin
      Item     := SPARK.Ada.Strings.Unbounded.String_To_Unbounded_String
        (Source => Tmp_Item);
      Arg_Last := SPARK.Ada.Strings.Unbounded.Get_Length (Source => Item);
   end Procedure_Get_Line_File;

   procedure Procedure_Get_Line_Input
     (Item     : out Strings.Unbounded.Unbounded_String;
      Arg_Last : out Natural) is
      Tmp_Item : constant String := Standard.Ada.Text_IO.Get_Line
        (File => Standard.Ada.Text_IO.Standard_Input);
   begin
      Item     := SPARK.Ada.Strings.Unbounded.String_To_Unbounded_String
        (Source => Tmp_Item);
      Arg_Last := SPARK.Ada.Strings.Unbounded.Get_Length (Source => Item);
   end Procedure_Get_Line_Input;

   function Function_Get_Line_File
     (File : Text_IO.File_Type) return Strings.Unbounded.Unbounded_String is
   begin
      return SPARK.Ada.Strings.Unbounded.String_To_Unbounded_String
        (Source => Standard.Ada.Text_IO.Get_Line
           (File => Standard.Ada.Text_IO.File_Type (File)));
   end Function_Get_Line_File;

   function Function_Get_Line_Input
     return Strings.Unbounded.Unbounded_String is
   begin
      return SPARK.Ada.Strings.Unbounded.String_To_Unbounded_String
        (Source => Standard.Ada.Text_IO.Get_Line
           (File => Standard.Ada.Text_IO.Standard_Input));
   end Function_Get_Line_Input;

   procedure Put_Line_File (File : in out Text_IO.File_Type;
                            Item : in     Strings.Unbounded.Unbounded_String)
   is
   begin
      Standard.Ada.Text_IO.Put_Line
        (File => Standard.Ada.Text_IO.File_Type (File),
         Item => SPARK.Ada.Strings.Unbounded.Not_SPARK.To_String
           (Source => Item));
   end Put_Line_File;

   procedure Put_Line_Output (Item : in Strings.Unbounded.Unbounded_String)
   is
   begin
      Standard.Ada.Text_IO.Put_Line
        (File => Standard.Ada.Text_IO.Standard_Output,
         Item => SPARK.Ada.Strings.Unbounded.Not_SPARK.To_String
           (Source => Item));
   end Put_Line_Output;

   procedure Put_Line_Error (Item : in Strings.Unbounded.Unbounded_String)
   is
   begin
      Standard.Ada.Text_IO.Put_Line
        (File => Standard.Ada.Text_IO.Standard_Error,
         Item => SPARK.Ada.Strings.Unbounded.Not_SPARK.To_String
           (Source => Item));
   end Put_Line_Error;

end SPARK.Ada.Text_IO.Unbounded_String;
