-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with E_Strings;
with StringList;

--# inherit CommandLine,
--#         CommandLineData,
--#         Directory_Operations,
--#         E_Strings,
--#         FileSystem,
--#         RegularExpression,
--#         SparkMakeDebug,
--#         SparkMakeErrors,
--#         SPARK_IO,
--#         StringList,
--#         SystemErrors,
--#         Version;

package SparkMakeCommandLine
--# own State;
is

   -- Switches:
   --   -meta=filename           filename is the name of the output meta file
   --                            Default: rootfilename.smf
   --
   --   -nometafile              Do not produce a meta file
   --                            Default: False
   --
   --   -index=filename          filename is the name of the index file output
   --                            Default: rootfilename.idx
   --
   --   -noindexfile             Do not produce an index file
   --                            Default: False
   --
   --   -path=Full | Relative    Full or Relative path names in output files
   --                            Default: Full
   --
   --   -language=83 | 95 | 2005 Select language. Default is 95.
   --
   --   -debug                   outputs additional debug info as the make progresses
   --                            Default: Full
   --
   --   -duplicates_are_errors   Fails if duplicate files are found
   --                            Default : False
   --
   --   -directory=dirname       Tells make to look in and under these directories
   --                            Current directory is always searched and is the default.
   --
   --   -include=regexp          include these files
   --                            Default: *.ad[bs]
   --
   --   -exclude=regexp          exclude these files
   --                            Default: exclude no files
   --
   --   -annotation_character=char
   --                            Recognise this character as annotation character
   --                            Default: #
   --
   --   -help                    prints off help information
   --
   --   -version                 prints off version information
   --
   -- Arguments
   --   rootfilename             Filename is the root of the make. If not specified
   --                            then index and meta files for analysis of all files
   --                            in the directory (and subdirectories) will be generated
   --                            named spark.idx and spark.smf.
   --

   ----------------------------------------------------------------------
   -- Constructor
   ----------------------------------------------------------------------

   procedure Process (Success           : out Boolean;
                      Help_Or_Ver_Found : out Boolean);
   --# global in     CommandLine.State;
   --#        in out CommandLineData.Content;
   --#        in out SPARK_IO.File_Sys;
   --#           out State;
   --# derives CommandLineData.Content,
   --#         SPARK_IO.File_Sys       from *,
   --#                                      CommandLine.State &
   --#         Help_Or_Ver_Found,
   --#         State,
   --#         Success                 from CommandLine.State;

   ----------------------------------------------------------------------
   -- Accessors
   ----------------------------------------------------------------------

   type Path_Type is (Undefined, Full, Relative);

   function Path_Required return Path_Type;
   --# global in State;

   function Meta_Filename return  E_Strings.T;
   --# global in State;

   function Index_Filename return  E_Strings.T;
   --# global in State;

   function Root_Filename return  E_Strings.T;
   --# global in State;

   function Duplicates_Error return Boolean;
   --# global in State;

   function The_Directory_Names return  StringList.Object;
   --# global in State;

   function The_Inc_File_Reg_Exps return  StringList.Object;
   --# global in State;

   function The_Exc_File_Reg_Exps return  StringList.Object;
   --# global in State;

   function Debug_On return Boolean;
   --# global in State;

   function No_Meta_File return Boolean;
   --# global in State;

   function No_Index_File return Boolean;
   --# global in State;

end SparkMakeCommandLine;
