-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
procedure AddSubprogramParameter
  (Name          : in LexTokenManager.Lex_String;
   Subprogram    : in Symbol;
   TypeMark      : in Symbol;
   TypeReference : in Location;
   Mode          : in Modes;
   Comp_Unit     : in ContextManager.UnitDescriptors;
   Specification : in Location) is

   Parameter : Symbol;
   Previous  : Symbol;

   --------------------------------------------------------------------------------

   procedure WriteSubprogramParameterSpecification (Parameter     : in Symbol;
                                                    Specification : in Location)
   --# global in     Dict;
   --#        in     LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Dict,
   --#                                LexTokenManager.State,
   --#                                Parameter,
   --#                                Specification;
   is
   begin
      if SPARK_IO.Is_Open (Dict.TemporaryFile) then
         WriteString (Dict.TemporaryFile, "specification of ");
         WriteName (Dict.TemporaryFile, Parameter);
         WriteString (Dict.TemporaryFile, " is at ");
         WriteLocation (Dict.TemporaryFile, Specification);
         WriteLine (Dict.TemporaryFile, " ;");
      end if;
   end WriteSubprogramParameterSpecification;

   --------------------------------------------------------------------------------

   procedure AddConstraintSymbolsIfNeeded
     (TypeMark      : in Symbol;
      TheParameter  : in Symbol;
      Comp_Unit     : in ContextManager.UnitDescriptors;
      Specification : in Location)
   --# global in out Dict;
   --# derives Dict from *,
   --#                   Comp_Unit,
   --#                   Specification,
   --#                   TheParameter,
   --#                   TypeMark;
   is
      procedure AddConstraintSymbol
        (TheParameter  : in Symbol;
         Comp_Unit     : in ContextManager.UnitDescriptors;
         Specification : in Location;
         Dimension     : in Positive)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Comp_Unit,
      --#                   Dimension,
      --#                   Specification,
      --#                   TheParameter;
      is
         NewConstraint : Symbol;
      begin
         RawDict.CreateParameterConstraint
           (TheParameter     => TheParameter,
            Dimension        => Dimension,
            Comp_Unit        => Comp_Unit,
            Loc              => Specification.Start_Position,
            ConstraintSymbol => NewConstraint);
         -- Now link new constraint to subprogram parameter - list ends up in dimension order
         RawDict.SetParameterConstraintNext (NewConstraint, RawDict.GetSubprogramParameterIndexConstraints (TheParameter));
         RawDict.SetSubprogramParameterIndexConstraints (TheParameter, NewConstraint);
      end AddConstraintSymbol;

   begin -- AddConstraintSymbolsIfNeeded
      if IsUnconstrainedArrayType (TypeMark) then
         for I in reverse Positive range 1 .. GetNumberOfDimensions (TypeMark) loop
            AddConstraintSymbol
              (TheParameter  => TheParameter,
               Comp_Unit     => Comp_Unit,
               Specification => Specification,
               Dimension     => I);
         end loop;
      end if;
   end AddConstraintSymbolsIfNeeded;

   --------------------------------------------------------------------------------

begin -- AddSubprogramParameter

   RawDict.CreateSubprogramParameter
     (Name       => Name,
      Subprogram => Subprogram,
      TypeMark   => TypeMark,
      Mode       => Mode,
      Comp_Unit  => Comp_Unit,
      Loc        => Specification.Start_Position,
      Parameter  => Parameter);

   Previous := RawDict.GetSubprogramLastParameter (Subprogram);

   if Previous = NullSymbol then
      RawDict.SetSubprogramFirstParameter (Subprogram, Parameter);
   else
      RawDict.SetNextSubprogramParameter (Previous, Parameter);
   end if;

   RawDict.SetSubprogramLastParameter (Subprogram, Parameter);

   AddConstraintSymbolsIfNeeded
     (TypeMark      => TypeMark,
      TheParameter  => Parameter,
      Comp_Unit     => Comp_Unit,
      Specification => Specification);

   if not TypeIsUnknown (TypeMark) then
      AddOtherReference (TypeMark, Subprogram, TypeReference);
   end if;

   WriteSubprogramParameterSpecification (Parameter, Specification);

end AddSubprogramParameter;
