/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Tue Jul 14 19:02:34 2020

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_47 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 20935, "epsg", 20935,
        "Arc 1950 / UTM zone 35S", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Arc_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-143,-90,-294,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1950 / UTM zone 35S\",GEOGCS[\"Arc 1950\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1950\",SPHEROID[\"Clarke 1880 (Arc)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.4663077,AUTHORITY[\"EPSG\",\"7013\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6209\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4209\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",27],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"209");
    add_srs_wkt (p, 12,
        "35\"]]");
    p = add_epsg_def_ex (filter, first, last, 20936, "epsg", 20936,
        "Arc 1950 / UTM zone 36S", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Arc_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-143,-90,-294,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1950 / UTM zone 36S\",GEOGCS[\"Arc 1950\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1950\",SPHEROID[\"Clarke 1880 (Arc)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.4663077,AUTHORITY[\"EPSG\",\"7013\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6209\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4209\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",33],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"209");
    add_srs_wkt (p, 12,
        "36\"]]");
    p = add_epsg_def_ex (filter, first, last, 21035, "epsg", 21035,
        "Arc 1960 / UTM zone 35S", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +ellps=clrk80 +towgs84=-160,-6");
    add_proj4text (p, 1,
        ",-302,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 35S\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6210\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4210\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",27],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",10000000],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21035\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21036, "epsg", 21036,
        "Arc 1960 / UTM zone 36S", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +ellps=clrk80 +towgs84=-160,-6");
    add_proj4text (p, 1,
        ",-302,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 36S\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6210\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4210\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",33],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",10000000],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21036\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21037, "epsg", 21037,
        "Arc 1960 / UTM zone 37S", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +south +ellps=clrk80 +towgs84=-160,-6");
    add_proj4text (p, 1,
        ",-302,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 37S\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6210\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4210\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",39],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",10000000],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21037\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21095, "epsg", 21095,
        "Arc 1960 / UTM zone 35N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=clrk80 +towgs84=-160,-6,-302,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 35N\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6210\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4210\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",27],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21095\"]]");
    p = add_epsg_def_ex (filter, first, last, 21096, "epsg", 21096,
        "Arc 1960 / UTM zone 36N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=clrk80 +towgs84=-160,-6,-302,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 36N\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6210\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4210\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",33],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21096\"]]");
    p = add_epsg_def_ex (filter, first, last, 21097, "epsg", 21097,
        "Arc 1960 / UTM zone 37N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=clrk80 +towgs84=-160,-6,-302,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 37N\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6210\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4210\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",39],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21097\"]]");
    p = add_epsg_def_ex (filter, first, last, 21100, "epsg", 21100,
        "Batavia / NEIEZ", 0, 0,
        "Bessel 1841", "Greenwich",
        "Batavia", "Mercator_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +pm=jakarta ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia / NEIEZ\",GEOGCS[\"Batavia\",DATUM[\"Ba");
    add_srs_wkt (p, 1,
        "tavia\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6211");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4211\"]],PROJECTION[\"Me");
    add_srs_wkt (p, 6,
        "rcator_1SP\"],PARAMETER[\"central_meridian\",110],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"scale_factor\",0.997],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 8,
        "3900000],PARAMETER[\"false_northing\",900000],UNIT[\"met");
    add_srs_wkt (p, 9,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 10,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3001\"");
    add_srs_wkt (p, 11,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21148, "epsg", 21148,
        "Batavia / UTM zone 48S", 0, 0,
        "Bessel 1841", "Greenwich",
        "Batavia", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=bessel +towgs84=-377,68");
    add_proj4text (p, 1,
        "1,-50,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia / UTM zone 48S\",GEOGCS[\"Batavia\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Batavia\",SPHEROID[\"Bessel 1841\",6377397.155,299.");
    add_srs_wkt (p, 2,
        "1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6211\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4211\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",105],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21148\"]]");
    p = add_epsg_def_ex (filter, first, last, 21149, "epsg", 21149,
        "Batavia / UTM zone 49S", 0, 0,
        "Bessel 1841", "Greenwich",
        "Batavia", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=bessel +towgs84=-377,68");
    add_proj4text (p, 1,
        "1,-50,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia / UTM zone 49S\",GEOGCS[\"Batavia\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Batavia\",SPHEROID[\"Bessel 1841\",6377397.155,299.");
    add_srs_wkt (p, 2,
        "1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6211\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4211\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",111],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21149\"]]");
    p = add_epsg_def_ex (filter, first, last, 21150, "epsg", 21150,
        "Batavia / UTM zone 50S", 0, 0,
        "Bessel 1841", "Greenwich",
        "Batavia", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=bessel +towgs84=-377,68");
    add_proj4text (p, 1,
        "1,-50,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia / UTM zone 50S\",GEOGCS[\"Batavia\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Batavia\",SPHEROID[\"Bessel 1841\",6377397.155,299.");
    add_srs_wkt (p, 2,
        "1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6211\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4211\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",117],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",0.9996],PARAMETER[\"false_easting\",50000");
    add_srs_wkt (p, 9,
        "0],PARAMETER[\"false_northing\",10000000],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21150\"]]");
    p = add_epsg_def_ex (filter, first, last, 21291, "epsg", 21291,
        "Barbados 1938 / British West Indies Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Barbados_1938", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
        "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=31.95,300.99,419");
    add_proj4text (p, 2,
        ".19,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Barbados 1938 / British West Indies Grid\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Barbados 1938\",DATUM[\"Barbados_1938\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7012\"]],AUTHORITY[\"EPSG\",\"6212\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4212\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-62],PARAMETER[\"scale_factor\",0.9995],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",400000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"21291\"]]");
    p = add_epsg_def_ex (filter, first, last, 21292, "epsg", 21292,
        "Barbados 1938 / Barbados National Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Barbados_1938", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=13.17638888888889 +lon_0=-59.55972222");
    add_proj4text (p, 1,
        "222222 +k=0.9999986 +x_0=30000 +y_0=75000 +ellps=clrk80 ");
    add_proj4text (p, 2,
        "+towgs84=31.95,300.99,419.19,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Barbados 1938 / Barbados National Grid\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Barbados 1938\",DATUM[\"Barbados_1938\",SPHEROID[\"Cl");
    add_srs_wkt (p, 2,
        "arke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7012\"]],AUTHORITY[\"EPSG\",\"6212\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4212\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",13.1763888888889],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-59.5597222222222],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9999986],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",30000],PARAMETER[\"false_northing\",75000],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21292\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 21413, "epsg", 21413,
        "Beijing 1954 / Gauss-Kruger zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 13\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",13500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21413");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 21414, "epsg", 21414,
        "Beijing 1954 / Gauss-Kruger zone 14", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",14500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21414");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 21415, "epsg", 21415,
        "Beijing 1954 / Gauss-Kruger zone 15", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 15\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",15500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21415");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 21416, "epsg", 21416,
        "Beijing 1954 / Gauss-Kruger zone 16", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",16500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21416");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 21417, "epsg", 21417,
        "Beijing 1954 / Gauss-Kruger zone 17", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 17\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",17500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",");
    add_srs_wkt (p, 11,
        "NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21417");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 21418, "epsg", 21418,
        "Beijing 1954 / Gauss-Kruger zone 18", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",18500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2141");
    add_srs_wkt (p, 12,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 21419, "epsg", 21419,
        "Beijing 1954 / Gauss-Kruger zone 19", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 19\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",19500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2141");
    add_srs_wkt (p, 12,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 21420, "epsg", 21420,
        "Beijing 1954 / Gauss-Kruger zone 20", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 20\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",20500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2142");
    add_srs_wkt (p, 12,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 21421, "epsg", 21421,
        "Beijing 1954 / Gauss-Kruger zone 21", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 21\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",21500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2142");
    add_srs_wkt (p, 12,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 21422, "epsg", 21422,
        "Beijing 1954 / Gauss-Kruger zone 22", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 22\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",22500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2142");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 21423, "epsg", 21423,
        "Beijing 1954 / Gauss-Kruger zone 23", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 23\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",23500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2142");
    add_srs_wkt (p, 12,
        "3\"]]");
    p = add_epsg_def_ex (filter, first, last, 21453, "epsg", 21453,
        "Beijing 1954 / Gauss-Kruger CM 75E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 75E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21453\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21454, "epsg", 21454,
        "Beijing 1954 / Gauss-Kruger CM 81E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 81E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21454\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21455, "epsg", 21455,
        "Beijing 1954 / Gauss-Kruger CM 87E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 87E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21455\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21456, "epsg", 21456,
        "Beijing 1954 / Gauss-Kruger CM 93E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 93E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21456\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21457, "epsg", 21457,
        "Beijing 1954 / Gauss-Kruger CM 99E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 99E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21457\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21458, "epsg", 21458,
        "Beijing 1954 / Gauss-Kruger CM 105E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 105E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21458\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21459, "epsg", 21459,
        "Beijing 1954 / Gauss-Kruger CM 111E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 111E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21459\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21460, "epsg", 21460,
        "Beijing 1954 / Gauss-Kruger CM 117E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 117E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21460\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21461, "epsg", 21461,
        "Beijing 1954 / Gauss-Kruger CM 123E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 123E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21461\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21462, "epsg", 21462,
        "Beijing 1954 / Gauss-Kruger CM 129E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 129E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21462\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21463, "epsg", 21463,
        "Beijing 1954 / Gauss-Kruger CM 135E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 135E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21463\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21473, "epsg", 21473,
        "Beijing 1954 / Gauss-Kruger CM 75E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 75E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21453\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21474, "epsg", 21474,
        "Beijing 1954 / Gauss-Kruger CM 81E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 81E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21454\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21475, "epsg", 21475,
        "Beijing 1954 / Gauss-Kruger CM 87E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 87E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21455\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21476, "epsg", 21476,
        "Beijing 1954 / Gauss-Kruger CM 93E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 93E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21456\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21477, "epsg", 21477,
        "Beijing 1954 / Gauss-Kruger CM 99E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 99E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NO");
    add_srs_wkt (p, 11,
        "RTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21457\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21478, "epsg", 21478,
        "Beijing 1954 / Gauss-Kruger CM 105E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 105E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21458\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21479, "epsg", 21479,
        "Beijing 1954 / Gauss-Kruger CM 111E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 111E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21459\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21480, "epsg", 21480,
        "Beijing 1954 / Gauss-Kruger CM 117E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 117E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21460\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21481, "epsg", 21481,
        "Beijing 1954 / Gauss-Kruger CM 123E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 123E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21461\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21482, "epsg", 21482,
        "Beijing 1954 / Gauss-Kruger CM 129E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 129E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21462\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21483, "epsg", 21483,
        "Beijing 1954 / Gauss-Kruger CM 135E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 135E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4214\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",N");
    add_srs_wkt (p, 11,
        "ORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"21463\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 21500, "epsg", 21500,
        "Belge 1950 (Brussels) / Belge Lambert 50", 0, 0,
        "International 1924", "Brussels",
        "Reseau_National_Belge_1950_Brussels", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49.83333333333334 +lat_2=51.16666666666");
    add_proj4text (p, 1,
        "666 +lat_0=90 +lon_0=0 +x_0=150000 +y_0=5400000 +ellps=i");
    add_proj4text (p, 2,
        "ntl +pm=brussels +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Belge 1950 (Brussels) / Belge Lambert 50\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Belge 1950 (Brussels)\",DATUM[\"Reseau_National_Bel");
    add_srs_wkt (p, 2,
        "ge_1950_Brussels\",SPHEROID[\"International 1924\",63783");
    add_srs_wkt (p, 3,
        "88,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6809\"]],PRIMEM[\"Brussels\",4.367975,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8910\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4809\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",90],PARAMETER[\"central_meridian\",0],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",49.8333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"standard_parallel_2\",51.1666666666667],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",150000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",5400000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"21500\"]]");
    p = add_epsg_def_ex (filter, first, last, 21780, "epsg", 21780,
        "Bern 1898 (Bern) / LV03C", 0, 0,
        "Bessel 1841", "Bern",
        "CH1903_Bern", "Hotine_Oblique_Mercator_Azimuth_Center", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=somerc +lat_0=46.95240555555556 +lon_0=0 +k_0=1 +x");
    add_proj4text (p, 1,
        "_0=0 +y_0=0 +ellps=bessel +towgs84=674.374,15.056,405.34");
    add_proj4text (p, 2,
        "6,0,0,0,0 +pm=bern +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bern 1898 (Bern) / LV03C\",GEOGCS[\"Bern 1898 (");
    add_srs_wkt (p, 1,
        "Bern)\",DATUM[\"CH1903_Bern\",SPHEROID[\"Bessel 1841\",6");
    add_srs_wkt (p, 2,
        "377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6801\"]],PRIMEM[\"Bern\",7.43958333333");
    add_srs_wkt (p, 4,
        "333,AUTHORITY[\"EPSG\",\"8907\"]],UNIT[\"degree\",0.0174");
    add_srs_wkt (p, 5,
        "532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"4801\"]],PROJECTION[\"Hotine_Oblique_Mercator_Az");
    add_srs_wkt (p, 7,
        "imuth_Center\"],PARAMETER[\"latitude_of_center\",46.9524");
    add_srs_wkt (p, 8,
        "055555556],PARAMETER[\"longitude_of_center\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"azimuth\",90],PARAMETER[\"rectified_grid_angle\",90]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21780\"]]");
    p = add_epsg_def_ex (filter, first, last, 21781, "epsg", 21781,
        "CH1903 / LV03", 0, 0,
        "Bessel 1841", "Greenwich",
        "CH1903", "Hotine_Oblique_Mercator_Azimuth_Center", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333");
    add_proj4text (p, 1,
        "333333 +k_0=1 +x_0=600000 +y_0=200000 +ellps=bessel +tow");
    add_proj4text (p, 2,
        "gs84=674.374,15.056,405.346,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CH1903 / LV03\",GEOGCS[\"CH1903\",DATUM[\"CH190");
    add_srs_wkt (p, 1,
        "3\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6149\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4149\"]],PROJECTION[\"Hotine");
    add_srs_wkt (p, 6,
        "_Oblique_Mercator_Azimuth_Center\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_center\",46.9524055555556],PARAMETER[\"longitude_of_");
    add_srs_wkt (p, 8,
        "center\",7.43958333333333],PARAMETER[\"azimuth\",90],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"rectified_grid_angle\",90],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",1],PARAMETER[\"false_easting\",600000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",200000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"21781\"]]");
    p = add_epsg_def_ex (filter, first, last, 21782, "epsg", 21782,
        "CH1903 / LV03C-G", 0, 0,
        "Bessel 1841", "Greenwich",
        "CH1903", "Hotine_Oblique_Mercator_Azimuth_Center", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333");
    add_proj4text (p, 1,
        "333333 +k_0=1 +x_0=0 +y_0=0 +ellps=bessel +towgs84=674.3");
    add_proj4text (p, 2,
        "74,15.056,405.346,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CH1903 / LV03C-G\",GEOGCS[\"CH1903\",DATUM[\"CH");
    add_srs_wkt (p, 1,
        "1903\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6149\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4149\"]],PROJECTION[\"Hoti");
    add_srs_wkt (p, 6,
        "ne_Oblique_Mercator_Azimuth_Center\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 7,
        "de_of_center\",46.9524055555556],PARAMETER[\"longitude_o");
    add_srs_wkt (p, 8,
        "f_center\",7.43958333333333],PARAMETER[\"azimuth\",90],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"rectified_grid_angle\",90],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"21782\"]]");
    p = add_epsg_def_ex (filter, first, last, 21817, "epsg", 21817,
        "Bogota 1975 / UTM zone 17N (deprecated)", 0, 0,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=intl +towgs84=307,304,-318,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / UTM zone 17N (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Bogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Inter");
    add_srs_wkt (p, 2,
        "national 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6218\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4218\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"21817\"]]");
    p = add_epsg_def_ex (filter, first, last, 21818, "epsg", 21818,
        "Bogota 1975 / UTM zone 18N", 0, 0,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=intl +towgs84=307,304,-318,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / UTM zone 18N\",GEOGCS[\"Bogota 19");
    add_srs_wkt (p, 1,
        "75\",DATUM[\"Bogota_1975\",SPHEROID[\"International 1924");
    add_srs_wkt (p, 2,
        "\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"6218\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4218\"]],PR");
    add_srs_wkt (p, 6,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",-75],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21818\"]]");
    p = add_epsg_def_ex (filter, first, last, 21891, "epsg", 21891,
        "Bogota 1975 / Colombia West zone", 0, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-77.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia West zone\",GEOGCS[\"Bog");
    add_srs_wkt (p, 1,
        "ota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6218\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4218");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",4.59904722222222],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-77.0809166666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",1],PARAMETER[\"false_easting\",1000000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"21896\"]]");
    p = add_epsg_def_ex (filter, first, last, 21892, "epsg", 21892,
        "Bogota 1975 / Colombia Bogota zone", 0, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-74.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia Bogota zone\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "ogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Internatio");
    add_srs_wkt (p, 2,
        "nal 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6218\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "18\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",4.59904722222222],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-74.0809166666667],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",1000000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"21897\"]]");
    p = add_epsg_def_ex (filter, first, last, 21893, "epsg", 21893,
        "Bogota 1975 / Colombia East Central zone", 0, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-71.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia East Central zone\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Bogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6218\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4218\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",4.59904722222222],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-71.0809166666667],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",1000000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AUTHORITY[\"EPSG\",\"21898\"]]");
    p = add_epsg_def_ex (filter, first, last, 21894, "epsg", 21894,
        "Bogota 1975 / Colombia East zone", 0, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-68.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia East zone\",GEOGCS[\"Bog");
    add_srs_wkt (p, 1,
        "ota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6218\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4218");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",4.59904722222222],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-68.0809166666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",1],PARAMETER[\"false_easting\",1000000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"21899\"]]");
    p = add_epsg_def_ex (filter, first, last, 21896, "epsg", 21896,
        "Bogota 1975 / Colombia West zone", 0, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-77.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia West zone\",GEOGCS[\"Bog");
    add_srs_wkt (p, 1,
        "ota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6218\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4218");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",4.59904722222222],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-77.0809166666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",1],PARAMETER[\"false_easting\",1000000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"21896\"]]");
    p = add_epsg_def_ex (filter, first, last, 21897, "epsg", 21897,
        "Bogota 1975 / Colombia Bogota zone", 0, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-74.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia Bogota zone\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "ogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Internatio");
    add_srs_wkt (p, 2,
        "nal 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6218\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "18\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",4.59904722222222],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-74.0809166666667],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",1],PARAMETER[\"false_easting\",1000000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"21897\"]]");
    p = add_epsg_def_ex (filter, first, last, 21898, "epsg", 21898,
        "Bogota 1975 / Colombia East Central zone", 0, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-71.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia East Central zone\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Bogota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Inte");
    add_srs_wkt (p, 2,
        "rnational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6218\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4218\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",4.59904722222222],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-71.0809166666667],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",1],PARAMETER[\"false_easting\",1000000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AUTHORITY[\"EPSG\",\"21898\"]]");
    p = add_epsg_def_ex (filter, first, last, 21899, "epsg", 21899,
        "Bogota 1975 / Colombia East zone", 0, 1,
        "International 1924", "Greenwich",
        "Bogota_1975", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.599047222222222 +lon_0=-68.08091666");
    add_proj4text (p, 1,
        "666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=307,304,-318,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bogota 1975 / Colombia East zone\",GEOGCS[\"Bog");
    add_srs_wkt (p, 1,
        "ota 1975\",DATUM[\"Bogota_1975\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6218\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4218");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",4.59904722222222],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-68.0809166666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",1],PARAMETER[\"false_easting\",1000000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",1000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"21899\"]]");
    p = add_epsg_def_ex (filter, first, last, 22032, "epsg", 22032,
        "Camacupa 1948 / UTM zone 32S", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Camacupa_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=clrk80 +towgs84=-50.9,-");
    add_proj4text (p, 1,
        "347.6,-231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Camacupa 1948 / UTM zone 32S\",GEOGCS[\"Camacup");
    add_srs_wkt (p, 1,
        "a 1948\",DATUM[\"Camacupa_1948\",SPHEROID[\"Clarke 1880 ");
    add_srs_wkt (p, 2,
        "(RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6220\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4220\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"22032\"]]");
    p = add_epsg_def_ex (filter, first, last, 22033, "epsg", 22033,
        "Camacupa 1948 / UTM zone 33S", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Camacupa_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +south +ellps=clrk80 +towgs84=-50.9,-");
    add_proj4text (p, 1,
        "347.6,-231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Camacupa 1948 / UTM zone 33S\",GEOGCS[\"Camacup");
    add_srs_wkt (p, 1,
        "a 1948\",DATUM[\"Camacupa_1948\",SPHEROID[\"Clarke 1880 ");
    add_srs_wkt (p, 2,
        "(RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6220\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4220\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",10000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"22033\"]]");
    p = add_epsg_def_ex (filter, first, last, 22091, "epsg", 22091,
        "Camacupa 1948 / TM 11.30 SE", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Camacupa_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11.5 +k=0.9996 +x_0=500000 +");
    add_proj4text (p, 1,
        "y_0=10000000 +ellps=clrk80 +towgs84=-50.9,-347.6,-231,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Camacupa 1948 / TM 11.30 SE\",GEOGCS[\"Camacupa");
    add_srs_wkt (p, 1,
        " 1948\",DATUM[\"Camacupa_1948\",SPHEROID[\"Clarke 1880 (");
    add_srs_wkt (p, 2,
        "RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6220\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4220\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",11.5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",10000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"22091\"]]");
    p = add_epsg_def_ex (filter, first, last, 22092, "epsg", 22092,
        "Camacupa 1948 / TM 12 SE", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Camacupa_1948", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=10000000 +ellps=clrk80 +towgs84=-50.9,-347.6,-231,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Camacupa 1948 / TM 12 SE\",GEOGCS[\"Camacupa 19");
    add_srs_wkt (p, 1,
        "48\",DATUM[\"Camacupa_1948\",SPHEROID[\"Clarke 1880 (RGS");
    add_srs_wkt (p, 2,
        ")\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6220\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "220\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "2],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 10,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 11,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"22092\"]]");
    p = add_epsg_def_ex (filter, first, last, 22171, "epsg", 22171,
        "POSGAR 98 / Argentina 1", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 1\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6190\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4190\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-72],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",1500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"22171\"]]");
    p = add_epsg_def_ex (filter, first, last, 22172, "epsg", 22172,
        "POSGAR 98 / Argentina 2", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 2\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6190\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4190\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-69],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",2500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"22172\"]]");
    p = add_epsg_def_ex (filter, first, last, 22173, "epsg", 22173,
        "POSGAR 98 / Argentina 3", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 3\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6190\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4190\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-66],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",3500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"22173\"]]");
    p = add_epsg_def_ex (filter, first, last, 22174, "epsg", 22174,
        "POSGAR 98 / Argentina 4", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 4\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6190\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4190\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-63],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",4500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"22174\"]]");
    p = add_epsg_def_ex (filter, first, last, 22175, "epsg", 22175,
        "POSGAR 98 / Argentina 5", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 5\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6190\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4190\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-60],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",5500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"22175\"]]");
    p = add_epsg_def_ex (filter, first, last, 22176, "epsg", 22176,
        "POSGAR 98 / Argentina 6", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 6\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6190\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4190\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-57],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",6500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"22176\"]]");
    p = add_epsg_def_ex (filter, first, last, 22177, "epsg", 22177,
        "POSGAR 98 / Argentina 7", 0, 1,
        "GRS 1980", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1998", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 98 / Argentina 7\",GEOGCS[\"POSGAR 98\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1998\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],AUTHORITY[\"EPSG\",\"6190\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4190\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-54],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",7500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"22177\"]]");
    p = add_epsg_def_ex (filter, first, last, 22181, "epsg", 22181,
        "POSGAR 94 / Argentina 1", 0, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 1\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],AUTHORITY[\"EPSG\",\"6694\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4694\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-72],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",1500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"22181\"]]");
    p = add_epsg_def_ex (filter, first, last, 22182, "epsg", 22182,
        "POSGAR 94 / Argentina 2", 0, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 2\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],AUTHORITY[\"EPSG\",\"6694\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4694\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-69],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",2500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"22182\"]]");
    p = add_epsg_def_ex (filter, first, last, 22183, "epsg", 22183,
        "POSGAR 94 / Argentina 3", 0, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 3\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],AUTHORITY[\"EPSG\",\"6694\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4694\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-66],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",3500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"22183\"]]");
    p = add_epsg_def_ex (filter, first, last, 22184, "epsg", 22184,
        "POSGAR 94 / Argentina 4", 0, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 4\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],AUTHORITY[\"EPSG\",\"6694\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4694\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-63],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",4500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"22184\"]]");
    p = add_epsg_def_ex (filter, first, last, 22185, "epsg", 22185,
        "POSGAR 94 / Argentina 5", 0, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 5\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],AUTHORITY[\"EPSG\",\"6694\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4694\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-60],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",5500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"22185\"]]");
    p = add_epsg_def_ex (filter, first, last, 22186, "epsg", 22186,
        "POSGAR 94 / Argentina 6", 0, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 6\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],AUTHORITY[\"EPSG\",\"6694\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4694\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-57],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",6500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"22186\"]]");
    p = add_epsg_def_ex (filter, first, last, 22187, "epsg", 22187,
        "POSGAR 94 / Argentina 7", 0, 1,
        "WGS 84", "Greenwich",
        "Posiciones_Geodesicas_Argentinas_1994", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"POSGAR 94 / Argentina 7\",GEOGCS[\"POSGAR 94\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Posiciones_Geodesicas_Argentinas_1994\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "030\"]],AUTHORITY[\"EPSG\",\"6694\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4694\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-54],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",7500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"22187\"]]");
    p = add_epsg_def_ex (filter, first, last, 22191, "epsg", 22191,
        "Campo Inchauspe / Argentina 1", 0, 1,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 1\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6221\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4221\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-90],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-72],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",1500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2219");
    add_srs_wkt (p, 12,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 22192, "epsg", 22192,
        "Campo Inchauspe / Argentina 2", 0, 1,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 2\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6221\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4221\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-90],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-69],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",2500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2219");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 22193, "epsg", 22193,
        "Campo Inchauspe / Argentina 3", 0, 1,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 3\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6221\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4221\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-90],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-66],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",3500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2219");
    add_srs_wkt (p, 12,
        "3\"]]");
    p = add_epsg_def_ex (filter, first, last, 22194, "epsg", 22194,
        "Campo Inchauspe / Argentina 4", 0, 1,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 4\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6221\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4221\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-90],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-63],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2219");
    add_srs_wkt (p, 12,
        "4\"]]");
    p = add_epsg_def_ex (filter, first, last, 22195, "epsg", 22195,
        "Campo Inchauspe / Argentina 5", 0, 1,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 5\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6221\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4221\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-90],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-60],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",5500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2219");
    add_srs_wkt (p, 12,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 22196, "epsg", 22196,
        "Campo Inchauspe / Argentina 6", 0, 1,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 6\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6221\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4221\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-90],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-57],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",6500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2219");
    add_srs_wkt (p, 12,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 22197, "epsg", 22197,
        "Campo Inchauspe / Argentina 7", 0, 1,
        "International 1924", "Greenwich",
        "Campo_Inchauspe", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Campo Inchauspe / Argentina 7\",GEOGCS[\"Campo ");
    add_srs_wkt (p, 1,
        "Inchauspe\",DATUM[\"Campo_Inchauspe\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6221\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4221\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-90],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-54],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",7500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2219");
    add_srs_wkt (p, 12,
        "7\"]]");
    p = add_epsg_def_ex (filter, first, last, 22234, "epsg", 22234,
        "Cape / UTM zone 34S", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / UTM zone 34S\",GEOGCS[\"Cape\",DATUM[\"C");
    add_srs_wkt (p, 1,
        "ape\",SPHEROID[\"Clarke 1880 (Arc)\",6378249.145,293.466");
    add_srs_wkt (p, 2,
        "3077,AUTHORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6222\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4222\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",21],PARAMETER[\"scale");
    add_srs_wkt (p, 8,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"22234\"]]");
    p = add_epsg_def_ex (filter, first, last, 22235, "epsg", 22235,
        "Cape / UTM zone 35S", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / UTM zone 35S\",GEOGCS[\"Cape\",DATUM[\"C");
    add_srs_wkt (p, 1,
        "ape\",SPHEROID[\"Clarke 1880 (Arc)\",6378249.145,293.466");
    add_srs_wkt (p, 2,
        "3077,AUTHORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6222\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4222\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",27],PARAMETER[\"scale");
    add_srs_wkt (p, 8,
        "_factor\",0.9996],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 10,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"22235\"]]");
    p = add_epsg_def_ex (filter, first, last, 22236, "epsg", 22236,
        "Cape / UTM zone 36S (deprecated)", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / UTM zone 36S (deprecated)\",GEOGCS[\"Cap");
    add_srs_wkt (p, 1,
        "e\",DATUM[\"Cape\",SPHEROID[\"Clarke 1880 (Arc)\",637824");
    add_srs_wkt (p, 2,
        "9.145,293.4663077,AUTHORITY[\"EPSG\",\"7013\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6222\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4222\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",33],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"222");
    add_srs_wkt (p, 12,
        "36\"]]");
    p = add_epsg_def_ex (filter, first, last, 22275, "epsg", 22275,
        "Cape / Lo15", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo15\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"EPSG\",\"6222\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4222\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
        "erse_Mercator_South_Orientated\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",15],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Westing\",WEST],AXIS[\"South");
    add_srs_wkt (p, 11,
        "ing\",SOUTH],AUTHORITY[\"EPSG\",\"22275\"]]");
    p = add_epsg_def_ex (filter, first, last, 22277, "epsg", 22277,
        "Cape / Lo17", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=17 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo17\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"EPSG\",\"6222\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4222\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
        "erse_Mercator_South_Orientated\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",17],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Westing\",WEST],AXIS[\"South");
    add_srs_wkt (p, 11,
        "ing\",SOUTH],AUTHORITY[\"EPSG\",\"22277\"]]");
    p = add_epsg_def_ex (filter, first, last, 22279, "epsg", 22279,
        "Cape / Lo19", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo19\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"EPSG\",\"6222\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4222\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
        "erse_Mercator_South_Orientated\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",19],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Westing\",WEST],AXIS[\"South");
    add_srs_wkt (p, 11,
        "ing\",SOUTH],AUTHORITY[\"EPSG\",\"22279\"]]");
    p = add_epsg_def_ex (filter, first, last, 22281, "epsg", 22281,
        "Cape / Lo21", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo21\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"EPSG\",\"6222\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4222\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
        "erse_Mercator_South_Orientated\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",21],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Westing\",WEST],AXIS[\"South");
    add_srs_wkt (p, 11,
        "ing\",SOUTH],AUTHORITY[\"EPSG\",\"22281\"]]");
    p = add_epsg_def_ex (filter, first, last, 22283, "epsg", 22283,
        "Cape / Lo23", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo23\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"EPSG\",\"6222\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4222\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
        "erse_Mercator_South_Orientated\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",23],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Westing\",WEST],AXIS[\"South");
    add_srs_wkt (p, 11,
        "ing\",SOUTH],AUTHORITY[\"EPSG\",\"22283\"]]");
    p = add_epsg_def_ex (filter, first, last, 22285, "epsg", 22285,
        "Cape / Lo25", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo25\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"EPSG\",\"6222\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4222\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
        "erse_Mercator_South_Orientated\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",25],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Westing\",WEST],AXIS[\"South");
    add_srs_wkt (p, 11,
        "ing\",SOUTH],AUTHORITY[\"EPSG\",\"22285\"]]");
    p = add_epsg_def_ex (filter, first, last, 22287, "epsg", 22287,
        "Cape / Lo27", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo27\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"EPSG\",\"6222\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4222\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
        "erse_Mercator_South_Orientated\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",27],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Westing\",WEST],AXIS[\"South");
    add_srs_wkt (p, 11,
        "ing\",SOUTH],AUTHORITY[\"EPSG\",\"22287\"]]");
    p = add_epsg_def_ex (filter, first, last, 22289, "epsg", 22289,
        "Cape / Lo29", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo29\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"EPSG\",\"6222\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4222\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
        "erse_Mercator_South_Orientated\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",29],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Westing\",WEST],AXIS[\"South");
    add_srs_wkt (p, 11,
        "ing\",SOUTH],AUTHORITY[\"EPSG\",\"22289\"]]");
    p = add_epsg_def_ex (filter, first, last, 22291, "epsg", 22291,
        "Cape / Lo31", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo31\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"EPSG\",\"6222\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4222\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
        "erse_Mercator_South_Orientated\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",31],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Westing\",WEST],AXIS[\"South");
    add_srs_wkt (p, 11,
        "ing\",SOUTH],AUTHORITY[\"EPSG\",\"22291\"]]");
    p = add_epsg_def_ex (filter, first, last, 22293, "epsg", 22293,
        "Cape / Lo33", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Cape", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-1");
    add_proj4text (p, 2,
        "08,-292,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Cape / Lo33\",GEOGCS[\"Cape\",DATUM[\"Cape\",SP");
    add_srs_wkt (p, 1,
        "HEROID[\"Clarke 1880 (Arc)\",6378249.145,293.4663077,AUT");
    add_srs_wkt (p, 2,
        "HORITY[\"EPSG\",\"7013\"]],AUTHORITY[\"EPSG\",\"6222\"]]");
    add_srs_wkt (p, 3,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 4,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 5,
        "22\"]],AUTHORITY[\"EPSG\",\"4222\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 6,
        "erse_Mercator_South_Orientated\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 7,
        "f_origin\",0],PARAMETER[\"central_meridian\",33],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Westing\",WEST],AXIS[\"South");
    add_srs_wkt (p, 11,
        "ing\",SOUTH],AUTHORITY[\"EPSG\",\"22293\"]]");
    p = add_epsg_def_ex (filter, first, last, 22332, "epsg", 22332,
        "Carthage / UTM zone 32N", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Carthage", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +a=6378249.2 +b=6356515 +towgs84=-263");
    add_proj4text (p, 1,
        ",6,431,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Carthage / UTM zone 32N\",GEOGCS[\"Carthage\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Carthage\",SPHEROID[\"Clarke 1880 (IGN)\",6378249");
    add_srs_wkt (p, 2,
        ".2,293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6223\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4223\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",9],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"22332\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 22391, "epsg", 22391,
        "Carthage / Nord Tunisie", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Carthage", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36 +lat_0=36 +lon_0=9.9 +k_0=0.99962554");
    add_proj4text (p, 1,
        "4 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +towgs");
    add_proj4text (p, 2,
        "84=-263,6,431,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Carthage / Nord Tunisie\",GEOGCS[\"Carthage\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Carthage\",SPHEROID[\"Clarke 1880 (IGN)\",6378249");
    add_srs_wkt (p, 2,
        ".2,293.466021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6223\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4223\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",36],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",9.9],PARAMETER[\"scale_factor\",0.999625544],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",300000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"22391\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

