/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Tue Jul 14 19:02:34 2020

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_50 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 26739, "epsg", 26739,
        "NAD27 / Alaska zone 9", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=182880.");
    add_proj4text (p, 1,
        "3657607315 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 9\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",54],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-170],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",600000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"26739\"]]");
    p = add_epsg_def_ex (filter, first, last, 26740, "epsg", 26740,
        "NAD27 / Alaska zone 10", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=53.83333333333334 +lat_2=51.83333333333");
    add_proj4text (p, 1,
        "334 +lat_0=51 +lon_0=-176 +x_0=914401.8288036576 +y_0=0 ");
    add_proj4text (p, 2,
        "+datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Alaska zone 10\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",51],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-176],PARAMETER[\"standard_parallel_1\",53.83");
    add_srs_wkt (p, 9,
        "33333333333],PARAMETER[\"standard_parallel_2\",51.833333");
    add_srs_wkt (p, 10,
        "3333333],PARAMETER[\"false_easting\",3000000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 12,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26740");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 26741, "epsg", 26741,
        "NAD27 / California zone I", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.3");
    add_proj4text (p, 1,
        "3333333333334 +lon_0=-122 +x_0=609601.2192024384 +y_0=0 ");
    add_proj4text (p, 2,
        "+datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone I\",GEOGCS[\"NAD27\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866");
    add_srs_wkt (p, 2,
        "\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",39.3333333333333],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-122],PARAMETER[\"standard_par");
    add_srs_wkt (p, 9,
        "allel_1\",41.6666666666667],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_2\",40],PARAMETER[\"false_easting\",2000000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 12,
        "09601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2674");
    add_srs_wkt (p, 14,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 26742, "epsg", 26742,
        "NAD27 / California zone II", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=609601.219");
    add_proj4text (p, 2,
        "2024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone II\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",37.6666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-122],PARAMETER[\"standard_p");
    add_srs_wkt (p, 9,
        "arallel_1\",39.8333333333333],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",38.3333333333333],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"26742\"]]");
    p = add_epsg_def_ex (filter, first, last, 26743, "epsg", 26743,
        "NAD27 / California zone III", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.5 +lon_0=-120.5 +x_0=609601.2192024384 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone III\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",36.5],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-120.5],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 9,
        "1\",38.4333333333333],PARAMETER[\"standard_parallel_2\",");
    add_srs_wkt (p, 10,
        "37.0666666666667],PARAMETER[\"false_easting\",2000000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 12,
        ".304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Ea");
    add_srs_wkt (p, 13,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"26743\"]]");
    p = add_epsg_def_ex (filter, first, last, 26744, "epsg", 26744,
        "NAD27 / California zone IV", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.3333333333333");
    add_proj4text (p, 1,
        "4 +lon_0=-119 +x_0=609601.2192024384 +y_0=0 +datum=NAD27");
    add_proj4text (p, 2,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone IV\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",35.3333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-119],PARAMETER[\"standard_p");
    add_srs_wkt (p, 9,
        "arallel_1\",37.25],PARAMETER[\"standard_parallel_2\",36]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",2000000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"US survey foot\",0.304800609601219,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26744\"]]");
    p = add_epsg_def_ex (filter, first, last, 26745, "epsg", 26745,
        "NAD27 / California zone V", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.5 +lon_0=-118 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone V\",GEOGCS[\"NAD27\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866");
    add_srs_wkt (p, 2,
        "\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",33.5],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-118],PARAMETER[\"standard_parallel_1\",35");
    add_srs_wkt (p, 9,
        ".4666666666667],PARAMETER[\"standard_parallel_2\",34.033");
    add_srs_wkt (p, 10,
        "3333333333],PARAMETER[\"false_easting\",2000000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 12,
        "0609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"267");
    add_srs_wkt (p, 14,
        "45\"]]");
    p = add_epsg_def_ex (filter, first, last, 26746, "epsg", 26746,
        "NAD27 / California zone VI", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=609601.");
    add_proj4text (p, 2,
        "2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone VI\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",32.1666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-116.25],PARAMETER[\"standar");
    add_srs_wkt (p, 9,
        "d_parallel_1\",33.8833333333333],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_2\",32.7833333333333],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"26746\"]]");
    p = add_epsg_def_ex (filter, first, last, 26747, "epsg", 26747,
        "NAD27 / California zone VII", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.41666666666666 +lat_2=33.86666666666");
    add_proj4text (p, 1,
        "667 +lat_0=34.13333333333333 +lon_0=-118.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=1276106.450596901 +y_0=127079.524511049 +datum=NAD27");
    add_proj4text (p, 3,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone VII\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",34.1333333333333],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-118.333333333333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_1\",34.4166666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",33.8666666666667],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",4186692.58],PARAMETER[\"false_northing\",416");
    add_srs_wkt (p, 12,
        "0926.74],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 14,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"26799\"]]");
    p = add_epsg_def_ex (filter, first, last, 26748, "epsg", 26748,
        "NAD27 / Arizona East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arizona East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",31],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-110.166666666667],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26748\"]]");
    p = add_epsg_def_ex (filter, first, last, 26749, "epsg", 26749,
        "NAD27 / Arizona Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arizona Central\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",31],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-111.916666666667],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"US survey foot\",0.304800609601219,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26749\"]]");
    p = add_epsg_def_ex (filter, first, last, 26750, "epsg", 26750,
        "NAD27 / Arizona West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0");
    add_proj4text (p, 1,
        "=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arizona West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",31],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-113.75],PARAMETER[\"scale_factor\",0.999933333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 12,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26750\"]]");
    p = add_epsg_def_ex (filter, first, last, 26751, "epsg", 26751,
        "NAD27 / Arkansas North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arkansas North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",34.3333333333333],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-92],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",36.2333333333333],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",34.9333333333333],PARAMETER[\"false_easting\",200000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot");
    add_srs_wkt (p, 12,
        "\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"26751\"]]");
    p = add_epsg_def_ex (filter, first, last, 26752, "epsg", 26752,
        "NAD27 / Arkansas South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-92 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Arkansas South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",32.6666666666667],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-92],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",34.7666666666667],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",33.3],PARAMETER[\"false_easting\",2000000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 12,
        "09601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2675");
    add_srs_wkt (p, 14,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 26753, "epsg", 26753,
        "NAD27 / Colorado North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.71666666666667 +lat_2=40.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Colorado North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",39.3333333333333],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-105.5],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",39.7166666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_2\",40.7833333333333],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"26753\"]]");
    p = add_epsg_def_ex (filter, first, last, 26754, "epsg", 26754,
        "NAD27 / Colorado Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.8333333333");
    add_proj4text (p, 1,
        "3334 +lon_0=-105.5 +x_0=609601.2192024384 +y_0=0 +datum=");
    add_proj4text (p, 2,
        "NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Colorado Central\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",37.8333333333333],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-105.5],PARAMETER[\"standard_p");
    add_srs_wkt (p, 9,
        "arallel_1\",39.75],PARAMETER[\"standard_parallel_2\",38.");
    add_srs_wkt (p, 10,
        "45],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 12,
        "19,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 13,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26754\"]]");
    p = add_epsg_def_ex (filter, first, last, 26755, "epsg", 26755,
        "NAD27 / Colorado South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Colorado South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",36.6666666666667],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-105.5],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",38.4333333333333],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_2\",37.2333333333333],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"26755\"]]");
    p = add_epsg_def_ex (filter, first, last, 26756, "epsg", 26756,
        "NAD27 / Connecticut", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40");
    add_proj4text (p, 1,
        ".83333333333334 +lon_0=-72.75 +x_0=182880.3657607315 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Connecticut\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",40.8333333333333],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-72.75],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",41.8666666666667],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",41.2],PARAMETER[\"false_easting\",600000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 12,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26756");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 26757, "epsg", 26757,
        "NAD27 / Delaware", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999");
    add_proj4text (p, 1,
        "995 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us");
    add_proj4text (p, 2,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Delaware\",GEOGCS[\"NAD27\",DATUM[\"Nor");
    add_srs_wkt (p, 1,
        "th_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637820");
    add_srs_wkt (p, 2,
        "6.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",38],PARAMETER[\"central_meridian\",-75");
    add_srs_wkt (p, 8,
        ".4166666666667],PARAMETER[\"scale_factor\",0.999995],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 12,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"26757\"]]");
    p = add_epsg_def_ex (filter, first, last, 26758, "epsg", 26758,
        "NAD27 / Florida East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Florida East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",24.3333333333333],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-81],PARAMETER[\"scale_factor\",0.99994117");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26758\"]]");
    p = add_epsg_def_ex (filter, first, last, 26759, "epsg", 26759,
        "NAD27 / Florida West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999");
    add_proj4text (p, 1,
        "941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Florida West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",24.3333333333333],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-82],PARAMETER[\"scale_factor\",0.99994117");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26759\"]]");
    p = add_epsg_def_ex (filter, first, last, 26760, "epsg", 26760,
        "NAD27 / Florida North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=2");
    add_proj4text (p, 1,
        "9 +lon_0=-84.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Florida North\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",29],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-84.5],PARAMETER[\"standard_parallel_1\",30.75]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",29.5833333333333],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",2000000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26760\"]]");
    p = add_epsg_def_ex (filter, first, last, 26766, "epsg", 26766,
        "NAD27 / Georgia East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Georgia East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",30],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-82.1666666666667],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26766\"]]");
    p = add_epsg_def_ex (filter, first, last, 26767, "epsg", 26767,
        "NAD27 / Georgia West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.999");
    add_proj4text (p, 1,
        "9 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Georgia West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",30],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "-84.1666666666667],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26767\"]]");
    p = add_epsg_def_ex (filter, first, last, 26768, "epsg", 26768,
        "NAD27 / Idaho East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666");
    add_proj4text (p, 1,
        "666667 +k=0.9999473679999999 +x_0=152400.3048006096 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Idaho East\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",41.6666666666667],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-112.166666666667],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.999947368],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 11,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "26768\"]]");
    p = add_epsg_def_ex (filter, first, last, 26769, "epsg", 26769,
        "NAD27 / Idaho Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.99");
    add_proj4text (p, 1,
        "99473679999999 +x_0=152400.3048006096 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Idaho Central\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",41.6666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-114],PARAMETER[\"scale_factor\",0.9999473");
    add_srs_wkt (p, 9,
        "68],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26769\"]]");
    p = add_epsg_def_ex (filter, first, last, 26770, "epsg", 26770,
        "NAD27 / Idaho West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0");
    add_proj4text (p, 1,
        ".999933333 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +u");
    add_proj4text (p, 2,
        "nits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Idaho West\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",41.6666666666667],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-115.75],PARAMETER[\"scale_factor\",0.99993");
    add_srs_wkt (p, 9,
        "3333],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 11,
        "219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26770\"]]");
    p = add_epsg_def_ex (filter, first, last, 26771, "epsg", 26771,
        "NAD27 / Illinois East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333");
    add_proj4text (p, 1,
        "333333 +k=0.9999749999999999 +x_0=152400.3048006096 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Illinois East\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",36.6666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-88.3333333333333],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.999975],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 11,
        "00609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 13,
        "6771\"]]");
    p = add_epsg_def_ex (filter, first, last, 26772, "epsg", 26772,
        "NAD27 / Illinois West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Illinois West\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",36.6666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-90.1666666666667],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 9,
        "r\",0.999941177],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 11,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"26772\"]]");
    p = add_epsg_def_ex (filter, first, last, 26773, "epsg", 26773,
        "NAD27 / Indiana East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Indiana East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",37.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-85.6666666666667],PARAMETER[\"scale_factor\",0.9999666");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26773\"]]");
    p = add_epsg_def_ex (filter, first, last, 26774, "epsg", 26774,
        "NAD27 / Indiana West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Indiana West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",37.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-87.0833333333333],PARAMETER[\"scale_factor\",0.9999666");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26774\"]]");
    p = add_epsg_def_ex (filter, first, last, 26775, "epsg", 26775,
        "NAD27 / Iowa North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41.5 +lon_0=-93.5 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Iowa North\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",41.5],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-93.5],PARAMETER[\"standard_parallel_1\",43.266");
    add_srs_wkt (p, 9,
        "6666666667],PARAMETER[\"standard_parallel_2\",42.0666666");
    add_srs_wkt (p, 10,
        "666667],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26775\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 26776, "epsg", 26776,
        "NAD27 / Iowa South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40 +lon_0=-93.5 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Iowa South\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 7,
        "ETER[\"latitude_of_origin\",40],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-93.5],PARAMETER[\"standard_parallel_1\",41.78333");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"standard_parallel_2\",40.616666666");
    add_srs_wkt (p, 10,
        "6667],PARAMETER[\"false_easting\",2000000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",0],UNIT[\"US survey foot\",0.30480060960");
    add_srs_wkt (p, 12,
        "1219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26776\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 26777, "epsg", 26777,
        "NAD27 / Kansas North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Kansas North\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",38.3333333333333],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-98],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 9,
        "_1\",39.7833333333333],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 10,
        ",38.7166666666667],PARAMETER[\"false_easting\",2000000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 12,
        "0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"E");
    add_srs_wkt (p, 13,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"26777\"]]");
    p = add_epsg_def_ex (filter, first, last, 26778, "epsg", 26778,
        "NAD27 / Kansas South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Kansas South\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",36.6666666666667],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-98.5],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_1\",38.5666666666667],PARAMETER[\"standard_parallel_2");
    add_srs_wkt (p, 10,
        "\",37.2666666666667],PARAMETER[\"false_easting\",2000000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"26778\"]]");
    p = add_epsg_def_ex (filter, first, last, 26779, "epsg", 26779,
        "NAD27 / Kentucky North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=37.5 +lon_0=-84.25 +x_0=609601.2192024384 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Kentucky North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",37.5],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-84.25],PARAMETER[\"standard_parallel_1\",3");
    add_srs_wkt (p, 9,
        "7.9666666666667],PARAMETER[\"standard_parallel_2\",38.96");
    add_srs_wkt (p, 10,
        "66666666667],PARAMETER[\"false_easting\",2000000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "00609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 14,
        "6779\"]]");
    p = add_epsg_def_ex (filter, first, last, 26780, "epsg", 26780,
        "NAD27 / Kentucky South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.73333333333333 +lat_2=37.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Kentucky South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",36.3333333333333],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-85.75],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",36.7333333333333],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_2\",37.9333333333333],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"26780\"]]");
    p = add_epsg_def_ex (filter, first, last, 26781, "epsg", 26781,
        "NAD27 / Louisiana North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=31.16666666666667 +lat_2=32.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=30.66666666666667 +lon_0=-92.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Louisiana North\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",30.6666666666667],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-92.5],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",31.1666666666667],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_2\",32.6666666666667],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"26781\"]]");
    p = add_epsg_def_ex (filter, first, last, 26782, "epsg", 26782,
        "NAD27 / Louisiana South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=29.3 +lat_2=30.7 +lat_0=28.666666666666");
    add_proj4text (p, 1,
        "67 +lon_0=-91.33333333333333 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Louisiana South\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",28.6666666666667],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-91.3333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",29.3],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_2\",30.7],PARAMETER[\"false_easting\",2000000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 12,
        "0609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"267");
    add_srs_wkt (p, 14,
        "82\"]]");
    p = add_epsg_def_ex (filter, first, last, 26783, "epsg", 26783,
        "NAD27 / Maine East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.83333333333334 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us");
    add_proj4text (p, 2,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Maine East\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",43.8333333333333],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-68.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",500000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"US survey foot\",0.304800609601219,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26783\"]]");
    p = add_epsg_def_ex (filter, first, last, 26784, "epsg", 26784,
        "NAD27 / Maine West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Maine West\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 6,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 7,
        "atitude_of_origin\",42.8333333333333],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-70.1666666666667],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.999966667],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 11,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "26784\"]]");
    p = add_epsg_def_ex (filter, first, last, 26785, "epsg", 26785,
        "NAD27 / Maryland", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.3 +lat_2=39.45 +lat_0=37.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-77 +x_0=243840.4876809754 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Maryland\",GEOGCS[\"NAD27\",DATUM[\"Nor");
    add_srs_wkt (p, 1,
        "th_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637820");
    add_srs_wkt (p, 2,
        "6.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMET");
    add_srs_wkt (p, 7,
        "ER[\"latitude_of_origin\",37.8333333333333],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-77],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",38.3],PARAMETER[\"standard_parallel_2\",39.45],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",800000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26785\"]]");
    p = add_epsg_def_ex (filter, first, last, 26786, "epsg", 26786,
        "NAD27 / Massachusetts Mainland", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.71666666666667 +lat_2=42.68333333333");
    add_proj4text (p, 1,
        "333 +lat_0=41 +lon_0=-71.5 +x_0=182880.3657607315 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Massachusetts Mainland\",GEOGCS[\"NAD27");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 2,
        " 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"latitude_of_origin\",41],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-71.5],PARAMETER[\"standard_parallel_1");
    add_srs_wkt (p, 9,
        "\",41.7166666666667],PARAMETER[\"standard_parallel_2\",4");
    add_srs_wkt (p, 10,
        "2.6833333333333],PARAMETER[\"false_easting\",600000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 12,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"26786\"]]");
    p = add_epsg_def_ex (filter, first, last, 26787, "epsg", 26787,
        "NAD27 / Massachusetts Island", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.28333333333333 +lat_2=41.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=41 +lon_0=-70.5 +x_0=60960.12192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Massachusetts Island\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",41],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",-70.5],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",41.2833333333333],PARAMETER[\"standard_parallel_2\",41.");
    add_srs_wkt (p, 10,
        "4833333333333],PARAMETER[\"false_easting\",200000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 12,
        "800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 13,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "26787\"]]");
    p = add_epsg_def_ex (filter, first, last, 26791, "epsg", 26791,
        "NAD27 / Minnesota North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.03333333333333 +lat_2=48.63333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Minnesota North\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",46.5],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-93.1],PARAMETER[\"standard_parallel_1\",4");
    add_srs_wkt (p, 9,
        "7.0333333333333],PARAMETER[\"standard_parallel_2\",48.63");
    add_srs_wkt (p, 10,
        "33333333333],PARAMETER[\"false_easting\",2000000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "00609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 14,
        "6791\"]]");
    p = add_epsg_def_ex (filter, first, last, 26792, "epsg", 26792,
        "NAD27 / Minnesota Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.61666666666667 +lat_2=47.05 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=609601.2192024384 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Minnesota Central\",GEOGCS[\"NAD27\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866");
    add_srs_wkt (p, 2,
        "\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",45],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-94.25],PARAMETER[\"standard_parallel_1\",45");
    add_srs_wkt (p, 9,
        ".6166666666667],PARAMETER[\"standard_parallel_2\",47.05]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",2000000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"US survey foot\",0.304800609601219,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 13,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26792\"]]");
    p = add_epsg_def_ex (filter, first, last, 26793, "epsg", 26793,
        "NAD27 / Minnesota South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.78333333333333 +lat_2=45.21666666666");
    add_proj4text (p, 1,
        "667 +lat_0=43 +lon_0=-94 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Minnesota South\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",43],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-94],PARAMETER[\"standard_parallel_1\",43.78");
    add_srs_wkt (p, 9,
        "33333333333],PARAMETER[\"standard_parallel_2\",45.216666");
    add_srs_wkt (p, 10,
        "6666667],PARAMETER[\"false_easting\",2000000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 12,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26793");
    add_srs_wkt (p, 14,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 26794, "epsg", 26794,
        "NAD27 / Mississippi East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.66666666666667 +lon_0=-88.83333333");
    add_proj4text (p, 1,
        "333333 +k=0.99996 +x_0=152400.3048006096 +y_0=0 +datum=N");
    add_proj4text (p, 2,
        "AD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Mississippi East\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",29.6666666666667],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-88.8333333333333],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.99996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 11,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"26794\"]]");
    p = add_epsg_def_ex (filter, first, last, 26795, "epsg", 26795,
        "NAD27 / Mississippi West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30.5 +lon_0=-90.33333333333333 +k=0.9");
    add_proj4text (p, 1,
        "99941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Mississippi West\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",30.5],PARAMETER[\"central_merid");
    add_srs_wkt (p, 8,
        "ian\",-90.3333333333333],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "9941177],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 11,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26795\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 26796, "epsg", 26796,
        "NAD27 / Missouri East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.9");
    add_proj4text (p, 1,
        "99933333 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Missouri East\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",35.8333333333333],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-90.5],PARAMETER[\"scale_factor\",0.999933");
    add_srs_wkt (p, 9,
        "333],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 11,
        "19,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26796\"]]");
    p = add_epsg_def_ex (filter, first, last, 26797, "epsg", 26797,
        "NAD27 / Missouri Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.9");
    add_proj4text (p, 1,
        "99933333 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Missouri Central\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",35.8333333333333],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-92.5],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "9933333],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 11,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26797\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 26798, "epsg", 26798,
        "NAD27 / Missouri West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.9");
    add_proj4text (p, 1,
        "99941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Missouri West\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",36.1666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-94.5],PARAMETER[\"scale_factor\",0.999941");
    add_srs_wkt (p, 9,
        "177],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 11,
        "19,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26798\"]]");
    p = add_epsg_def_ex (filter, first, last, 26799, "epsg", 26799,
        "NAD27 / California zone VII", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.41666666666666 +lat_2=33.86666666666");
    add_proj4text (p, 1,
        "667 +lat_0=34.13333333333333 +lon_0=-118.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=1276106.450596901 +y_0=1268253.006858014 +datum=NAD2");
    add_proj4text (p, 3,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone VII\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",34.1333333333333],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-118.333333333333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"standard_parallel_1\",34.4166666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",33.8666666666667],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",4186692.58],PARAMETER[\"false_northing\",416");
    add_srs_wkt (p, 12,
        "0926.74],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 14,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"26799\"]]");
    p = add_epsg_def_ex (filter, first, last, 26801, "epsg", 26801,
        "NAD27 / Michigan East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-83.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99942857 +x_0=152400.3048006096 +y_0=0 +a=6378450.047548");
    add_proj4text (p, 2,
        "896 +b=6356826.621488444 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Michigan East\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",41.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-83.6666666666667],PARAMETER[\"scale_factor\",0.9999428");
    add_srs_wkt (p, 9,
        "57],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 12,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5623\"]]");
    p = add_epsg_def_ex (filter, first, last, 26802, "epsg", 26802,
        "NAD27 / Michigan Old Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-85.75 +k=0.999909091 +x_");
    add_proj4text (p, 1,
        "0=152400.3048006096 +y_0=0 +a=6378450.047548896 +b=63568");
    add_proj4text (p, 2,
        "26.621488444 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Michigan Old Central\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",41.5],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",-85.75],PARAMETER[\"scale_factor\",0.999909091");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"US survey foot\",0.304800609601219,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"5624\"]]");
    p = add_epsg_def_ex (filter, first, last, 26803, "epsg", 26803,
        "NAD27 / Michigan West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-88.75 +k=0.999909091 +x_");
    add_proj4text (p, 1,
        "0=152400.3048006096 +y_0=0 +a=6378450.047548896 +b=63568");
    add_proj4text (p, 2,
        "26.621488444 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Michigan West\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",41.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-88.75],PARAMETER[\"scale_factor\",0.999909091],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 12,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"5625\"]]");
    p = add_epsg_def_ex (filter, first, last, 26814, "epsg", 26814,
        "NAD83 / Maine East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine East (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "9\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",43.6666666666667],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-68.5],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",984250],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26847\"]]");
    p = add_epsg_def_ex (filter, first, last, 26815, "epsg", 26815,
        "NAD83 / Maine West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine West (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "9\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",42.8333333333333],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-70.1666666666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.999966667],PARAMETER[\"false_easting\",2952750],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 11,
        "800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "26848\"]]");
    p = add_epsg_def_ex (filter, first, last, 26819, "epsg", 26819,
        "NAD83 / Minnesota North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.00");
    add_proj4text (p, 2,
        "00101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0");
    add_proj4text (p, 3,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota North (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",46.5],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-93.1],PARAMETER[\"standard_parallel_1\",48");
    add_srs_wkt (p, 9,
        ".6333333333333],PARAMETER[\"standard_parallel_2\",47.033");
    add_srs_wkt (p, 10,
        "3333333333],PARAMETER[\"false_easting\",2624666.6667],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",328083.3333],UNIT[\"US survey");
    add_srs_wkt (p, 12,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"26849\"]]");
    p = add_epsg_def_ex (filter, first, last, 26820, "epsg", 26820,
        "NAD83 / Minnesota Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000.0000101601 +y_0=99999.999989");
    add_proj4text (p, 2,
        "84 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota Central (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",45],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-94.25],PARAMETER[\"standard_parallel_1\",47");
    add_srs_wkt (p, 9,
        ".05],PARAMETER[\"standard_parallel_2\",45.6166666666667]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",2624666.6667],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",328083.3333],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 12,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"26850\"]]");
    p = add_epsg_def_ex (filter, first, last, 26821, "epsg", 26821,
        "NAD83 / Minnesota South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101601 +y_0=999");
    add_proj4text (p, 2,
        "99.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota South (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",43],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-94],PARAMETER[\"standard_parallel_1\",45.216");
    add_srs_wkt (p, 9,
        "6666666667],PARAMETER[\"standard_parallel_2\",43.7833333");
    add_srs_wkt (p, 10,
        "333333],PARAMETER[\"false_easting\",2624666.6667],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",328083.3333],UNIT[\"US survey foo");
    add_srs_wkt (p, 12,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"26851\"]]");
    p = add_epsg_def_ex (filter, first, last, 26822, "epsg", 26822,
        "NAD83 / Nebraska (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.0000101601 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nebraska (ftUS)\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",39.8333333333333],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-100],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",43],PARAMETER[\"standard_parallel_2\",40],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",1640416.6667],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26852\"]]");
    p = add_epsg_def_ex (filter, first, last, 26823, "epsg", 26823,
        "NAD83 / West Virginia North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=1968500 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,");
    add_proj4text (p, 2,
        "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / West Virginia North (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",38.5],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",-79.5],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",40.25],PARAMETER[\"standard_parallel_2\",39],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",1968500],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"26853\"]]");
    p = add_epsg_def_ex (filter, first, last, 26824, "epsg", 26824,
        "NAD83 / West Virginia South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=1968500 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / West Virginia South (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",37],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-81],PARAMETER[\"standard_parallel_1\",38.");
    add_srs_wkt (p, 9,
        "8833333333333],PARAMETER[\"standard_parallel_2\",37.4833");
    add_srs_wkt (p, 10,
        "333333333],PARAMETER[\"false_easting\",1968500],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"268");
    add_srs_wkt (p, 14,
        "54\"]]");
    p = add_epsg_def_ex (filter, first, last, 26825, "epsg", 26825,
        "NAD83(HARN) / Maine East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maine East (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",43.6666666666667");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-68.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9999],PARAMETER[\"false_easting\",984250],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 11,
        ".304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"26855\"]]");
    p = add_epsg_def_ex (filter, first, last, 26826, "epsg", 26826,
        "NAD83(HARN) / Maine West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maine West (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",42.8333333333333");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-70.1666666666667],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.999966667],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",2952750],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"26856\"]]");
    p = add_epsg_def_ex (filter, first, last, 26830, "epsg", 26830,
        "NAD83(HARN) / Minnesota North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.00");
    add_proj4text (p, 2,
        "00101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0");
    add_proj4text (p, 3,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",46");
    add_srs_wkt (p, 8,
        ".5],PARAMETER[\"central_meridian\",-93.1],PARAMETER[\"st");
    add_srs_wkt (p, 9,
        "andard_parallel_1\",48.6333333333333],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",47.0333333333333],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",2624666.6667],PARAMETER[\"false_northing\",328083.");
    add_srs_wkt (p, 12,
        "3333],UNIT[\"US survey foot\",0.304800609601219,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 14,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"26857\"]]");
    p = add_epsg_def_ex (filter, first, last, 26831, "epsg", 26831,
        "NAD83(HARN) / Minnesota Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000.0000101601 +y_0=99999.999989");
    add_proj4text (p, 2,
        "84 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota Central (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_N");
    add_srs_wkt (p, 2,
        "etwork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 7,
        "t_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",45],PARAMETER[\"central_meridian\",-94.25],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",47.05],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_2\",45.6166666666667],PARAMETER[\"false_easting\",262");
    add_srs_wkt (p, 11,
        "4666.6667],PARAMETER[\"false_northing\",328083.3333],UNI");
    add_srs_wkt (p, 12,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"26858\"]]");
    p = add_epsg_def_ex (filter, first, last, 26832, "epsg", 26832,
        "NAD83(HARN) / Minnesota South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101601 +y_0=999");
    add_proj4text (p, 2,
        "99.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",43");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-94],PARAMETER[\"standa");
    add_srs_wkt (p, 9,
        "rd_parallel_1\",45.2166666666667],PARAMETER[\"standard_p");
    add_srs_wkt (p, 10,
        "arallel_2\",43.7833333333333],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",2624666.6667],PARAMETER[\"false_northing\",328083.3333]");
    add_srs_wkt (p, 12,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"26859\"]]");
    p = add_epsg_def_ex (filter, first, last, 26833, "epsg", 26833,
        "NAD83(HARN) / Nebraska (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.0000101601 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Nebraska (ftUS)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",39.83333");
    add_srs_wkt (p, 8,
        "33333333],PARAMETER[\"central_meridian\",-100],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_1\",43],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_2\",40],PARAMETER[\"false_easting\",1640416.6667],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 12,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"26860\"]]");
    p = add_epsg_def_ex (filter, first, last, 26834, "epsg", 26834,
        "NAD83(HARN) / West Virginia North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=1968500 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,");
    add_proj4text (p, 2,
        "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / West Virginia North (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference");
    add_srs_wkt (p, 2,
        "_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",38.5],PARAMETER[\"central_meridian\",-79.5],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_1\",40.25],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_2\",39],PARAMETER[\"false_easting\",1968500],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "26861\"]]");
    p = add_epsg_def_ex (filter, first, last, 26835, "epsg", 26835,
        "NAD83(HARN) / West Virginia South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=1968500 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / West Virginia South (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference");
    add_srs_wkt (p, 2,
        "_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",37],PARAMETER[\"central_meridian\",-81],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",38.8833333333333],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_2\",37.4833333333333],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",1968500],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"26862\"]]");
    p = add_epsg_def_ex (filter, first, last, 26836, "epsg", 26836,
        "NAD83(NSRS2007) / Maine East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Maine East (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",43.6666666666667],PARAMETER[\"central_meridian\",-68.5]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",984250],PARAMETER[\"false_northing\",0],UNIT[\"U");
    add_srs_wkt (p, 11,
        "S survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"26863\"]]");
    p = add_epsg_def_ex (filter, first, last, 26837, "epsg", 26837,
        "NAD83(NSRS2007) / Maine West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Maine West (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",42.8333333333333],PARAMETER[\"central_meridian\",-70.16");
    add_srs_wkt (p, 9,
        "66666666667],PARAMETER[\"scale_factor\",0.999966667],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",2952750],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26864\"]]");
    p = add_epsg_def_ex (filter, first, last, 26841, "epsg", 26841,
        "NAD83(NSRS2007) / Minnesota North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.00");
    add_proj4text (p, 2,
        "00101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0");
    add_proj4text (p, 3,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Minnesota North (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",46.5],PARAMETER[\"central_meridian\",-93.");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"standard_parallel_1\",48.6333333333333],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",47.0333333333333],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",2624666.6667],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",328083.3333],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 13,
        "09601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2686");
    add_srs_wkt (p, 15,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 26842, "epsg", 26842,
        "NAD83(NSRS2007) / Minnesota Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000.0000101601 +y_0=99999.999989");
    add_proj4text (p, 2,
        "84 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Minnesota Central (ftUS)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_");
    add_srs_wkt (p, 2,
        "Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",45],PARAMETER[\"central_meridian\",-94.2");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"standard_parallel_1\",47.05],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",45.6166666666667],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",2624666.6667],PARAMETER[\"false_northing\",3");
    add_srs_wkt (p, 12,
        "28083.3333],UNIT[\"US survey foot\",0.304800609601219,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 14,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26866\"]]");
    p = add_epsg_def_ex (filter, first, last, 26843, "epsg", 26843,
        "NAD83(NSRS2007) / Minnesota South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101601 +y_0=999");
    add_proj4text (p, 2,
        "99.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Minnesota South (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",43],PARAMETER[\"central_meridian\",-94],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_1\",45.2166666666667],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"standard_parallel_2\",43.7833333333333],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",2624666.6667],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",328083.3333],UNIT[\"US survey foot\",0.30480060960");
    add_srs_wkt (p, 13,
        "1219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 14,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26867\"]");
    add_srs_wkt (p, 15,
        "]");
    p = add_epsg_def_ex (filter, first, last, 26844, "epsg", 26844,
        "NAD83(NSRS2007) / Nebraska (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.0000101601 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Nebraska (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"67");
    add_srs_wkt (p, 4,
        "59\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",39.8333333333333],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-100],PARAMETER[\"standard_parallel_1\",43],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",40],PARAMETER[\"false_easting\",16");
    add_srs_wkt (p, 11,
        "40416.6667],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 12,
        "rvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"26868\"]]");
    p = add_epsg_def_ex (filter, first, last, 26845, "epsg", 26845,
        "NAD83(NSRS2007) / West Virginia North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=1968500 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,");
    add_proj4text (p, 2,
        "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / West Virginia North (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatia");
    add_srs_wkt (p, 2,
        "l_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",38.5],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-79.5],PARAMETER[\"standard_parallel_1\",40.25],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"standard_parallel_2\",39],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",1968500],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"26869\"]]");
    p = add_epsg_def_ex (filter, first, last, 26846, "epsg", 26846,
        "NAD83(NSRS2007) / West Virginia South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=1968500 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / West Virginia South (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatia");
    add_srs_wkt (p, 2,
        "l_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",37],PARAMETER[\"central_meridian\",-8");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"standard_parallel_1\",38.8833333333333],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",37.4833333333333],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",1968500],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",0],UNIT[\"US survey foot\",0.304800609601219,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 14,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"26870\"]]");
    p = add_epsg_def_ex (filter, first, last, 26847, "epsg", 26847,
        "NAD83 / Maine East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine East (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "9\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",43.6666666666667],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-68.5],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",984250],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26847\"]]");
    p = add_epsg_def_ex (filter, first, last, 26848, "epsg", 26848,
        "NAD83 / Maine West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine West (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 6,
        "9\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",42.8333333333333],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-70.1666666666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.999966667],PARAMETER[\"false_easting\",2952750],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 11,
        "800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "26848\"]]");
    p = add_epsg_def_ex (filter, first, last, 26849, "epsg", 26849,
        "NAD83 / Minnesota North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.00");
    add_proj4text (p, 2,
        "00101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 3,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota North (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",46.5],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-93.1],PARAMETER[\"standard_parallel_1\",48");
    add_srs_wkt (p, 9,
        ".6333333333333],PARAMETER[\"standard_parallel_2\",47.033");
    add_srs_wkt (p, 10,
        "3333333333],PARAMETER[\"false_easting\",2624666.6667],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",328083.3333],UNIT[\"US survey");
    add_srs_wkt (p, 12,
        " foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"26849\"]]");
    p = add_epsg_def_ex (filter, first, last, 26850, "epsg", 26850,
        "NAD83 / Minnesota Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000.0000101599 +y_0=99999.999989");
    add_proj4text (p, 2,
        "83997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota Central (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",45],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-94.25],PARAMETER[\"standard_parallel_1\",47");
    add_srs_wkt (p, 9,
        ".05],PARAMETER[\"standard_parallel_2\",45.6166666666667]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",2624666.6667],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",328083.3333],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 12,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"26850\"]]");
    p = add_epsg_def_ex (filter, first, last, 26851, "epsg", 26851,
        "NAD83 / Minnesota South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101599 +y_0=999");
    add_proj4text (p, 2,
        "99.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota South (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"latitude_of_origin\",43],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-94],PARAMETER[\"standard_parallel_1\",45.216");
    add_srs_wkt (p, 9,
        "6666666667],PARAMETER[\"standard_parallel_2\",43.7833333");
    add_srs_wkt (p, 10,
        "333333],PARAMETER[\"false_easting\",2624666.6667],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",328083.3333],UNIT[\"US survey foo");
    add_srs_wkt (p, 12,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"26851\"]]");
    p = add_epsg_def_ex (filter, first, last, 26852, "epsg", 26852,
        "NAD83 / Nebraska (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nebraska (ftUS)\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",39.8333333333333],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-100],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",43],PARAMETER[\"standard_parallel_2\",40],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",1640416.6667],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26852\"]]");
    p = add_epsg_def_ex (filter, first, last, 26853, "epsg", 26853,
        "NAD83 / West Virginia North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / West Virginia North (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",38.5],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",-79.5],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 9,
        ",40.25],PARAMETER[\"standard_parallel_2\",39],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",1968500],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"26853\"]]");
    p = add_epsg_def_ex (filter, first, last, 26854, "epsg", 26854,
        "NAD83 / West Virginia South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / West Virginia South (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",37],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",-81],PARAMETER[\"standard_parallel_1\",38.");
    add_srs_wkt (p, 9,
        "8833333333333],PARAMETER[\"standard_parallel_2\",37.4833");
    add_srs_wkt (p, 10,
        "333333333],PARAMETER[\"false_easting\",1968500],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"268");
    add_srs_wkt (p, 14,
        "54\"]]");
    p = add_epsg_def_ex (filter, first, last, 26855, "epsg", 26855,
        "NAD83(HARN) / Maine East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maine East (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",43.6666666666667");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-68.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9999],PARAMETER[\"false_easting\",984250],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 11,
        ".304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"26855\"]]");
    p = add_epsg_def_ex (filter, first, last, 26856, "epsg", 26856,
        "NAD83(HARN) / Maine West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maine West (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",42.8333333333333");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-70.1666666666667],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",0.999966667],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",2952750],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"26856\"]]");
    p = add_epsg_def_ex (filter, first, last, 26857, "epsg", 26857,
        "NAD83(HARN) / Minnesota North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.00");
    add_proj4text (p, 2,
        "00101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 3,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",46");
    add_srs_wkt (p, 8,
        ".5],PARAMETER[\"central_meridian\",-93.1],PARAMETER[\"st");
    add_srs_wkt (p, 9,
        "andard_parallel_1\",48.6333333333333],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",47.0333333333333],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",2624666.6667],PARAMETER[\"false_northing\",328083.");
    add_srs_wkt (p, 12,
        "3333],UNIT[\"US survey foot\",0.304800609601219,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 14,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"26857\"]]");
    p = add_epsg_def_ex (filter, first, last, 26858, "epsg", 26858,
        "NAD83(HARN) / Minnesota Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000.0000101599 +y_0=99999.999989");
    add_proj4text (p, 2,
        "83997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota Central (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_N");
    add_srs_wkt (p, 2,
        "etwork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 7,
        "t_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",45],PARAMETER[\"central_meridian\",-94.25],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",47.05],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_2\",45.6166666666667],PARAMETER[\"false_easting\",262");
    add_srs_wkt (p, 11,
        "4666.6667],PARAMETER[\"false_northing\",328083.3333],UNI");
    add_srs_wkt (p, 12,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"26858\"]]");
    p = add_epsg_def_ex (filter, first, last, 26859, "epsg", 26859,
        "NAD83(HARN) / Minnesota South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101599 +y_0=999");
    add_proj4text (p, 2,
        "99.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",43");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-94],PARAMETER[\"standa");
    add_srs_wkt (p, 9,
        "rd_parallel_1\",45.2166666666667],PARAMETER[\"standard_p");
    add_srs_wkt (p, 10,
        "arallel_2\",43.7833333333333],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",2624666.6667],PARAMETER[\"false_northing\",328083.3333]");
    add_srs_wkt (p, 12,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"26859\"]]");
    p = add_epsg_def_ex (filter, first, last, 26860, "epsg", 26860,
        "NAD83(HARN) / Nebraska (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Nebraska (ftUS)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"latitude_of_origin\",39.83333");
    add_srs_wkt (p, 8,
        "33333333],PARAMETER[\"central_meridian\",-100],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_1\",43],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_2\",40],PARAMETER[\"false_easting\",1640416.6667],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 12,
        "04800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"East");
    add_srs_wkt (p, 13,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"26860\"]]");
    p = add_epsg_def_ex (filter, first, last, 26861, "epsg", 26861,
        "NAD83(HARN) / West Virginia North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / West Virginia North (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference");
    add_srs_wkt (p, 2,
        "_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",38.5],PARAMETER[\"central_meridian\",-79.5],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_1\",40.25],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 10,
        "rallel_2\",39],PARAMETER[\"false_easting\",1968500],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "26861\"]]");
    p = add_epsg_def_ex (filter, first, last, 26862, "epsg", 26862,
        "NAD83(HARN) / West Virginia South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / West Virginia South (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference");
    add_srs_wkt (p, 2,
        "_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",37],PARAMETER[\"central_meridian\",-81],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",38.8833333333333],PARAMETER[\"stan");
    add_srs_wkt (p, 10,
        "dard_parallel_2\",37.4833333333333],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",1968500],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"26862\"]]");
    p = add_epsg_def_ex (filter, first, last, 26863, "epsg", 26863,
        "NAD83(NSRS2007) / Maine East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Maine East (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",43.6666666666667],PARAMETER[\"central_meridian\",-68.5]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",984250],PARAMETER[\"false_northing\",0],UNIT[\"U");
    add_srs_wkt (p, 11,
        "S survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"26863\"]]");
    p = add_epsg_def_ex (filter, first, last, 26864, "epsg", 26864,
        "NAD83(NSRS2007) / Maine West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Maine West (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",42.8333333333333],PARAMETER[\"central_meridian\",-70.16");
    add_srs_wkt (p, 9,
        "66666666667],PARAMETER[\"scale_factor\",0.999966667],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",2952750],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"26864\"]]");
    p = add_epsg_def_ex (filter, first, last, 26865, "epsg", 26865,
        "NAD83(NSRS2007) / Minnesota North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.00");
    add_proj4text (p, 2,
        "00101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 3,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Minnesota North (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",46.5],PARAMETER[\"central_meridian\",-93.");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"standard_parallel_1\",48.6333333333333],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",47.0333333333333],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",2624666.6667],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",328083.3333],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 13,
        "09601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 14,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2686");
    add_srs_wkt (p, 15,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 26866, "epsg", 26866,
        "NAD83(NSRS2007) / Minnesota Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000.0000101599 +y_0=99999.999989");
    add_proj4text (p, 2,
        "83997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Minnesota Central (ftUS)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_");
    add_srs_wkt (p, 2,
        "Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",45],PARAMETER[\"central_meridian\",-94.2");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"standard_parallel_1\",47.05],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "standard_parallel_2\",45.6166666666667],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",2624666.6667],PARAMETER[\"false_northing\",3");
    add_srs_wkt (p, 12,
        "28083.3333],UNIT[\"US survey foot\",0.304800609601219,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 14,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26866\"]]");
    p = add_epsg_def_ex (filter, first, last, 26867, "epsg", 26867,
        "NAD83(NSRS2007) / Minnesota South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101599 +y_0=999");
    add_proj4text (p, 2,
        "99.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Minnesota South (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4759\"]],PROJEC");
    add_srs_wkt (p, 7,
        "TION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",43],PARAMETER[\"central_meridian\",-94],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"standard_parallel_1\",45.2166666666667],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"standard_parallel_2\",43.7833333333333],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",2624666.6667],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",328083.3333],UNIT[\"US survey foot\",0.30480060960");
    add_srs_wkt (p, 13,
        "1219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 14,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"26867\"]");
    add_srs_wkt (p, 15,
        "]");
}

#endif /* full EPSG initialization enabled/disabled */

