/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Mon Jan 25 12:52:11 2021

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_40 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 7853, "epsg", 7853,
        "GDA2020 / MGA zone 53", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 53\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",135],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7853\"]]");
    p = add_epsg_def_ex (filter, first, last, 7854, "epsg", 7854,
        "GDA2020 / MGA zone 54", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 54\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",141],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7854\"]]");
    p = add_epsg_def_ex (filter, first, last, 7855, "epsg", 7855,
        "GDA2020 / MGA zone 55", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 55\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",147],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7855\"]]");
    p = add_epsg_def_ex (filter, first, last, 7856, "epsg", 7856,
        "GDA2020 / MGA zone 56", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 56\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",153],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7856\"]]");
    p = add_epsg_def_ex (filter, first, last, 7857, "epsg", 7857,
        "GDA2020 / MGA zone 57", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 57\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",159],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7857\"]]");
    p = add_epsg_def_ex (filter, first, last, 7858, "epsg", 7858,
        "GDA2020 / MGA zone 58", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 58\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",165],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7858\"]]");
    p = add_epsg_def_ex (filter, first, last, 7859, "epsg", 7859,
        "GDA2020 / MGA zone 59", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MGA zone 59\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",171],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",500000],PARAMETER[\"false_northing\",1000");
    add_srs_wkt (p, 10,
        "0000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7859\"]]");
    p = add_epsg_def_ex (filter, first, last, 7877, "epsg", 7877,
        "Astro DOS 71 / SHLG71", 0, 0,
        "International 1924", "Greenwich",
        "Astro_DOS_71", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-15.96666666666667 +lon_0=-5.71666666");
    add_proj4text (p, 1,
        "6666667 +k=1 +x_0=300000 +y_0=2000000 +ellps=intl +towgs");
    add_proj4text (p, 2,
        "84=-320,550,-494,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Astro DOS 71 / SHLG71\",GEOGCS[\"Astro DOS 71\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Astro_DOS_71\",SPHEROID[\"International 1924\",");
    add_srs_wkt (p, 2,
        "6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6710\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4710\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",-15.9666666666667],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-5.71666666666667],PARAMETER[\"scale_factor\",1],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"false_easting\",300000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",2000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"7877\"]]");
    p = add_epsg_def_ex (filter, first, last, 7878, "epsg", 7878,
        "Astro DOS 71 / UTM zone 30S", 0, 0,
        "International 1924", "Greenwich",
        "Astro_DOS_71", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +south +ellps=intl +towgs84=-320,550,");
    add_proj4text (p, 1,
        "-494,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Astro DOS 71 / UTM zone 30S\",GEOGCS[\"Astro DO");
    add_srs_wkt (p, 1,
        "S 71\",DATUM[\"Astro_DOS_71\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6710\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4710\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-3],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"787");
    add_srs_wkt (p, 12,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 7880, "epsg", 7880,
        "St. Helena Tritan", 1, 1,
        "WGS 84", "Greenwich",
        "St_Helena_Tritan", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=-0.077,0.079,0.086,0");
    add_proj4text (p, 1,
        ",0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"St. Helena Tritan\",DATUM[\"St. Helena Tritan\"");
    add_srs_wkt (p, 1,
        ",ELLIPSOID[\"WGS 84\",6378137,298.257223563,LENGTHUNIT[\"");
    add_srs_wkt (p, 2,
        "metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\"");
    add_srs_wkt (p, 3,
        ",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic ");
    add_srs_wkt (p, 4,
        "latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433]],AXIS[\"geodetic longitude (Lon)\",east");
    add_srs_wkt (p, 6,
        ",ORDER[2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS");
    add_srs_wkt (p, 7,
        "[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"met");
    add_srs_wkt (p, 8,
        "re\",1]],USAGE[SCOPE[\"Engineering survey including Airp");
    add_srs_wkt (p, 9,
        "ort and Ruperts Wharf construction.\"],AREA[\"St Helena,");
    add_srs_wkt (p, 10,
        " Ascension and Tristan da Cunha - St Helena Island - ons");
    add_srs_wkt (p, 11,
        "hore.\"],BBOX[-16.08,-5.85,-15.85,-5.58]],ID[\"EPSG\",78");
    add_srs_wkt (p, 12,
        "80]]");
    p = add_epsg_def_ex (filter, first, last, 7881, "epsg", 7881,
        "St. Helena Tritan", 1, 1,
        "WGS 84", "Greenwich",
        "St_Helena_Tritan", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=WGS84 +towgs84=-0.077,0.079,0.086,0");
    add_proj4text (p, 1,
        ",0,0,0 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"St. Helena Tritan\",DATUM[\"St_Helena_Tritan\",");
    add_srs_wkt (p, 1,
        "SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EP");
    add_srs_wkt (p, 2,
        "SG\",\"7030\"]],AUTHORITY[\"EPSG\",\"1173\"]],PRIMEM[\"G");
    add_srs_wkt (p, 3,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 4,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 5,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"7881\"]]");
    p = add_epsg_def_ex (filter, first, last, 7882, "epsg", 7882,
        "St. Helena Tritan / SHLG(Tritan)", 0, 0,
        "WGS 84", "Greenwich",
        "St_Helena_Tritan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-15.96666666666667 +lon_0=-5.71666666");
    add_proj4text (p, 1,
        "6666667 +k=1 +x_0=299483.737 +y_0=2000527.879 +ellps=WGS");
    add_proj4text (p, 2,
        "84 +towgs84=-0.077,0.079,0.086,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"St. Helena Tritan / SHLG(Tritan)\",GEOGCS[\"St.");
    add_srs_wkt (p, 1,
        " Helena Tritan\",DATUM[\"St_Helena_Tritan\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1173\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7881\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",-15.9666666666667],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-5.71666666666667],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",1],PARAMETER[\"false_easting\",299483.737],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",2000527.879],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7882\"]]");
    p = add_epsg_def_ex (filter, first, last, 7883, "epsg", 7883,
        "St. Helena Tritan / UTM zone 30S", 0, 0,
        "WGS 84", "Greenwich",
        "St_Helena_Tritan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +south +ellps=WGS84 +towgs84=-0.077,0");
    add_proj4text (p, 1,
        ".079,0.086,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"St. Helena Tritan / UTM zone 30S\",GEOGCS[\"St.");
    add_srs_wkt (p, 1,
        " Helena Tritan\",DATUM[\"St_Helena_Tritan\",SPHEROID[\"W");
    add_srs_wkt (p, 2,
        "GS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1173\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7881\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",10000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"7883\"]]");
    p = add_epsg_def_ex (filter, first, last, 7885, "epsg", 7885,
        "SHGD2015", 1, 1,
        "GRS 1980", "Greenwich",
        "St_Helena_Geodetic_Datum_2015", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"SHGD2015\",DATUM[\"St. Helena Geodetic Datum 2");
    add_srs_wkt (p, 1,
        "015\",ELLIPSOID[\"GRS 1980\",6378137,298.257222101,LENGT");
    add_srs_wkt (p, 2,
        "HUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"");
    add_srs_wkt (p, 3,
        "degree\",0.0174532925199433]],CS[ellipsoidal,3],AXIS[\"g");
    add_srs_wkt (p, 4,
        "eodetic latitude (Lat)\",north,ORDER[1],ANGLEUNIT[\"degr");
    add_srs_wkt (p, 5,
        "ee\",0.0174532925199433]],AXIS[\"geodetic longitude (Lon");
    add_srs_wkt (p, 6,
        ")\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 7,
        "3]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3],LENGTHUN");
    add_srs_wkt (p, 8,
        "IT[\"metre\",1]],USAGE[SCOPE[\"Engineering survey includ");
    add_srs_wkt (p, 9,
        "ing Airport and Ruperts Wharf construction.\"],AREA[\"St");
    add_srs_wkt (p, 10,
        " Helena, Ascension and Tristan da Cunha - St Helena Isla");
    add_srs_wkt (p, 11,
        "nd - onshore.\"],BBOX[-16.08,-5.85,-15.85,-5.58]],ID[\"E");
    add_srs_wkt (p, 12,
        "PSG\",7885]]");
    p = add_epsg_def_ex (filter, first, last, 7886, "epsg", 7886,
        "SHGD2015", 1, 1,
        "GRS 1980", "Greenwich",
        "St_Helena_Geodetic_Datum_2015", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"SHGD2015\",DATUM[\"St_Helena_Geodetic_Datum_201");
    add_srs_wkt (p, 1,
        "5\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1174\"]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"7886\"]]");
    p = add_epsg_def_ex (filter, first, last, 7887, "epsg", 7887,
        "SHMG2015", 0, 0,
        "GRS 1980", "Greenwich",
        "St_Helena_Geodetic_Datum_2015", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SHMG2015\",GEOGCS[\"SHGD2015\",DATUM[\"St_Helen");
    add_srs_wkt (p, 1,
        "a_Geodetic_Datum_2015\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"1174\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"7886\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 7,
        "rigin\",0],PARAMETER[\"central_meridian\",-3],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 9,
        "000],PARAMETER[\"false_northing\",10000000],UNIT[\"metre");
    add_srs_wkt (p, 10,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 11,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"7887\"]]");
    p = add_epsg_def_ex (filter, first, last, 7899, "epsg", 7899,
        "GDA2020 / Vicgrid", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=-36 +lat_2=-38 +lat_0=-37 +lon_0=145 +x");
    add_proj4text (p, 1,
        "_0=2500000 +y_0=2500000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / Vicgrid\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"latitude_of_origin\",-37],PARAMETER[\"central_m");
    add_srs_wkt (p, 8,
        "eridian\",145],PARAMETER[\"standard_parallel_1\",-36],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"standard_parallel_2\",-38],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",2500000],PARAMETER[\"false_northing\",2500000],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"7899\"]]");
    p = add_epsg_def_ex (filter, first, last, 7900, "epsg", 7900,
        "ITRF88", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1988", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ITRF88\",DYNAMIC[FRAMEEPOCH[1988]],DATUM[\"Int");
    add_srs_wkt (p, 1,
        "ernational Terrestrial Reference Frame 1988\",ELLIPSOID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",");
    add_srs_wkt (p, 3,
        "1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude");
    add_srs_wkt (p, 5,
        " (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2");
    add_srs_wkt (p, 7,
        "],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellip");
    add_srs_wkt (p, 8,
        "soidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]]");
    add_srs_wkt (p, 9,
        ",USAGE[SCOPE[\"Geodesy.\"],AREA[\"World.\"],BBOX[-90,-18");
    add_srs_wkt (p, 10,
        "0,90,180]],ID[\"EPSG\",7900]]");
    p = add_epsg_def_ex (filter, first, last, 7901, "epsg", 7901,
        "ITRF89", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1989", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ITRF89\",DYNAMIC[FRAMEEPOCH[1988]],DATUM[\"Int");
    add_srs_wkt (p, 1,
        "ernational Terrestrial Reference Frame 1989\",ELLIPSOID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",");
    add_srs_wkt (p, 3,
        "1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude");
    add_srs_wkt (p, 5,
        " (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2");
    add_srs_wkt (p, 7,
        "],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellip");
    add_srs_wkt (p, 8,
        "soidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]]");
    add_srs_wkt (p, 9,
        ",USAGE[SCOPE[\"Geodesy.\"],AREA[\"World.\"],BBOX[-90,-18");
    add_srs_wkt (p, 10,
        "0,90,180]],ID[\"EPSG\",7901]]");
    p = add_epsg_def_ex (filter, first, last, 7902, "epsg", 7902,
        "ITRF90", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1990", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ITRF90\",DYNAMIC[FRAMEEPOCH[1988]],DATUM[\"Int");
    add_srs_wkt (p, 1,
        "ernational Terrestrial Reference Frame 1990\",ELLIPSOID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",");
    add_srs_wkt (p, 3,
        "1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude");
    add_srs_wkt (p, 5,
        " (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2");
    add_srs_wkt (p, 7,
        "],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellip");
    add_srs_wkt (p, 8,
        "soidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]]");
    add_srs_wkt (p, 9,
        ",USAGE[SCOPE[\"Geodesy.\"],AREA[\"World.\"],BBOX[-90,-18");
    add_srs_wkt (p, 10,
        "0,90,180]],ID[\"EPSG\",7902]]");
    p = add_epsg_def_ex (filter, first, last, 7903, "epsg", 7903,
        "ITRF91", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1991", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ITRF91\",DYNAMIC[FRAMEEPOCH[1988]],DATUM[\"Int");
    add_srs_wkt (p, 1,
        "ernational Terrestrial Reference Frame 1991\",ELLIPSOID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",");
    add_srs_wkt (p, 3,
        "1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude");
    add_srs_wkt (p, 5,
        " (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2");
    add_srs_wkt (p, 7,
        "],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellip");
    add_srs_wkt (p, 8,
        "soidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]]");
    add_srs_wkt (p, 9,
        ",USAGE[SCOPE[\"Geodesy.\"],AREA[\"World.\"],BBOX[-90,-18");
    add_srs_wkt (p, 10,
        "0,90,180]],ID[\"EPSG\",7903]]");
    p = add_epsg_def_ex (filter, first, last, 7904, "epsg", 7904,
        "ITRF92", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ITRF92\",DYNAMIC[FRAMEEPOCH[1988]],DATUM[\"Int");
    add_srs_wkt (p, 1,
        "ernational Terrestrial Reference Frame 1992\",ELLIPSOID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",");
    add_srs_wkt (p, 3,
        "1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude");
    add_srs_wkt (p, 5,
        " (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2");
    add_srs_wkt (p, 7,
        "],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellip");
    add_srs_wkt (p, 8,
        "soidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]]");
    add_srs_wkt (p, 9,
        ",USAGE[SCOPE[\"Geodesy.\"],AREA[\"World.\"],BBOX[-90,-18");
    add_srs_wkt (p, 10,
        "0,90,180]],ID[\"EPSG\",7904]]");
    p = add_epsg_def_ex (filter, first, last, 7905, "epsg", 7905,
        "ITRF93", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1993", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ITRF93\",DYNAMIC[FRAMEEPOCH[1993]],DATUM[\"Int");
    add_srs_wkt (p, 1,
        "ernational Terrestrial Reference Frame 1993\",ELLIPSOID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",");
    add_srs_wkt (p, 3,
        "1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude");
    add_srs_wkt (p, 5,
        " (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2");
    add_srs_wkt (p, 7,
        "],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellip");
    add_srs_wkt (p, 8,
        "soidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]]");
    add_srs_wkt (p, 9,
        ",USAGE[SCOPE[\"Geodesy.\"],AREA[\"World.\"],BBOX[-90,-18");
    add_srs_wkt (p, 10,
        "0,90,180]],ID[\"EPSG\",7905]]");
    p = add_epsg_def_ex (filter, first, last, 7906, "epsg", 7906,
        "ITRF94", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1994", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ITRF94\",DYNAMIC[FRAMEEPOCH[1993]],DATUM[\"Int");
    add_srs_wkt (p, 1,
        "ernational Terrestrial Reference Frame 1994\",ELLIPSOID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",");
    add_srs_wkt (p, 3,
        "1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude");
    add_srs_wkt (p, 5,
        " (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2");
    add_srs_wkt (p, 7,
        "],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellip");
    add_srs_wkt (p, 8,
        "soidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]]");
    add_srs_wkt (p, 9,
        ",USAGE[SCOPE[\"Geodesy.\"],AREA[\"World.\"],BBOX[-90,-18");
    add_srs_wkt (p, 10,
        "0,90,180]],ID[\"EPSG\",7906]]");
    p = add_epsg_def_ex (filter, first, last, 7907, "epsg", 7907,
        "ITRF96", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ITRF96\",DYNAMIC[FRAMEEPOCH[1997]],DATUM[\"Int");
    add_srs_wkt (p, 1,
        "ernational Terrestrial Reference Frame 1996\",ELLIPSOID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",");
    add_srs_wkt (p, 3,
        "1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude");
    add_srs_wkt (p, 5,
        " (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2");
    add_srs_wkt (p, 7,
        "],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellip");
    add_srs_wkt (p, 8,
        "soidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]]");
    add_srs_wkt (p, 9,
        ",USAGE[SCOPE[\"Geodesy.\"],AREA[\"World.\"],BBOX[-90,-18");
    add_srs_wkt (p, 10,
        "0,90,180]],ID[\"EPSG\",7907]]");
    p = add_epsg_def_ex (filter, first, last, 7908, "epsg", 7908,
        "ITRF97", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_1997", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ITRF97\",DYNAMIC[FRAMEEPOCH[1997]],DATUM[\"Int");
    add_srs_wkt (p, 1,
        "ernational Terrestrial Reference Frame 1997\",ELLIPSOID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\",");
    add_srs_wkt (p, 3,
        "1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitude");
    add_srs_wkt (p, 5,
        " (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[2");
    add_srs_wkt (p, 7,
        "],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"ellip");
    add_srs_wkt (p, 8,
        "soidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]]");
    add_srs_wkt (p, 9,
        ",USAGE[SCOPE[\"Geodesy.\"],AREA[\"World.\"],BBOX[-90,-18");
    add_srs_wkt (p, 10,
        "0,90,180]],ID[\"EPSG\",7908]]");
    p = add_epsg_def_ex (filter, first, last, 7909, "epsg", 7909,
        "ITRF2000", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ITRF2000\",DYNAMIC[FRAMEEPOCH[1997]],DATUM[\"I");
    add_srs_wkt (p, 1,
        "nternational Terrestrial Reference Frame 2000\",ELLIPSOI");
    add_srs_wkt (p, 2,
        "D[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 3,
        ",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 4,
        "532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitud");
    add_srs_wkt (p, 5,
        "e (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[");
    add_srs_wkt (p, 7,
        "2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"elli");
    add_srs_wkt (p, 8,
        "psoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]");
    add_srs_wkt (p, 9,
        "],USAGE[SCOPE[\"Geodesy.\"],AREA[\"World.\"],BBOX[-90,-1");
    add_srs_wkt (p, 10,
        "80,90,180]],ID[\"EPSG\",7909]]");
    p = add_epsg_def_ex (filter, first, last, 7910, "epsg", 7910,
        "ITRF2005", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_2005", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ITRF2005\",DYNAMIC[FRAMEEPOCH[2000]],DATUM[\"I");
    add_srs_wkt (p, 1,
        "nternational Terrestrial Reference Frame 2005\",ELLIPSOI");
    add_srs_wkt (p, 2,
        "D[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 3,
        ",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 4,
        "532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitud");
    add_srs_wkt (p, 5,
        "e (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[");
    add_srs_wkt (p, 7,
        "2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"elli");
    add_srs_wkt (p, 8,
        "psoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]");
    add_srs_wkt (p, 9,
        "],USAGE[SCOPE[\"Geodesy.\"],AREA[\"World.\"],BBOX[-90,-1");
    add_srs_wkt (p, 10,
        "80,90,180]],ID[\"EPSG\",7910]]");
    p = add_epsg_def_ex (filter, first, last, 7911, "epsg", 7911,
        "ITRF2008", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_2008", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ITRF2008\",DYNAMIC[FRAMEEPOCH[2005]],DATUM[\"I");
    add_srs_wkt (p, 1,
        "nternational Terrestrial Reference Frame 2008\",ELLIPSOI");
    add_srs_wkt (p, 2,
        "D[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 3,
        ",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 4,
        "532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitud");
    add_srs_wkt (p, 5,
        "e (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[");
    add_srs_wkt (p, 7,
        "2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"elli");
    add_srs_wkt (p, 8,
        "psoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]");
    add_srs_wkt (p, 9,
        "],USAGE[SCOPE[\"Geodesy.\"],AREA[\"World.\"],BBOX[-90,-1");
    add_srs_wkt (p, 10,
        "80,90,180]],ID[\"EPSG\",7911]]");
    p = add_epsg_def_ex (filter, first, last, 7912, "epsg", 7912,
        "ITRF2014", 1, 1,
        "GRS 1980", "Greenwich",
        "International_Terrestrial_Reference_Frame_2014", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ITRF2014\",DYNAMIC[FRAMEEPOCH[2010]],DATUM[\"I");
    add_srs_wkt (p, 1,
        "nternational Terrestrial Reference Frame 2014\",ELLIPSOI");
    add_srs_wkt (p, 2,
        "D[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 3,
        ",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 4,
        "532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitud");
    add_srs_wkt (p, 5,
        "e (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[");
    add_srs_wkt (p, 7,
        "2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"elli");
    add_srs_wkt (p, 8,
        "psoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]");
    add_srs_wkt (p, 9,
        "],USAGE[SCOPE[\"Geodesy.\"],AREA[\"World.\"],BBOX[-90,-1");
    add_srs_wkt (p, 10,
        "80,90,180]],ID[\"EPSG\",7912]]");
    p = add_epsg_def_ex (filter, first, last, 7915, "epsg", 7915,
        "ETRF89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_1989", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ETRF89\",DATUM[\"European Terrestrial Referenc");
    add_srs_wkt (p, 1,
        "e Frame 1989\",ELLIPSOID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANG");
    add_srs_wkt (p, 3,
        "LEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3]");
    add_srs_wkt (p, 4,
        ",AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"geodetic longi");
    add_srs_wkt (p, 6,
        "tude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453");
    add_srs_wkt (p, 7,
        "2925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3]");
    add_srs_wkt (p, 8,
        ",LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA");
    add_srs_wkt (p, 9,
        "[\"Europe - onshore and offshore: Albania; Andorra; Aust");
    add_srs_wkt (p, 10,
        "ria; Belgium; Bosnia and Herzegovina; Bulgaria; Croatia;");
    add_srs_wkt (p, 11,
        " Cyprus; Czechia; Denmark; Estonia; Faroe Islands; Finla");
    add_srs_wkt (p, 12,
        "nd; France; Germany; Gibraltar; Greece; Hungary; Ireland");
    add_srs_wkt (p, 13,
        "; Italy; Kosovo; Latvia; Liechtenstein; Lithuania; Luxem");
    add_srs_wkt (p, 14,
        "bourg; Malta; Moldova; Monaco; Montenegro; Netherlands; ");
    add_srs_wkt (p, 15,
        "North Macedonia; Norway including Svalbard and Jan Mayen");
    add_srs_wkt (p, 16,
        "; Poland; Portugal; Romania; San Marino; Serbia; Slovaki");
    add_srs_wkt (p, 17,
        "a; Slovenia; Spain; Sweden; Switzerland; United Kingdom ");
    add_srs_wkt (p, 18,
        "(UK) including Channel Islands and Isle of Man; Vatican ");
    add_srs_wkt (p, 19,
        "City State.\"],BBOX[32.88,-16.1,84.17,40.18]],ID[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",7915]]");
    p = add_epsg_def_ex (filter, first, last, 7917, "epsg", 7917,
        "ETRF90", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_1990", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ETRF90\",DATUM[\"European Terrestrial Referenc");
    add_srs_wkt (p, 1,
        "e Frame 1990\",ELLIPSOID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANG");
    add_srs_wkt (p, 3,
        "LEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3]");
    add_srs_wkt (p, 4,
        ",AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"geodetic longi");
    add_srs_wkt (p, 6,
        "tude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453");
    add_srs_wkt (p, 7,
        "2925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3]");
    add_srs_wkt (p, 8,
        ",LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA");
    add_srs_wkt (p, 9,
        "[\"Europe - onshore and offshore: Albania; Andorra; Aust");
    add_srs_wkt (p, 10,
        "ria; Belgium; Bosnia and Herzegovina; Bulgaria; Croatia;");
    add_srs_wkt (p, 11,
        " Cyprus; Czechia; Denmark; Estonia; Faroe Islands; Finla");
    add_srs_wkt (p, 12,
        "nd; France; Germany; Gibraltar; Greece; Hungary; Ireland");
    add_srs_wkt (p, 13,
        "; Italy; Kosovo; Latvia; Liechtenstein; Lithuania; Luxem");
    add_srs_wkt (p, 14,
        "bourg; Malta; Moldova; Monaco; Montenegro; Netherlands; ");
    add_srs_wkt (p, 15,
        "North Macedonia; Norway including Svalbard and Jan Mayen");
    add_srs_wkt (p, 16,
        "; Poland; Portugal; Romania; San Marino; Serbia; Slovaki");
    add_srs_wkt (p, 17,
        "a; Slovenia; Spain; Sweden; Switzerland; United Kingdom ");
    add_srs_wkt (p, 18,
        "(UK) including Channel Islands and Isle of Man; Vatican ");
    add_srs_wkt (p, 19,
        "City State.\"],BBOX[32.88,-16.1,84.17,40.18]],ID[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",7917]]");
    p = add_epsg_def_ex (filter, first, last, 7919, "epsg", 7919,
        "ETRF91", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_1991", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ETRF91\",DATUM[\"European Terrestrial Referenc");
    add_srs_wkt (p, 1,
        "e Frame 1991\",ELLIPSOID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANG");
    add_srs_wkt (p, 3,
        "LEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3]");
    add_srs_wkt (p, 4,
        ",AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"geodetic longi");
    add_srs_wkt (p, 6,
        "tude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453");
    add_srs_wkt (p, 7,
        "2925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3]");
    add_srs_wkt (p, 8,
        ",LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA");
    add_srs_wkt (p, 9,
        "[\"Europe - onshore and offshore: Albania; Andorra; Aust");
    add_srs_wkt (p, 10,
        "ria; Belgium; Bosnia and Herzegovina; Bulgaria; Croatia;");
    add_srs_wkt (p, 11,
        " Cyprus; Czechia; Denmark; Estonia; Faroe Islands; Finla");
    add_srs_wkt (p, 12,
        "nd; France; Germany; Gibraltar; Greece; Hungary; Ireland");
    add_srs_wkt (p, 13,
        "; Italy; Kosovo; Latvia; Liechtenstein; Lithuania; Luxem");
    add_srs_wkt (p, 14,
        "bourg; Malta; Moldova; Monaco; Montenegro; Netherlands; ");
    add_srs_wkt (p, 15,
        "North Macedonia; Norway including Svalbard and Jan Mayen");
    add_srs_wkt (p, 16,
        "; Poland; Portugal; Romania; San Marino; Serbia; Slovaki");
    add_srs_wkt (p, 17,
        "a; Slovenia; Spain; Sweden; Switzerland; United Kingdom ");
    add_srs_wkt (p, 18,
        "(UK) including Channel Islands and Isle of Man; Vatican ");
    add_srs_wkt (p, 19,
        "City State.\"],BBOX[32.88,-16.1,84.17,40.18]],ID[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",7919]]");
    p = add_epsg_def_ex (filter, first, last, 7921, "epsg", 7921,
        "ETRF92", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_1992", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ETRF92\",DATUM[\"European Terrestrial Referenc");
    add_srs_wkt (p, 1,
        "e Frame 1992\",ELLIPSOID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANG");
    add_srs_wkt (p, 3,
        "LEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3]");
    add_srs_wkt (p, 4,
        ",AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"geodetic longi");
    add_srs_wkt (p, 6,
        "tude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453");
    add_srs_wkt (p, 7,
        "2925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3]");
    add_srs_wkt (p, 8,
        ",LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA");
    add_srs_wkt (p, 9,
        "[\"Europe - onshore and offshore: Albania; Andorra; Aust");
    add_srs_wkt (p, 10,
        "ria; Belgium; Bosnia and Herzegovina; Bulgaria; Croatia;");
    add_srs_wkt (p, 11,
        " Cyprus; Czechia; Denmark; Estonia; Faroe Islands; Finla");
    add_srs_wkt (p, 12,
        "nd; France; Germany; Gibraltar; Greece; Hungary; Ireland");
    add_srs_wkt (p, 13,
        "; Italy; Kosovo; Latvia; Liechtenstein; Lithuania; Luxem");
    add_srs_wkt (p, 14,
        "bourg; Malta; Moldova; Monaco; Montenegro; Netherlands; ");
    add_srs_wkt (p, 15,
        "North Macedonia; Norway including Svalbard and Jan Mayen");
    add_srs_wkt (p, 16,
        "; Poland; Portugal; Romania; San Marino; Serbia; Slovaki");
    add_srs_wkt (p, 17,
        "a; Slovenia; Spain; Sweden; Switzerland; United Kingdom ");
    add_srs_wkt (p, 18,
        "(UK) including Channel Islands and Isle of Man; Vatican ");
    add_srs_wkt (p, 19,
        "City State.\"],BBOX[32.88,-16.1,84.17,40.18]],ID[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",7921]]");
    p = add_epsg_def_ex (filter, first, last, 7923, "epsg", 7923,
        "ETRF93", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_1993", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ETRF93\",DATUM[\"European Terrestrial Referenc");
    add_srs_wkt (p, 1,
        "e Frame 1993\",ELLIPSOID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANG");
    add_srs_wkt (p, 3,
        "LEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3]");
    add_srs_wkt (p, 4,
        ",AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"geodetic longi");
    add_srs_wkt (p, 6,
        "tude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453");
    add_srs_wkt (p, 7,
        "2925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3]");
    add_srs_wkt (p, 8,
        ",LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA");
    add_srs_wkt (p, 9,
        "[\"Europe - onshore and offshore: Albania; Andorra; Aust");
    add_srs_wkt (p, 10,
        "ria; Belgium; Bosnia and Herzegovina; Bulgaria; Croatia;");
    add_srs_wkt (p, 11,
        " Cyprus; Czechia; Denmark; Estonia; Faroe Islands; Finla");
    add_srs_wkt (p, 12,
        "nd; France; Germany; Gibraltar; Greece; Hungary; Ireland");
    add_srs_wkt (p, 13,
        "; Italy; Kosovo; Latvia; Liechtenstein; Lithuania; Luxem");
    add_srs_wkt (p, 14,
        "bourg; Malta; Moldova; Monaco; Montenegro; Netherlands; ");
    add_srs_wkt (p, 15,
        "North Macedonia; Norway including Svalbard and Jan Mayen");
    add_srs_wkt (p, 16,
        "; Poland; Portugal; Romania; San Marino; Serbia; Slovaki");
    add_srs_wkt (p, 17,
        "a; Slovenia; Spain; Sweden; Switzerland; United Kingdom ");
    add_srs_wkt (p, 18,
        "(UK) including Channel Islands and Isle of Man; Vatican ");
    add_srs_wkt (p, 19,
        "City State.\"],BBOX[32.88,-16.1,84.17,40.18]],ID[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",7923]]");
    p = add_epsg_def_ex (filter, first, last, 7925, "epsg", 7925,
        "ETRF94", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_1994", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ETRF94\",DATUM[\"European Terrestrial Referenc");
    add_srs_wkt (p, 1,
        "e Frame 1994\",ELLIPSOID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANG");
    add_srs_wkt (p, 3,
        "LEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3]");
    add_srs_wkt (p, 4,
        ",AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"geodetic longi");
    add_srs_wkt (p, 6,
        "tude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453");
    add_srs_wkt (p, 7,
        "2925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3]");
    add_srs_wkt (p, 8,
        ",LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA");
    add_srs_wkt (p, 9,
        "[\"Europe - onshore and offshore: Albania; Andorra; Aust");
    add_srs_wkt (p, 10,
        "ria; Belgium; Bosnia and Herzegovina; Bulgaria; Croatia;");
    add_srs_wkt (p, 11,
        " Cyprus; Czechia; Denmark; Estonia; Faroe Islands; Finla");
    add_srs_wkt (p, 12,
        "nd; France; Germany; Gibraltar; Greece; Hungary; Ireland");
    add_srs_wkt (p, 13,
        "; Italy; Kosovo; Latvia; Liechtenstein; Lithuania; Luxem");
    add_srs_wkt (p, 14,
        "bourg; Malta; Moldova; Monaco; Montenegro; Netherlands; ");
    add_srs_wkt (p, 15,
        "North Macedonia; Norway including Svalbard and Jan Mayen");
    add_srs_wkt (p, 16,
        "; Poland; Portugal; Romania; San Marino; Serbia; Slovaki");
    add_srs_wkt (p, 17,
        "a; Slovenia; Spain; Sweden; Switzerland; United Kingdom ");
    add_srs_wkt (p, 18,
        "(UK) including Channel Islands and Isle of Man; Vatican ");
    add_srs_wkt (p, 19,
        "City State.\"],BBOX[32.88,-16.1,84.17,40.18]],ID[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",7925]]");
    p = add_epsg_def_ex (filter, first, last, 7927, "epsg", 7927,
        "ETRF96", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_1996", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ETRF96\",DATUM[\"European Terrestrial Referenc");
    add_srs_wkt (p, 1,
        "e Frame 1996\",ELLIPSOID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANG");
    add_srs_wkt (p, 3,
        "LEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3]");
    add_srs_wkt (p, 4,
        ",AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"geodetic longi");
    add_srs_wkt (p, 6,
        "tude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453");
    add_srs_wkt (p, 7,
        "2925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3]");
    add_srs_wkt (p, 8,
        ",LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA");
    add_srs_wkt (p, 9,
        "[\"Europe - onshore and offshore: Albania; Andorra; Aust");
    add_srs_wkt (p, 10,
        "ria; Belgium; Bosnia and Herzegovina; Bulgaria; Croatia;");
    add_srs_wkt (p, 11,
        " Cyprus; Czechia; Denmark; Estonia; Faroe Islands; Finla");
    add_srs_wkt (p, 12,
        "nd; France; Germany; Gibraltar; Greece; Hungary; Ireland");
    add_srs_wkt (p, 13,
        "; Italy; Kosovo; Latvia; Liechtenstein; Lithuania; Luxem");
    add_srs_wkt (p, 14,
        "bourg; Malta; Moldova; Monaco; Montenegro; Netherlands; ");
    add_srs_wkt (p, 15,
        "North Macedonia; Norway including Svalbard and Jan Mayen");
    add_srs_wkt (p, 16,
        "; Poland; Portugal; Romania; San Marino; Serbia; Slovaki");
    add_srs_wkt (p, 17,
        "a; Slovenia; Spain; Sweden; Switzerland; United Kingdom ");
    add_srs_wkt (p, 18,
        "(UK) including Channel Islands and Isle of Man; Vatican ");
    add_srs_wkt (p, 19,
        "City State.\"],BBOX[32.88,-16.1,84.17,40.18]],ID[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",7927]]");
    p = add_epsg_def_ex (filter, first, last, 7929, "epsg", 7929,
        "ETRF97", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_1997", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ETRF97\",DATUM[\"European Terrestrial Referenc");
    add_srs_wkt (p, 1,
        "e Frame 1997\",ELLIPSOID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 2,
        "101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,ANG");
    add_srs_wkt (p, 3,
        "LEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,3]");
    add_srs_wkt (p, 4,
        ",AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLEUN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433]],AXIS[\"geodetic longi");
    add_srs_wkt (p, 6,
        "tude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017453");
    add_srs_wkt (p, 7,
        "2925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[3]");
    add_srs_wkt (p, 8,
        ",LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AREA");
    add_srs_wkt (p, 9,
        "[\"Europe - onshore and offshore: Albania; Andorra; Aust");
    add_srs_wkt (p, 10,
        "ria; Belgium; Bosnia and Herzegovina; Bulgaria; Croatia;");
    add_srs_wkt (p, 11,
        " Cyprus; Czechia; Denmark; Estonia; Faroe Islands; Finla");
    add_srs_wkt (p, 12,
        "nd; France; Germany; Gibraltar; Greece; Hungary; Ireland");
    add_srs_wkt (p, 13,
        "; Italy; Kosovo; Latvia; Liechtenstein; Lithuania; Luxem");
    add_srs_wkt (p, 14,
        "bourg; Malta; Moldova; Monaco; Montenegro; Netherlands; ");
    add_srs_wkt (p, 15,
        "North Macedonia; Norway including Svalbard and Jan Mayen");
    add_srs_wkt (p, 16,
        "; Poland; Portugal; Romania; San Marino; Serbia; Slovaki");
    add_srs_wkt (p, 17,
        "a; Slovenia; Spain; Sweden; Switzerland; United Kingdom ");
    add_srs_wkt (p, 18,
        "(UK) including Channel Islands and Isle of Man; Vatican ");
    add_srs_wkt (p, 19,
        "City State.\"],BBOX[32.88,-16.1,84.17,40.18]],ID[\"EPSG\"");
    add_srs_wkt (p, 20,
        ",7929]]");
    p = add_epsg_def_ex (filter, first, last, 7931, "epsg", 7931,
        "ETRF2000", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_Frame_2000", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ETRF2000\",DATUM[\"European Terrestrial Refere");
    add_srs_wkt (p, 1,
        "nce Frame 2000\",ELLIPSOID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "22101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 3,
        "NGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal,");
    add_srs_wkt (p, 4,
        "3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGLE");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lon");
    add_srs_wkt (p, 6,
        "gitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 7,
        "532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER[");
    add_srs_wkt (p, 8,
        "3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],AR");
    add_srs_wkt (p, 9,
        "EA[\"Europe - onshore and offshore: Albania; Andorra; Au");
    add_srs_wkt (p, 10,
        "stria; Belgium; Bosnia and Herzegovina; Bulgaria; Croati");
    add_srs_wkt (p, 11,
        "a; Cyprus; Czechia; Denmark; Estonia; Faroe Islands; Fin");
    add_srs_wkt (p, 12,
        "land; France; Germany; Gibraltar; Greece; Hungary; Irela");
    add_srs_wkt (p, 13,
        "nd; Italy; Kosovo; Latvia; Liechtenstein; Lithuania; Lux");
    add_srs_wkt (p, 14,
        "embourg; Malta; Moldova; Monaco; Montenegro; Netherlands");
    add_srs_wkt (p, 15,
        "; North Macedonia; Norway including Svalbard and Jan May");
    add_srs_wkt (p, 16,
        "en; Poland; Portugal; Romania; San Marino; Serbia; Slova");
    add_srs_wkt (p, 17,
        "kia; Slovenia; Spain; Sweden; Switzerland; United Kingdo");
    add_srs_wkt (p, 18,
        "m (UK) including Channel Islands and Isle of Man; Vatica");
    add_srs_wkt (p, 19,
        "n City State.\"],BBOX[32.88,-16.1,84.17,40.18]],ID[\"EPS");
    add_srs_wkt (p, 20,
        "G\",7931]]");
    p = add_epsg_def_ex (filter, first, last, 7954, "epsg", 7954,
        "Astro DOS 71 / UTM zone 30S", 0, 0,
        "International 1924", "Greenwich",
        "Astro_DOS_71", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +south +ellps=intl +towgs84=-320,550,");
    add_proj4text (p, 1,
        "-494,0,0,0,0 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"Astro DOS 71 / UTM zone 30S + Jamestown 1971 ");
    add_srs_wkt (p, 1,
        "height\",PROJCS[\"Astro DOS 71 / UTM zone 30S\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "Astro DOS 71\",DATUM[\"Astro_DOS_71\",SPHEROID[\"Interna");
    add_srs_wkt (p, 3,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6710\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4710\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",10000000]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7878\"]],VERT_CS[\"Jamestown 1971 height\",VERT_DAT");
    add_srs_wkt (p, 14,
        "UM[\"Jamestown 1971\",2005,AUTHORITY[\"EPSG\",\"1175\"]]");
    add_srs_wkt (p, 15,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"G");
    add_srs_wkt (p, 16,
        "ravity-related height\",UP],AUTHORITY[\"EPSG\",\"7888\"]");
    add_srs_wkt (p, 17,
        "],AUTHORITY[\"EPSG\",\"7954\"]]");
    p = add_epsg_def_ex (filter, first, last, 7955, "epsg", 7955,
        "St. Helena Tritan / UTM zone 30S", 0, 0,
        "WGS 84", "Greenwich",
        "St_Helena_Tritan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +south +ellps=WGS84 +towgs84=-0.077,0");
    add_proj4text (p, 1,
        ".079,0.086,0,0,0,0 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"St. Helena Tritan / UTM zone 30S +  Tritan 20");
    add_srs_wkt (p, 1,
        "11 height\",PROJCS[\"St. Helena Tritan / UTM zone 30S\",");
    add_srs_wkt (p, 2,
        "GEOGCS[\"St. Helena Tritan\",DATUM[\"St_Helena_Tritan\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"7030\"]],AUTHORITY[\"EPSG\",\"1173\"]],PRIMEM[\"G");
    add_srs_wkt (p, 5,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"7881\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-3],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"7883\"]],VERT_CS[\"St. Helena Trit");
    add_srs_wkt (p, 14,
        "an 2011 height\",VERT_DATUM[\"St. Helena Tritan Vertical");
    add_srs_wkt (p, 15,
        " Datum 2011\",2005,AUTHORITY[\"EPSG\",\"1176\"]],UNIT[\"");
    add_srs_wkt (p, 16,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-r");
    add_srs_wkt (p, 17,
        "elated height\",UP],AUTHORITY[\"EPSG\",\"7889\"]],AUTHOR");
    add_srs_wkt (p, 18,
        "ITY[\"EPSG\",\"7955\"]]");
    p = add_epsg_def_ex (filter, first, last, 7956, "epsg", 7956,
        "SHMG2015", 0, 0,
        "GRS 1980", "Greenwich",
        "St_Helena_Geodetic_Datum_2015", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"SHMG2015 +  SHVD2015 height\",PROJCS[\"SHMG20");
    add_srs_wkt (p, 1,
        "15\",GEOGCS[\"SHGD2015\",DATUM[\"St_Helena_Geodetic_Datu");
    add_srs_wkt (p, 2,
        "m_2015\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1174\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"7886\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-3],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 9,
        "\",0.9996],PARAMETER[\"false_easting\",500000],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"7887\"]],VERT_CS[\"SHV");
    add_srs_wkt (p, 13,
        "D2015 height\",VERT_DATUM[\"St. Helena Vertical Datum 20");
    add_srs_wkt (p, 14,
        "15\",2005,AUTHORITY[\"EPSG\",\"1177\"]],UNIT[\"metre\",1");
    add_srs_wkt (p, 15,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Gravity-related he");
    add_srs_wkt (p, 16,
        "ight\",UP],AUTHORITY[\"EPSG\",\"7890\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 17,
        "G\",\"7956\"]]");
    p = add_epsg_def_ex (filter, first, last, 7991, "epsg", 7991,
        "NAD27 / MTM zone 10", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 10\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.978698213898,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "79.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",304800],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "7991\"]]");
    p = add_epsg_def_ex (filter, first, last, 7992, "epsg", 7992,
        "Malongo 1987 / UTM zone 33S", 0, 0,
        "International 1924", "Greenwich",
        "Malongo_1987", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +south +ellps=intl +towgs84=-254.1,-5");
    add_proj4text (p, 1,
        ".36,-100.29,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Malongo 1987 / UTM zone 33S\",GEOGCS[\"Malongo ");
    add_srs_wkt (p, 1,
        "1987\",DATUM[\"Malongo_1987\",SPHEROID[\"International 1");
    add_srs_wkt (p, 2,
        "924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6259\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4259\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",15],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"799");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 8013, "epsg", 8013,
        "GDA2020 / ALB2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117.883333333333 +k=1.000004");
    add_proj4text (p, 1,
        "4 +x_0=50000 +y_0=4100000 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / ALB2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "17.883333333333],PARAMETER[\"scale_factor\",1.0000044],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",50000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",4100000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"8013\"]]");
    p = add_epsg_def_ex (filter, first, last, 8014, "epsg", 8014,
        "GDA2020 / BIO2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=115.25 +k=1.0000022 +x_0=600");
    add_proj4text (p, 1,
        "00 +y_0=2700000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / BIO2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "15.25],PARAMETER[\"scale_factor\",1.0000022],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",60000],PARAMETER[\"false_northing\",2700");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"8014\"]]");
    p = add_epsg_def_ex (filter, first, last, 8015, "epsg", 8015,
        "GDA2020 / BRO2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=122.333333333333 +k=1.000002");
    add_proj4text (p, 1,
        "98 +x_0=50000 +y_0=2300000 +ellps=GRS80 +towgs84=0,0,0,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / BRO2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "22.333333333333],PARAMETER[\"scale_factor\",1.00000298],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",50000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",2300000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"8015\"]]");
    p = add_epsg_def_ex (filter, first, last, 8016, "epsg", 8016,
        "GDA2020 / BCG2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=115.433333333333 +k=0.999995");
    add_proj4text (p, 1,
        "92 +x_0=50000 +y_0=4000000 +ellps=GRS80 +towgs84=0,0,0,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / BCG2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "15.433333333333],PARAMETER[\"scale_factor\",0.99999592],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",50000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",4000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"8016\"]]");
    p = add_epsg_def_ex (filter, first, last, 8017, "epsg", 8017,
        "GDA2020 / CARN2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=113.666666666667 +k=0.999997");
    add_proj4text (p, 1,
        "96 +x_0=50000 +y_0=3050000 +ellps=GRS80 +towgs84=0,0,0,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / CARN2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "13.666666666667],PARAMETER[\"scale_factor\",0.99999796],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",50000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",3050000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"8017\"]]");
    p = add_epsg_def_ex (filter, first, last, 8018, "epsg", 8018,
        "GDA2020 / CIG2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105.625 +k=1.00002514 +x_0=5");
    add_proj4text (p, 1,
        "0000 +y_0=1400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / CIG2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "05.625],PARAMETER[\"scale_factor\",1.00002514],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",50000],PARAMETER[\"false_northing\",1");
    add_srs_wkt (p, 10,
        "400000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"8018\"]]");
    p = add_epsg_def_ex (filter, first, last, 8019, "epsg", 8019,
        "GDA2020 / CKIG2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96.875 +k=0.99999387 +x_0=50");
    add_proj4text (p, 1,
        "000 +y_0=1600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / CKIG2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 8,
        "6.875],PARAMETER[\"scale_factor\",0.99999387],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",50000],PARAMETER[\"false_northing\",16");
    add_srs_wkt (p, 10,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"8019\"]]");
    p = add_epsg_def_ex (filter, first, last, 8020, "epsg", 8020,
        "GDA2020 / COL2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=115.933333333333 +k=1.000019");
    add_proj4text (p, 1,
        " +x_0=40000 +y_0=4100000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / COL2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "15.933333333333],PARAMETER[\"scale_factor\",1.000019],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",40000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",4100000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"8020\"]]");
    p = add_epsg_def_ex (filter, first, last, 8021, "epsg", 8021,
        "GDA2020 / ESP2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=121.883333333333 +k=1.000005");
    add_proj4text (p, 1,
        "5 +x_0=50000 +y_0=4050000 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / ESP2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "21.883333333333],PARAMETER[\"scale_factor\",1.0000055],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",50000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",4050000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"8021\"]]");
    p = add_epsg_def_ex (filter, first, last, 8022, "epsg", 8022,
        "GDA2020 / EXM2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114.066666666667 +k=1.000002");
    add_proj4text (p, 1,
        "36 +x_0=50000 +y_0=2750000 +ellps=GRS80 +towgs84=0,0,0,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / EXM2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "14.066666666667],PARAMETER[\"scale_factor\",1.00000236],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",50000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",2750000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"8022\"]]");
    p = add_epsg_def_ex (filter, first, last, 8023, "epsg", 8023,
        "GDA2020 / GCG2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114.583333333333 +k=1.000006");
    add_proj4text (p, 1,
        "28 +x_0=50000 +y_0=3450000 +ellps=GRS80 +towgs84=0,0,0,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / GCG2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "14.583333333333],PARAMETER[\"scale_factor\",1.00000628],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",50000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",3450000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"8023\"]]");
    p = add_epsg_def_ex (filter, first, last, 8024, "epsg", 8024,
        "GDA2020 / GOLD2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=121.5 +k=1.00004949 +x_0=600");
    add_proj4text (p, 1,
        "00 +y_0=3800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / GOLD2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "21.5],PARAMETER[\"scale_factor\",1.00004949],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",60000],PARAMETER[\"false_northing\",3800");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"8024\"]]");
    p = add_epsg_def_ex (filter, first, last, 8025, "epsg", 8025,
        "GDA2020 / JCG2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114.983333333333 +k=1.000003");
    add_proj4text (p, 1,
        "14 +x_0=50000 +y_0=3650000 +ellps=GRS80 +towgs84=0,0,0,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / JCG2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "14.983333333333],PARAMETER[\"scale_factor\",1.00000314],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",50000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",3650000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"8025\"]]");
    p = add_epsg_def_ex (filter, first, last, 8026, "epsg", 8026,
        "GDA2020 / KALB2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114.315277777778 +k=1.000014");
    add_proj4text (p, 1,
        " +x_0=55000 +y_0=3700000 +ellps=GRS80 +towgs84=0,0,0,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / KALB2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "14.315277777778],PARAMETER[\"scale_factor\",1.000014],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",55000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",3700000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"8026\"]]");
    p = add_epsg_def_ex (filter, first, last, 8027, "epsg", 8027,
        "GDA2020 / KAR2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=116.933333333333 +k=0.999998");
    add_proj4text (p, 1,
        "9 +x_0=50000 +y_0=2550000 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / KAR2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "16.933333333333],PARAMETER[\"scale_factor\",0.9999989],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",50000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",2550000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"8027\"]]");
    p = add_epsg_def_ex (filter, first, last, 8028, "epsg", 8028,
        "GDA2020 / KUN2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=128.75 +k=1.0000165 +x_0=500");
    add_proj4text (p, 1,
        "00 +y_0=2100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / KUN2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "28.75],PARAMETER[\"scale_factor\",1.0000165],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",50000],PARAMETER[\"false_northing\",2100");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"8028\"]]");
    p = add_epsg_def_ex (filter, first, last, 8029, "epsg", 8029,
        "GDA2020 / LCG2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=115.366666666667 +k=1.000001");
    add_proj4text (p, 1,
        "57 +x_0=50000 +y_0=3750000 +ellps=GRS80 +towgs84=0,0,0,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / LCG2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "15.366666666667],PARAMETER[\"scale_factor\",1.00000157],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",50000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",3750000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"8029\"]]");
    p = add_epsg_def_ex (filter, first, last, 8030, "epsg", 8030,
        "GDA2020 / MRCG2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=115.166666666667 +k=1.000005");
    add_proj4text (p, 1,
        "5 +x_0=50000 +y_0=4050000 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / MRCG2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "15.166666666667],PARAMETER[\"scale_factor\",1.0000055],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",50000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",4050000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"8030\"]]");
    p = add_epsg_def_ex (filter, first, last, 8031, "epsg", 8031,
        "GDA2020 / PCG2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=115.816666666667 +k=0.999999");
    add_proj4text (p, 1,
        "06 +x_0=50000 +y_0=3900000 +ellps=GRS80 +towgs84=0,0,0,0");
    add_proj4text (p, 2,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / PCG2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "15.816666666667],PARAMETER[\"scale_factor\",0.99999906],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",50000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",3900000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"8031\"]]");
    p = add_epsg_def_ex (filter, first, last, 8032, "epsg", 8032,
        "GDA2020 / PHG2020", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=118.6 +k=1.00000135 +x_0=500");
    add_proj4text (p, 1,
        "00 +y_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / PHG2020\",GEOGCS[\"GDA2020\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "7844\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 8,
        "18.6],PARAMETER[\"scale_factor\",1.00000135],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",50000],PARAMETER[\"false_northing\",2500");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"8032\"]]");
    p = add_epsg_def_ex (filter, first, last, 8035, "epsg", 8035,
        "WGS 84 / TM Zone 20N (ftUS)", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-63 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "01016 +y_0=0 +datum=WGS84 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TM Zone 20N (ftUS)\",GEOGCS[\"WGS 84\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "23563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"scal");
    add_srs_wkt (p, 8,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",1640416.6");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"false_northing\",0],UNIT[\"US survey foo");
    add_srs_wkt (p, 10,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"8035\"]]");
    p = add_epsg_def_ex (filter, first, last, 8036, "epsg", 8036,
        "WGS 84 / TM Zone 21N (ftUS)", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-57 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "01016 +y_0=0 +datum=WGS84 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TM Zone 21N (ftUS)\",GEOGCS[\"WGS 84\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.2572");
    add_srs_wkt (p, 2,
        "23563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 7,
        ",0],PARAMETER[\"central_meridian\",-57],PARAMETER[\"scal");
    add_srs_wkt (p, 8,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",1640416.6");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"false_northing\",0],UNIT[\"US survey foo");
    add_srs_wkt (p, 10,
        "t\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"8036\"]]");
    p = add_epsg_def_ex (filter, first, last, 8042, "epsg", 8042,
        "Gusterberg (Ferro)", 1, 1,
        "Zach 1812", "Ferro",
        "Gusterberg_Ferro", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6376045 +rf=310 +pm=ferro +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Gusterberg (Ferro)\",DATUM[\"Gusterberg_Ferro\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Zach 1812\",6376045,310,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "1026\"]],AUTHORITY[\"EPSG\",\"1188\"]],PRIMEM[\"Ferro\",");
    add_srs_wkt (p, 3,
        "-17.6666666666667,AUTHORITY[\"EPSG\",\"8909\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"8042\"]]");
    p = add_epsg_def_ex (filter, first, last, 8043, "epsg", 8043,
        "St. Stephen (Ferro)", 1, 1,
        "Zach 1812", "Ferro",
        "St_Stephen_Ferro", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6376045 +rf=310 +pm=ferro +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"St. Stephen (Ferro)\",DATUM[\"St_Stephen_Ferro\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"Zach 1812\",6376045,310,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 2,
        "1026\"]],AUTHORITY[\"EPSG\",\"1189\"]],PRIMEM[\"Ferro\",");
    add_srs_wkt (p, 3,
        "-17.6666666666667,AUTHORITY[\"EPSG\",\"8909\"]],UNIT[\"d");
    add_srs_wkt (p, 4,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 5,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 6,
        "RITY[\"EPSG\",\"8043\"]]");
    p = add_epsg_def_ex (filter, first, last, 8044, "epsg", 8044,
        "Gusterberg Grid (Ferro)", 0, 0,
        "Zach 1812", "Ferro",
        "Gusterberg_Ferro", "Cassini_Soldner", "metre",
        "Southing", "South", "Westing", "West");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=48.0384638888889 +lon_0=31.80418055555");
    add_proj4text (p, 1,
        "56 +x_0=0 +y_0=0 +a=6376045 +rf=310 +pm=ferro +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Gusterberg Grid (Ferro)\",GEOGCS[\"Gusterberg (");
    add_srs_wkt (p, 1,
        "Ferro)\",DATUM[\"Gusterberg_Ferro\",SPHEROID[\"Zach 1812");
    add_srs_wkt (p, 2,
        "\",6376045,310,AUTHORITY[\"EPSG\",\"1026\"]],AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"1188\"]],PRIMEM[\"Ferro\",-17.6666666666667,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8909\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "8042\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",48.0384638888889],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",31.8041805555556],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 10,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Southing\",SOUTH],AXIS");
    add_srs_wkt (p, 11,
        "[\"Westing\",WEST],AUTHORITY[\"EPSG\",\"8044\"]]");
    p = add_epsg_def_ex (filter, first, last, 8045, "epsg", 8045,
        "St. Stephen Grid (Ferro)", 0, 0,
        "Zach 1812", "Ferro",
        "St_Stephen_Ferro", "Cassini_Soldner", "metre",
        "Southing", "South", "Westing", "West");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=48.2087611111111 +lon_0=34.04092222222");
    add_proj4text (p, 1,
        "22 +x_0=0 +y_0=0 +a=6376045 +rf=310 +pm=ferro +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"St. Stephen Grid (Ferro)\",GEOGCS[\"St. Stephen");
    add_srs_wkt (p, 1,
        " (Ferro)\",DATUM[\"St_Stephen_Ferro\",SPHEROID[\"Zach 18");
    add_srs_wkt (p, 2,
        "12\",6376045,310,AUTHORITY[\"EPSG\",\"1026\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"1189\"]],PRIMEM[\"Ferro\",-17.6666666666667,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8909\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8043\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",48.2087611111111],PARAMETER[\"centr");
    add_srs_wkt (p, 8,
        "al_meridian\",34.0409222222222],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 9,
        "g\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Southing\",SOUTH],A");
    add_srs_wkt (p, 11,
        "XIS[\"Westing\",WEST],AUTHORITY[\"EPSG\",\"8045\"]]");
    p = add_epsg_def_ex (filter, first, last, 8058, "epsg", 8058,
        "GDA2020 / NSW Lambert", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=-33.25 +lon_0=147 +lat_1=-30.75 +lat_2=");
    add_proj4text (p, 1,
        "-35.75 +x_0=9300000 +y_0=4500000 +ellps=GRS80 +towgs84=0");
    add_proj4text (p, 2,
        ",0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / NSW Lambert\",GEOGCS[\"GDA2020\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7844\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",-33.25],PARAMETER[\"cen");
    add_srs_wkt (p, 8,
        "tral_meridian\",147],PARAMETER[\"standard_parallel_1\",-");
    add_srs_wkt (p, 9,
        "30.75],PARAMETER[\"standard_parallel_2\",-35.75],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",9300000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",4500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"8058\"]]");
    p = add_epsg_def_ex (filter, first, last, 8059, "epsg", 8059,
        "GDA2020 / SA Lambert", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_2020", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=-32 +lon_0=135 +lat_1=-28 +lat_2=-36 +x");
    add_proj4text (p, 1,
        "_0=1000000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA2020 / SA Lambert\",GEOGCS[\"GDA2020\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Geocentric_Datum_of_Australia_2020\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 2,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"1168\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"7844\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",-32],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",135],PARAMETER[\"standard_parallel_1\",-28]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"standard_parallel_2\",-36],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",1000000],PARAMETER[\"false_northing\",200000");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"8059\"]]");
    p = add_epsg_def_ex (filter, first, last, 8065, "epsg", 8065,
        "NAD83(2011) / PCCS zone 1 (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Hotine_Oblique_Mercator_Azimuth_Center", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=32.25 +lonc=-111.4 +alpha=45 +gamma=4");
    add_proj4text (p, 1,
        "5 +k=1.00011 +x_0=48768 +y_0=243840 +ellps=GRS80 +units=");
    add_proj4text (p, 2,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / PCCS zone 1 (ft)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Hotine_");
    add_srs_wkt (p, 7,
        "Oblique_Mercator_Azimuth_Center\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 8,
        "of_center\",32.25],PARAMETER[\"longitude_of_center\",-11");
    add_srs_wkt (p, 9,
        "1.4],PARAMETER[\"azimuth\",45],PARAMETER[\"rectified_gri");
    add_srs_wkt (p, 10,
        "d_angle\",45],PARAMETER[\"scale_factor\",1.00011],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",160000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 12,
        "\",800000],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "2\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 14,
        "THORITY[\"EPSG\",\"8065\"]]");
    p = add_epsg_def_ex (filter, first, last, 8066, "epsg", 8066,
        "NAD83(2011) / PCCS zone 2 (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31.25 +lon_0=-112.166666666667 +k=1.0");
    add_proj4text (p, 1,
        "0009 +x_0=548640 +y_0=304800 +ellps=GRS80 +units=ft +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / PCCS zone 2 (ft)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",31.25],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-112.166666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1.00009],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",1800000],PARAMETER[\"false_northing\",1000000],UNIT[\"f");
    add_srs_wkt (p, 11,
        "oot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 12,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "8066\"]]");
    p = add_epsg_def_ex (filter, first, last, 8067, "epsg", 8067,
        "NAD83(2011) / PCCS zone 3 (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31.5 +lon_0=-113.166666666667 +k=1.00");
    add_proj4text (p, 1,
        "0055 +x_0=182880 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / PCCS zone 3 (ft)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",31.5],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-113.166666666667],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1.000055],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",600000],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0");
    add_srs_wkt (p, 11,
        ".3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8067\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 8068, "epsg", 8068,
        "NAD83(2011) / PCCS zone 4 (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.5 +lat_0=30.5 +lon_0=-110.75 +k_0=0.");
    add_proj4text (p, 1,
        "9998 +x_0=9144 +y_0=-188976 +ellps=GRS80 +units=ft +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / PCCS zone 4 (ft)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",30.5],PARAMETER[\"central_meridian\",-110.75],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9998],PARAMETER[\"false_easting\",30");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",-620000],UNIT[\"foot\"");
    add_srs_wkt (p, 11,
        ",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8068\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 8082, "epsg", 8082,
        "NAD83(CSRS)v6 / MTM Nova Scotia zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS_version_6", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=2450000");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS)v6 / MTM Nova Scotia zone 4\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(CSRS)v6\",DATUM[\"North_American_Datum_of_1983_");
    add_srs_wkt (p, 2,
        "CSRS_version_6\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1197\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"8252\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-61.5],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.9999],PARAMETER[\"false_easting\",2450000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"8082\"]]");
    p = add_epsg_def_ex (filter, first, last, 8083, "epsg", 8083,
        "NAD83(CSRS)v6 / MTM Nova Scotia zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS_version_6", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=2550000");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS)v6 / MTM Nova Scotia zone 5\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(CSRS)v6\",DATUM[\"North_American_Datum_of_1983_");
    add_srs_wkt (p, 2,
        "CSRS_version_6\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1197\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"8252\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",-64.5],PARAMETER[\"sc");
    add_srs_wkt (p, 9,
        "ale_factor\",0.9999],PARAMETER[\"false_easting\",2550000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"8083\"]]");
    p = add_epsg_def_ex (filter, first, last, 8085, "epsg", 8085,
        "ISN2016", 1, 1,
        "GRS 1980", "Greenwich",
        "Islands_Net_2016", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"ISN2016\",DATUM[\"Islands Net 2016\",ELLIPSOID");
    add_srs_wkt (p, 1,
        "[\"GRS 1980\",6378137,298.257222101,LENGTHUNIT[\"metre\"");
    add_srs_wkt (p, 2,
        ",1]]],PRIMEM[\"Greenwich\",0,ANGLEUNIT[\"degree\",0.0174");
    add_srs_wkt (p, 3,
        "532925199433]],CS[ellipsoidal,3],AXIS[\"geodetic latitud");
    add_srs_wkt (p, 4,
        "e (Lat)\",north,ORDER[1],ANGLEUNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433]],AXIS[\"geodetic longitude (Lon)\",east,ORDER[");
    add_srs_wkt (p, 6,
        "2],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"elli");
    add_srs_wkt (p, 7,
        "psoidal height (h)\",up,ORDER[3],LENGTHUNIT[\"metre\",1]");
    add_srs_wkt (p, 8,
        "],USAGE[SCOPE[\"Geodesy.\"],AREA[\"Iceland - onshore and");
    add_srs_wkt (p, 9,
        " offshore.\"],BBOX[59.96,-30.87,69.59,-5.55]],ID[\"EPSG\"");
    add_srs_wkt (p, 10,
        ",8085]]");
    p = add_epsg_def_ex (filter, first, last, 8086, "epsg", 8086,
        "ISN2016", 1, 1,
        "GRS 1980", "Greenwich",
        "Islands_Net_2016", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ISN2016\",DATUM[\"Islands_Net_2016\",SPHEROID[\"");
    add_srs_wkt (p, 1,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 2,
        "19\"]],AUTHORITY[\"EPSG\",\"1187\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 3,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 4,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 5,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "8086\"]]");
    p = add_epsg_def_ex (filter, first, last, 8088, "epsg", 8088,
        "ISN2016 / Lambert 2016", 0, 0,
        "GRS 1980", "Greenwich",
        "Islands_Net_2016", "Lambert_Conformal_Conic_2SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_0=65 +lon_0=-19 +lat_1=64.25 +lat_2=65.75");
    add_proj4text (p, 1,
        " +x_0=2700000 +y_0=300000 +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ISN2016 / Lambert 2016\",GEOGCS[\"ISN2016\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Islands_Net_2016\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"1187\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"8086\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",65],PARAMETER[\"central_meridian\",-19],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",64.25],PARAMETER[\"sta");
    add_srs_wkt (p, 9,
        "ndard_parallel_2\",65.75],PARAMETER[\"false_easting\",27");
    add_srs_wkt (p, 10,
        "00000],PARAMETER[\"false_northing\",300000],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8088\"]]");
    p = add_epsg_def_ex (filter, first, last, 8090, "epsg", 8090,
        "NAD83(HARN) / WISCRS Florence (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.4388888888889 +lon_0=-88.141666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000552095 +x_0=133502.6683 +y_0=0.0063 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Florence (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",45.43888888");
    add_srs_wkt (p, 8,
        "88889],PARAMETER[\"central_meridian\",-88.1416666666667]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1.0000552095],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",133502.6683],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0.0063],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"8090\"]]");
    p = add_epsg_def_ex (filter, first, last, 8091, "epsg", 8091,
        "NAD83(HARN) / WISCRS Florence (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.4388888888889 +lon_0=-88.141666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000552095 +x_0=133502.668224536 +y_0=0.006400");
    add_proj4text (p, 2,
        "8128016256 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Florence (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",45.4388888");
    add_srs_wkt (p, 8,
        "888889],PARAMETER[\"central_meridian\",-88.1416666666667");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.0000552095],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",438000.004],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0.021],UNIT[\"US survey foot\",0.304800609601219,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"8091\"]]");
    p = add_epsg_def_ex (filter, first, last, 8092, "epsg", 8092,
        "NAD83(HARN) / WISCRS Eau Claire (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.8722811263889 +lat_0=44.872281126388");
    add_proj4text (p, 1,
        "9 +lon_0=-91.2888888888889 +k_0=1.000035079 +x_0=120091.");
    add_proj4text (p, 2,
        "4402 +y_0=91687.9239 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Eau Claire (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 8,
        ".8722811263889],PARAMETER[\"central_meridian\",-91.28888");
    add_srs_wkt (p, 9,
        "88888889],PARAMETER[\"scale_factor\",1.000035079],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",120091.4402],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",91687.9239],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"8092\"]]");
    p = add_epsg_def_ex (filter, first, last, 8093, "epsg", 8093,
        "NAD83(HARN) / WISCRS Eau Claire (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.8722811263889 +lat_0=44.872281126388");
    add_proj4text (p, 1,
        "9 +lon_0=-91.2888888888889 +k_0=1.000035079 +x_0=120091.");
    add_proj4text (p, 2,
        "44018288 +y_0=91687.9239014478 +ellps=GRS80 +units=us-ft");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Eau Claire (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_N");
    add_srs_wkt (p, 2,
        "etwork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 7,
        "t_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",44.8722811263889],PARAMETER[\"central_meridian\",-91.28");
    add_srs_wkt (p, 9,
        "88888888889],PARAMETER[\"scale_factor\",1.000035079],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",394000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",300812.797],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 12,
        "219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8093\"]]");
    p = add_epsg_def_ex (filter, first, last, 8095, "epsg", 8095,
        "NAD83(HARN) / WISCRS Wood (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.3625954694444 +lat_0=44.362595469444");
    add_proj4text (p, 1,
        "4 +lon_0=-90 +k_0=1.0000421209 +x_0=208483.6173 +y_0=134");
    add_proj4text (p, 2,
        "589.754 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Wood (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44.36259");
    add_srs_wkt (p, 8,
        "54694444],PARAMETER[\"central_meridian\",-90],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.0000421209],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",208483.6173],PARAMETER[\"false_northing\",134589.754]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"8095\"]]");
    p = add_epsg_def_ex (filter, first, last, 8096, "epsg", 8096,
        "NAD83(HARN) / WISCRS Wood (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.3625954694444 +lat_0=44.362595469444");
    add_proj4text (p, 1,
        "4 +lon_0=-90 +k_0=1.0000421209 +x_0=208483.617272035 +y_");
    add_proj4text (p, 2,
        "0=134589.753924308 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Wood (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44.3");
    add_srs_wkt (p, 8,
        "625954694444],PARAMETER[\"central_meridian\",-90],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1.0000421209],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",684000.001],PARAMETER[\"false_northing\",441566.5");
    add_srs_wkt (p, 11,
        "51],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"8096\"]]");
    p = add_epsg_def_ex (filter, first, last, 8097, "epsg", 8097,
        "NAD83(HARN) / WISCRS Waushara (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.1139440458333 +lat_0=44.113944045833");
    add_proj4text (p, 1,
        "3 +lon_0=-89.2416666666667 +k_0=1.0000392096 +x_0=120091");
    add_proj4text (p, 2,
        ".4402 +y_0=45069.7587 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Waushara (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44.");
    add_srs_wkt (p, 8,
        "1139440458333],PARAMETER[\"central_meridian\",-89.241666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"scale_factor\",1.0000392096],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",120091.4402],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",45069.7587],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"8097\"]]");
    p = add_epsg_def_ex (filter, first, last, 8098, "epsg", 8098,
        "NAD83(HARN) / WISCRS Waushara (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.1139440458333 +lat_0=44.113944045833");
    add_proj4text (p, 1,
        "3 +lon_0=-89.2416666666667 +k_0=1.0000392096 +x_0=120091");
    add_proj4text (p, 2,
        ".44018288 +y_0=45069.7588011176 +ellps=GRS80 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Waushara (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 8,
        ".1139440458333],PARAMETER[\"central_meridian\",-89.24166");
    add_srs_wkt (p, 9,
        "66666667],PARAMETER[\"scale_factor\",1.0000392096],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",394000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",147866.367],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 12,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8098\"]]");
    p = add_epsg_def_ex (filter, first, last, 8099, "epsg", 8099,
        "NAD83(HARN) / WISCRS Waupaca (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.4202777777778 +lon_0=-88.816666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000333645 +x_0=185013.9709 +y_0=0.007 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Waupaca (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",43.420277777");
    add_srs_wkt (p, 8,
        "7778],PARAMETER[\"central_meridian\",-88.8166666666667],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.0000333645],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",185013.9709],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        ".007],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"8099\"]]");
    p = add_epsg_def_ex (filter, first, last, 8100, "epsg", 8100,
        "NAD83(HARN) / WISCRS Waupaca (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.4202777777778 +lon_0=-88.816666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000333645 +x_0=185013.970942342 +y_0=0.007010");
    add_proj4text (p, 2,
        "41402082804 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Waupaca (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",43.4202777");
    add_srs_wkt (p, 8,
        "777778],PARAMETER[\"central_meridian\",-88.8166666666667");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.0000333645],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",607000.003],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0.023],UNIT[\"US survey foot\",0.304800609601219,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"8100\"]]");
    p = add_epsg_def_ex (filter, first, last, 8101, "epsg", 8101,
        "NAD83(HARN) / WISCRS Waukesha (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5694444444444 +lon_0=-88.225 +k=1.");
    add_proj4text (p, 1,
        "0000346179 +x_0=208788.418 +y_0=0.0034 +ellps=GRS80 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Waukesha (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",42.56944444");
    add_srs_wkt (p, 8,
        "44444],PARAMETER[\"central_meridian\",-88.225],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",1.0000346179],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",208788.418],PARAMETER[\"false_northing\",0.0034],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "8101\"]]");
    p = add_epsg_def_ex (filter, first, last, 8102, "epsg", 8102,
        "NAD83(HARN) / WISCRS Waukesha (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5694444444444 +lon_0=-88.225 +k=1.");
    add_proj4text (p, 1,
        "0000346179 +x_0=208788.417881636 +y_0=0.0033528067056134");
    add_proj4text (p, 2,
        "1 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Waukesha (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",42.5694444");
    add_srs_wkt (p, 8,
        "444444],PARAMETER[\"central_meridian\",-88.225],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1.0000346179],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",685000.001],PARAMETER[\"false_northing\",0.011],UNI");
    add_srs_wkt (p, 11,
        "T[\"US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"8102\"]]");
    p = add_epsg_def_ex (filter, first, last, 8103, "epsg", 8103,
        "NAD83(HARN) / WISCRS Washington (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.9180555555556 +lon_0=-88.063888888");
    add_proj4text (p, 1,
        "8889 +k=1.00003738 +x_0=120091.4415 +y_0=0.003 +ellps=GR");
    add_proj4text (p, 2,
        "S80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Washington (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",42.9180555");
    add_srs_wkt (p, 8,
        "555556],PARAMETER[\"central_meridian\",-88.0638888888889");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.00003738],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",120091.4415],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        ".003],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"8103\"]]");
    p = add_epsg_def_ex (filter, first, last, 8104, "epsg", 8104,
        "NAD83(HARN) / WISCRS Washington (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.9180555555556 +lon_0=-88.063888888");
    add_proj4text (p, 1,
        "8889 +k=1.00003738 +x_0=120091.441402083 +y_0=0.00304800");
    add_proj4text (p, 2,
        "609601219 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Washington (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_N");
    add_srs_wkt (p, 2,
        "etwork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 7,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",42.918");
    add_srs_wkt (p, 8,
        "0555555556],PARAMETER[\"central_meridian\",-88.063888888");
    add_srs_wkt (p, 9,
        "8889],PARAMETER[\"scale_factor\",1.00003738],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",394000.004],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0.01],UNIT[\"US survey foot\",0.304800609601219,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"8104\"]]");
    p = add_epsg_def_ex (filter, first, last, 8105, "epsg", 8105,
        "NAD83(HARN) / WISCRS Washburn (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.9612198333333 +lat_0=45.961219833333");
    add_proj4text (p, 1,
        "3 +lon_0=-91.7833333333333 +k_0=1.0000475376 +x_0=234086");
    add_proj4text (p, 2,
        ".8682 +y_0=188358.6058 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Washburn (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45.");
    add_srs_wkt (p, 8,
        "9612198333333],PARAMETER[\"central_meridian\",-91.783333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"scale_factor\",1.0000475376],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",234086.8682],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",188358.6058],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"8105\"]]");
    p = add_epsg_def_ex (filter, first, last, 8106, "epsg", 8106,
        "NAD83(HARN) / WISCRS Washburn (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.9612198333333 +lat_0=45.961219833333");
    add_proj4text (p, 1,
        "3 +lon_0=-91.7833333333333 +k_0=1.0000475376 +x_0=234086");
    add_proj4text (p, 2,
        ".868173736 +y_0=188358.605943612 +ellps=GRS80 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Washburn (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45");
    add_srs_wkt (p, 8,
        ".9612198333333],PARAMETER[\"central_meridian\",-91.78333");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"scale_factor\",1.0000475376],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",768000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",617973.193],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 12,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8106\"]]");
    p = add_epsg_def_ex (filter, first, last, 8107, "epsg", 8107,
        "NAD83(HARN) / WISCRS Walworth (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.6694620969444 +lat_0=42.669462096944");
    add_proj4text (p, 1,
        "4 +lon_0=-88.5416666666667 +k_0=1.0000367192 +x_0=232562");
    add_proj4text (p, 2,
        ".8651 +y_0=111088.2224 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Walworth (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",42.");
    add_srs_wkt (p, 8,
        "6694620969444],PARAMETER[\"central_meridian\",-88.541666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"scale_factor\",1.0000367192],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",232562.8651],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",111088.2224],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"8107\"]]");
    p = add_epsg_def_ex (filter, first, last, 8108, "epsg", 8108,
        "NAD83(HARN) / WISCRS Walworth (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.6694620969444 +lat_0=42.669462096944");
    add_proj4text (p, 1,
        "4 +lon_0=-88.5416666666667 +k_0=1.0000367192 +x_0=232562");
    add_proj4text (p, 2,
        ".86512573 +y_0=111088.222402845 +ellps=GRS80 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Walworth (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",42");
    add_srs_wkt (p, 8,
        ".6694620969444],PARAMETER[\"central_meridian\",-88.54166");
    add_srs_wkt (p, 9,
        "66666667],PARAMETER[\"scale_factor\",1.0000367192],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",763000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",364461.943],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 12,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8108\"]]");
    p = add_epsg_def_ex (filter, first, last, 8109, "epsg", 8109,
        "NAD83(HARN) / WISCRS Vilas (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.0778440905556 +lat_0=46.077844090555");
    add_proj4text (p, 1,
        "6 +lon_0=-89.4888888888889 +k_0=1.0000730142 +x_0=134417");
    add_proj4text (p, 2,
        ".0689 +y_0=50337.1092 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Vilas (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",46.07784");
    add_srs_wkt (p, 8,
        "40905556],PARAMETER[\"central_meridian\",-89.48888888888");
    add_srs_wkt (p, 9,
        "89],PARAMETER[\"scale_factor\",1.0000730142],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",134417.0689],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",50337.1092],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"8109\"]]");
    p = add_epsg_def_ex (filter, first, last, 8110, "epsg", 8110,
        "NAD83(HARN) / WISCRS Vilas (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.0778440905556 +lat_0=46.077844090555");
    add_proj4text (p, 1,
        "6 +lon_0=-89.4888888888889 +k_0=1.0000730142 +x_0=134417");
    add_proj4text (p, 2,
        ".068834138 +y_0=50337.1092710185 +ellps=GRS80 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Vilas (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",46.");
    add_srs_wkt (p, 8,
        "0778440905556],PARAMETER[\"central_meridian\",-89.488888");
    add_srs_wkt (p, 9,
        "8888889],PARAMETER[\"scale_factor\",1.0000730142],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",441000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",165147.666],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8110\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

