#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/parser.h>

#include "specimen.h"
#include "patch.h"

int beef_write(char *name)
{
     char tmp[256];
     int val;
     int *id;
     int i, count;
     xmlDocPtr doc;
     xmlNodePtr rootnode;
     xmlNodePtr xmlpatch;

     debug("Writing current bank to file %s\n", name);

     /* create the guts of the doc */
     doc = xmlNewDoc("1.0");
     rootnode = xmlNewDocNode(doc, NULL, (const xmlChar *)"beef", NULL);
     xmlDocSetRootElement(doc, rootnode);

     /* walk the walk */
     count = patch_dump(&id);
     for (i = 0; i < count; i++) {
	  xmlpatch = xmlNewTextChild(rootnode, NULL, (const xmlChar *)"patch", NULL);
	  
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"name", (const xmlChar *)patch_name_get(id[i]));

	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"file",
			       (const xmlChar *)patch_sample_name_get(id[i]));
	  
	  sprintf(tmp, "%d", patch_channel_get(id[i]));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"channel", (const xmlChar *)tmp);

	  sprintf(tmp, "%d", patch_note_get(id[i]));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"note", (const xmlChar *)tmp);
	  
	  sprintf(tmp, "%f", patch_volume_get(id[i]));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"volume", (const xmlChar *)tmp);
	  
	  sprintf(tmp, "%f", patch_pan_get(id[i]));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"pan", (const xmlChar *)tmp);

	  sprintf(tmp, "%d", patch_play_mode_get(id[i]));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"play_mode", (const xmlChar *)tmp);

	  sprintf(tmp, "%d", patch_cut_get(id[i]));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"cut", (const xmlChar *)tmp);

	  sprintf(tmp, "%d", patch_cut_by_get(id[i]));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"cut_by", (const xmlChar *)tmp);

	  sprintf(tmp, "%d", patch_range_get(id[i]));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"range", (const xmlChar *)tmp);

	  sprintf(tmp, "%d", patch_lower_note_get(id[i]));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"lower_note", (const xmlChar *)tmp);

	  sprintf(tmp, "%d", patch_upper_note_get(id[i]));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"upper_note", (const xmlChar *)tmp);

	  sprintf(tmp, "%d", patch_sample_start_get(id[i]));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"sample_start", (const xmlChar *)tmp);

	  sprintf(tmp, "%d", patch_sample_stop_get(id[i]));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"sample_stop", (const xmlChar *)tmp);

	  sprintf(tmp, "%d", patch_loop_start_get(id[i]));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"loop_start", (const xmlChar *)tmp);

	  sprintf(tmp, "%d", patch_loop_stop_get(id[i]));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"loop_stop", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_cutoff_get(id[i]));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"cutoff", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_resonance_get(id[i]));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"resonance", (const xmlChar *)tmp);

	  sprintf(tmp, "%d", patch_envelope_get(id[i], ADSR_VOLUME));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"volume_on", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_attack_get(id[i], ADSR_VOLUME));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"volume_a", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_decay_get(id[i], ADSR_VOLUME));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"volume_d", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_sustain_get(id[i], ADSR_VOLUME));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"volume_s", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_release_get(id[i], ADSR_VOLUME));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"volume_r", (const xmlChar *)tmp);

	  sprintf(tmp, "%d", patch_envelope_get(id[i], ADSR_CUTOFF));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"cutoff_on", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_attack_get(id[i], ADSR_CUTOFF));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"cutoff_a", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_decay_get(id[i], ADSR_CUTOFF));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"cutoff_d", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_sustain_get(id[i], ADSR_CUTOFF));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"cutoff_s", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_release_get(id[i], ADSR_CUTOFF));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"cutoff_r", (const xmlChar *)tmp);

	  sprintf(tmp, "%d", patch_envelope_get(id[i], ADSR_RESONANCE));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"resonance_on", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_attack_get(id[i], ADSR_RESONANCE));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"resonance_a", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_decay_get(id[i], ADSR_RESONANCE));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"resonance_d", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_sustain_get(id[i], ADSR_RESONANCE));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"resonance_s", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_release_get(id[i], ADSR_RESONANCE));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"resonance_r", (const xmlChar *)tmp);

	  sprintf(tmp, "%d", patch_envelope_get(id[i], ADSR_PANNING));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"panning_on", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_attack_get(id[i], ADSR_PANNING));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"panning_a", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_decay_get(id[i], ADSR_PANNING));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"panning_d", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_sustain_get(id[i], ADSR_PANNING));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"panning_s", (const xmlChar *)tmp);

	  sprintf(tmp, "%f", patch_release_get(id[i], ADSR_PANNING));
	  xmlNewTextChild(xmlpatch, NULL, (const xmlChar *)"panning_r", (const xmlChar *)tmp);
     }
     
     /* write the file to disk */
     val = xmlSaveFormatFile(name, doc, 1);
     xmlFreeDoc(doc);

     return (val)? val: 0;
}

int beef_read(char *path)
{
     xmlDocPtr doc;
     xmlNodePtr rootnode;
     xmlNodePtr xmlpatch;
     xmlNodePtr cur;
     xmlChar *key;
     int id;

     debug("Loading bank from file %s\n", path);

     doc = xmlParseFile(path);
     if (doc == NULL) {
	  errmsg("Failed to parse %s\n", path);
	  return -1;
     }

     rootnode = xmlDocGetRootElement(doc);
     if (rootnode == NULL) {
	  errmsg("%s is empty\n", path);
	  xmlFreeDoc(doc);
	  return -1;
     }

     if (xmlStrcmp(rootnode->name, (const xmlChar *)"beef") != 0) {
	  errmsg("%s is not a valid 'beef' file\n", path);
	  xmlFreeDoc(doc);
	  return -1;
     }


     patch_destroy_all();
     for (xmlpatch = rootnode->xmlChildrenNode; xmlpatch != NULL;
	  xmlpatch = xmlpatch->next) {

	  key = NULL;
	  if (!xmlStrcmp(xmlpatch->name, (const xmlChar *)"patch")) {
	       id = patch_create("Loading...");

	       for (cur = xmlpatch->xmlChildrenNode; cur != NULL; cur = cur->next) {
		    if (!xmlStrcmp(cur->name, (const xmlChar *)"name")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_name_set(id, (char *)key);
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"file")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_sample_load(id, (char *)key);
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"channel")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_channel_set(id, atoi((const char *)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"note")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_note_set(id, atoi((const char *)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"volume")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_volume_set(id, atof((const char *)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"pan")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_pan_set(id, atof((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"play_mode")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_play_mode_set(id, atoi((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"cut")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_cut_set(id, atoi((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"cut_by")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_cut_by_set(id, atoi((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"range")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_range_set(id, atoi((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"lower_note")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_lower_note_set(id, atoi((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"upper_note")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_upper_note_set(id, atoi((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"sample_start")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_sample_start_set(id, atoi((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"sample_stop")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_sample_stop_set(id, atoi((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"loop_start")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_loop_start_set(id, atoi((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"loop_stop")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_loop_stop_set(id, atoi((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"cutoff")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_cutoff_set(id, atof((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"resonance")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_resonance_set(id, atof((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"volume_on")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_envelope_set(id, ADSR_VOLUME, atoi((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"volume_a")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_attack_set(id, ADSR_VOLUME, atof((const char*)key));

		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"volume_d")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_decay_set(id, ADSR_VOLUME, atof((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"volume_s")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_sustain_set(id, ADSR_VOLUME, atof((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"volume_r")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_release_set(id, ADSR_VOLUME, atof((const char*)key));

		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"cutoff_on")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_envelope_set(id, ADSR_CUTOFF, atoi((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"cutoff_a")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_attack_set(id, ADSR_CUTOFF, atof((const char*)key));

		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"cutoff_d")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_decay_set(id, ADSR_CUTOFF, atof((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"cutoff_s")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_sustain_set(id, ADSR_CUTOFF, atof((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"cutoff_r")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_release_set(id, ADSR_CUTOFF, atof((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"resonance_on")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_envelope_set(id, ADSR_RESONANCE, atoi((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"resonance_a")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_attack_set(id, ADSR_RESONANCE, atof((const char*)key));

		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"resonance_d")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_decay_set(id, ADSR_RESONANCE, atof((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"resonance_s")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_sustain_set(id, ADSR_RESONANCE, atof((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"resonance_r")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_release_set(id, ADSR_RESONANCE, atof((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"panning_on")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_envelope_set(id, ADSR_PANNING, atoi((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"panning_a")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_attack_set(id, ADSR_PANNING, atof((const char*)key));

		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"panning_d")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_decay_set(id, ADSR_PANNING, atof((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"panning_s")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_sustain_set(id, ADSR_PANNING, atof((const char*)key));
		    
		    } else if (!xmlStrcmp(cur->name, (const xmlChar *)"panning_r")) {
			 key = xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);
			 patch_release_set(id, ADSR_PANNING, atof((const char*)key));
		    }
		    if (key != NULL) {
			 xmlFree(key);
			 key = NULL;
		    }
	       }
	  }
     }

     xmlFreeDoc(doc);
     return 0;
}

