#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>
#include <sys/time.h>
#include <gtk/gtk.h>

#include "specimen.h"
#include "gui/gui.h"
#include "midi.h"
#include "patch.h"
#include "driver.h"

/* gets the current tick (sample count).  N.B., we divide tv_usec by
   1,000,000 to convert to full seconds */
tick_t getticks()
{
     struct timeval time;
     tick_t val;
     static tick_t offset = -1;

     if (offset == -1) {
	  if (gettimeofday(&time, NULL) < 0) {
	       offset = 0;
	  } else {
	       offset = (time.tv_sec + time.tv_usec / 1000000.0);
	  }
     }

     if (gettimeofday(&time, NULL) < 0) {
	  errmsg("Failed to get time\n");
	  return 0;
     }

     val = (time.tv_sec + time.tv_usec / 1000000.0 - offset) * DRIVER->getrate() + DRIVER->getperiodsize();
     return val;
}

/* convert seconds to ticks */
tick_t sec2tick(float secs)
{
     return DRIVER->getrate() * secs;
}

/* convert ticks to seconds */
float tick2sec(tick_t tick)
{
     return tick * 1.0 / DRIVER->getrate();
}

/* get the file name, stripping path */
char *basename(char *name)
{
     char *p, *lp;
     
     for (lp = p = name; *p != '\0'; p++)
	  if (*p == '/')
	       lp = p;
     
     if (*lp == '/') /* not good if last character is '/' */
	  lp++;
     return lp;
}

int main(int argc, char *argv[])
{
     pthread_t midi_thread;
     pthread_mutex_t thread_data_mutex = PTHREAD_MUTEX_INITIALIZER;
     thread_data_t thread_data = {&thread_data_mutex, 0};

     gtk_init(&argc, &argv);

     /* initialize driver */
     prepare_drivers();

     /* initialize gui, which initializes audiosettings */
     init_gui(&thread_data);

     /* initialize midi */
     pthread_create(&midi_thread, NULL, (void *)init_midi, (void *)&thread_data);

     /* start default driver */
     DRIVER->start();

     gtk_main();

     pthread_join(midi_thread, NULL);
     DRIVER->stop();
     debug("Goodbye.\n");
     return 0;
}
