#ifndef SPECIMEN_H
#define SPECIMEN_H

#include <config.h>
#include <stdio.h>
#include <stdint.h>
#include <pthread.h>
#include <jack/types.h>

#ifndef DEBUG
#define DEBUG 0
#endif

#define FUBAR -69
#define SPACING 5

#ifndef PIXMAPSDIR
# define "./"
#endif

#define errmsg(...) fprintf(stderr, __VA_ARGS__)
#define debug(...) if (DEBUG) fprintf(stderr, __VA_ARGS__)

typedef struct thread_data_s {
     pthread_mutex_t *mutex;
     int quit;
} thread_data_t;

/* frame count type */
typedef uint64_t tick_t;

/* functions */
tick_t getticks();
tick_t sec2tick(float secs);
float tick2sec(tick_t tick);
char *basename(char *name);

#endif
