Name: specter
Summary: Userspace logging facility for Linux.
Version: 1.4
Release: 1
Source: http://joker.linuxstuff.pl/specter/specter-%{version}.tar.gz
URL: http://joker.linuxstuff.pl/specter/
Packager: Michal Kwiatkowski <ruby@joker.linuxstuff.pl>
Group: System Environment/Daemons
BuildRoot: %{_tmppath}/%{name}-%{version}-buildroot
Copyright: GPL
Requires: iptables

%description
specter is a userspace logging facility for Linux. It uses netfilter
ULOG target for packets gathering, and then passes them to attached
plugins. Modularized structure makes specter very flexible and robust.
It's based on ulogd, but has improved design and wider functionality.

Install it if you want to easily gather and manage your net traffic logs
among different formats (plain text, MySQL/PostgreSQL databases, etc..).

%prep
%setup

%build
%configure --prefix=/usr --with-mysql --with-pgsql
make TARGET_ARCH='-mcpu=i486'

%install
rm -rf %{buildroot}
mkdir -p %{buildroot}/%{_sysconfdir}
mkdir -p %{buildroot}/%{_libdir}/specter
mkdir -p %{buildroot}/%{_sbindir}/sbin
mkdir -p %{buildroot}/%{_mandir}/man5
mkdir -p %{buildroot}/%{_mandir}/man8
make install DESTDIR=%{buildroot}
mkdir -p %{buildroot}/%{_sysconfdir}/rc.d/init.d

%clean
rm -rf %{buildroot}

%files
%defattr(0644,root,root,0755)
%doc AUTHORS COPYING README
%doc doc/specter.txt doc/specter.html
%doc doc/mysql.table doc/pgsql.table
%config %{_sysconfdir}/specter.conf
%{_mandir}/man8/specter.8.gz
%{_mandir}/man5/specter.conf.5.gz
%attr(0755,root,root) %{_sbindir}/specter
%dir %{_libdir}/specter
%{_libdir}/specter/specter_BASE.so
%{_libdir}/specter/specter_LOCAL.so
%{_libdir}/specter/specter_HTTP.so
%{_libdir}/specter/specter_PWSNIFF.so
%{_libdir}/specter/specter_EXEC.so
%{_libdir}/specter/specter_LOGEMU.so
%{_libdir}/specter/specter_MYSQL.so
%{_libdir}/specter/specter_OPRINT.so
%{_libdir}/specter/specter_PCAP.so
%{_libdir}/specter/specter_PGSQL.so
%{_libdir}/specter/specter_SYSLOG.so

%changelog
* Mon Jul 26 2004 Michal Kwiatkowski <ruby@joker.linuxstuff.pl>
- Initial rpm package for specter-1.2
