var targetGroup = -1;
var gPref = Components.classes["@mozilla.org/preferences-service;1"]
               .getService(Components.interfaces.nsIPrefService)
               .QueryInterface(Components.interfaces.nsIPrefBranch2);

var addGroupBundle;

function Startup() {
  // Set variables
  targetGroup = window.arguments[0];
  addGroupBundle = document.getElementById("bundle_editGroup");
  
  if (targetGroup < 0) {
    // Adding group, set correct title
    document.title = addGroupBundle.getString("addGroupTitle");
    document.getElementById("backgroundColor").color = "#CCCCCC";
    document.getElementById("textColor").color = "#000000";
    document.getElementById("useCustomColors").checked = false;
  } else {
    // Prefill values
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-title")) {
      document.getElementById("title").value = gPref.getComplexValue("extensions.speeddial.group-" + targetGroup + "-title", Components.interfaces.nsISupportsString).data;
    }
    var useCustomColors = false;
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-backgroundColor")) {
      useCustomColors = true;
      document.getElementById("backgroundColor").color = gPref.getCharPref("extensions.speeddial.group-" + targetGroup + "-backgroundColor");
    } else {
      document.getElementById("backgroundColor").color = "#CCCCCC";
    }
    document.getElementById("backgroundColorText").value = document.getElementById("backgroundColor").color;
    
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-textColor")) {
      useCustomColors = true;
      document.getElementById("textColor").color = gPref.getCharPref("extensions.speeddial.group-" + targetGroup + "-textColor");
    } else {
      document.getElementById("textColor").color = "#000000";
    }
    document.getElementById("textColorText").value = document.getElementById("textColor").color;
    
    document.getElementById("useCustomColors").checked = useCustomColors;
  }

  useCustomColorsChanged();
  
  sizeToContent();
}

function onOK(event) {
  var addingGroup = false;
  
  if (targetGroup < 0) {
    addingGroup = true;
    targetGroup = gPref.getIntPref("extensions.speeddial.numGroups") + 1;
  }
  
  var title = document.getElementById("title").value;
  var useCustomColors = document.getElementById("useCustomColors").checked;
  var textColor = document.getElementById("textColor").color;
  var backgroundColor = document.getElementById("backgroundColor").color;
  
  if (title != "") {
    var str = Components.classes["@mozilla.org/supports-string;1"].createInstance(Components.interfaces.nsISupportsString);
    str.data = title;
    gPref.setComplexValue("extensions.speeddial.group-" + targetGroup + "-title", Components.interfaces.nsISupportsString, str);
  } else if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-title")) {
    gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-title");
  }
  
  if (useCustomColors) {
    gPref.setCharPref("extensions.speeddial.group-" + targetGroup + "-textColor", textColor);
    gPref.setCharPref("extensions.speeddial.group-" + targetGroup + "-backgroundColor", backgroundColor);
  } else {
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-textColor")) {
      gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-textColor");
    }
    if (gPref.prefHasUserValue("extensions.speeddial.group-" + targetGroup + "-backgroundColor")) {
      gPref.clearUserPref("extensions.speeddial.group-" + targetGroup + "-backgroundColor");
    }
  }
  
  if (addingGroup) {
    // Increase number of groups preference
    gPref.setIntPref("extensions.speeddial.numGroups", targetGroup);
  }
  
  return true;
}

function onCancel(event) {
  // Do nothing
  
  return true;
}

function useCustomColorsChanged() {
  if (document.getElementById("useCustomColors").checked) {
    document.getElementById("textColorLabel").disabled = false;
    document.getElementById("textColor").disabled = false;
    document.getElementById("textColorText").disabled = false;
    document.getElementById("backgroundColorLabel").disabled = false;
    document.getElementById("backgroundColor").disabled = false;
    document.getElementById("backgroundColorText").disabled = false;
  } else {
    document.getElementById("textColorLabel").disabled = true;
    document.getElementById("textColor").disabled = true;
    document.getElementById("textColorText").disabled = true;
    document.getElementById("backgroundColorLabel").disabled = true;
    document.getElementById("backgroundColor").disabled = true;
    document.getElementById("backgroundColorText").disabled = true;
  }
}

function textColorChanged() {
  var textColorText = document.getElementById("textColorText");
  var textColor = document.getElementById("textColor");
  
  if (textColorText.value != textColor.color) {
    textColorText.value = textColor.color;
  }
}

function textColorTextChanged() {
  var textColorText = document.getElementById("textColorText");
  var textColor = document.getElementById("textColor");
  
  if (textColorText.value != textColor.color) {
    textColor.color = textColorText.value;
  }
}

function backgroundColorChanged() {
  var backgroundColorText = document.getElementById("backgroundColorText");
  var backgroundColor = document.getElementById("backgroundColor");
  
  if (backgroundColorText.value != backgroundColor.color) {
    backgroundColorText.value = backgroundColor.color;
  }
}

function backgroundColorTextChanged() {
  var backgroundColorText = document.getElementById("backgroundColorText");
  var backgroundColor = document.getElementById("backgroundColor");
  
  if (backgroundColorText.value != backgroundColor.color) {
    backgroundColor.color = backgroundColorText.value;
  }
}

