var MultiKey = {
  initialNumber: 0,
  numberThumbnails: 0,
  numberDigits: 0,
  ctrlPressed: false,
  shiftPressed: false,
  altPressed: false,
  digitBox: null,
  cancelledMultikey: false,
  isClosing: false,
  multikeyBundle: null,
  targetAction: 0,
  multikeySelectWhenComplete: false,
  showingMultiKey: false,
  initiatedFirefox3: false,

  Startup: function() {
    /*
    MultiKey.initialNumber = window.arguments[0];
    MultiKey.numberThumbnails = window.arguments[1];
    MultiKey.callbackFunction = window.arguments[2];
    MultiKey.cancelCallbackFunction = window.arguments[3];
    MultiKey.ctrlPressed = window.arguments[4];
    MultiKey.shiftPressed = window.arguments[5];
    MultiKey.altPressed = window.arguments[6];
    var desiredWidth = window.arguments[7];
    MultiKey.targetAction = window.arguments[8];
    */
    MultiKey.isClosing = false;
    
    if (MultiKey.multikeyBundle == null) {
      MultiKey.multikeyBundle = document.getElementById("bundle_multikey");
    }
    
    MultiKey.multikeySelectWhenComplete = SpeedDial.prefs.getBoolPref("extensions.speeddial.multikeySelectWhenComplete");
    
    // Set size
    var mainBox = document.getElementById("multikeyMainBox");
    
    // Set action label
    var actionLabel = document.getElementById("multikeyAccessDialLabel");
    if (MultiKey.targetAction == 1) {
      actionLabel.setAttribute("value", MultiKey.multikeyBundle.getString("currentTab.label"));
    } else if (MultiKey.targetAction == 2) {
      actionLabel.setAttribute("value", MultiKey.multikeyBundle.getString("newTab.label"));
    } else if (MultiKey.targetAction == 3) {
      actionLabel.setAttribute("value", MultiKey.multikeyBundle.getString("backgroundTab.label"));
    } else if (MultiKey.targetAction == 4) {
      actionLabel.setAttribute("value", MultiKey.multikeyBundle.getString("newWindow.label"));
    } else if (MultiKey.targetAction == 5) {
      actionLabel.setAttribute("value", MultiKey.multikeyBundle.getString("saveDisk.label"));
    }
    
    // Add digits
    MultiKey.digitBox = document.getElementById("multikeyDigitBox");
    
    MultiKey.numberDigits = 0;
    var currentNumber = MultiKey.numberThumbnails;
    while (currentNumber > 0) {
      MultiKey.numberDigits++;
      currentNumber /= 10;
      currentNumber = Math.floor(currentNumber);
    }
    
    while (MultiKey.digitBox.firstChild) {
      MultiKey.digitBox.removeChild(MultiKey.digitBox.firstChild);
    }

    for (var c=MultiKey.numberDigits; c>0; c--) {
      var newImage = document.createElement("image");
      newImage.setAttribute("id", "multikeyDigit" + c);
      newImage.setAttribute("class", "multikeyDigit");
      if (c != 1) {
        newImage.setAttribute("number", "?");
      } else {
        newImage.setAttribute("number", MultiKey.initialNumber);
      }
      MultiKey.digitBox.appendChild(newImage);
    }
    
    MultiKey.updateCurrentDialData();
    /*
    addEventListener("keydown", function(event) { keyDownHandler(event); }, true);
    addEventListener("keyup", function(event) { keyUpHandler(event); }, true);
    addEventListener("blur", function(event) { blurHandler(event); }, false);
    */
  },

  Unload: function() {
    if (!MultiKey.cancelledMultikey) {
      SpeedDial.multikeyDialSelected(MultiKey.getCurrentNumber(), MultiKey.targetAction);
    }
  },
  
  show: function() {
    var mainBox = document.getElementById("multikeyMainBox");
    var mainSubBox = document.getElementById("multikeyMainSubBox");
    var multikeyBackground = document.getElementById("speeddial-multikey-background");

    if (SpeedDial.isFirefox3) {
      // "panel" only exists on Firefox 3
      var targetPanel;
      if (!MultiKey.initiatedFirefox3) {
        mainBox.removeChild(mainSubBox);
        
        var targetPanel = document.createElement("panel");
        targetPanel.setAttribute("id", "speeddial-multikey-panel");
        
        targetPanel.appendChild(mainSubBox);
          
        document.getElementById("mainPopupSet").appendChild(targetPanel);
        MultiKey.initiatedFirefox3 = true;
      } else {
        targetPanel = document.getElementById("speeddial-multikey-panel");
      }
      var multiKeyWidth = Math.floor(window.innerWidth * SpeedDial.prefs.getIntPref("extensions.speeddial.multikeyOverlayWidthModifier") / 100);
      var multiKeyHeight = targetPanel.boxObject.height;
      targetPanel.setAttribute("width", multiKeyWidth);
      targetPanel.setAttribute("left", Math.floor((screen.availWidth - multiKeyWidth) / 2));
      targetPanel.setAttribute("top", (screen.availHeight - multiKeyHeight) / 2);
      targetPanel.openPopup(null, "", 0, 0, false, true);
    } else {
      mainBox.setAttribute("multikey-shown", true);
      mainSubBox.style.width = mainBox.style.width  = window.innerWidth+'px';
      mainSubBox.style.height = mainBox.style.height  = window.innerHeight+'px';
   
      multikeyBackground.style.width  = (window.innerWidth * 2)+'px';
      multikeyBackground.style.height = (window.innerHeight * 2)+'px';
      multikeyBackground.setAttribute("multikey-shown", true);
    }
    
    MultiKey.showingMultiKey = true;
    
    MultiKey.Startup();
  },
  
  hide: function() {
    if (SpeedDial.isFirefox3) {
      document.getElementById("speeddial-multikey-panel").hidePopup();
    } else {
      document.getElementById("multikeyMainBox").setAttribute("multikey-shown", false);
      document.getElementById("speeddial-multikey-background").setAttribute("multikey-shown", false);
    }

    MultiKey.showingMultiKey = false;
 
    MultiKey.Unload();
  },

  updateCurrentDialData: function() {
    var currentNumber = MultiKey.getCurrentNumber();
    
    if ((currentNumber < 1) || (currentNumber > MultiKey.numberThumbnails)) {
      document.getElementById("multikeyCurrentDialLabel").setAttribute("value", SpeedDial.bundle.getString("outofrange.label"));
      document.getElementById("multikeyCurrentDialIcon").removeAttribute("src");
      document.getElementById("multikeyCurrentDialURL").setAttribute("value", " ");
    } else if (SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + currentNumber + "-url")) {
      var title = SpeedDial.prefs.getComplexValue("extensions.speeddial.thumbnail-" + currentNumber + "-label", Components.interfaces.nsISupportsString).data;
      if (title == "") {
        document.getElementById("multikeyCurrentDialLabel").setAttribute("value", SpeedDial.bundle.getString("untitled.label"));
      } else {
        document.getElementById("multikeyCurrentDialLabel").setAttribute("value", title);
      }
      document.getElementById("multikeyCurrentDialIcon").setAttribute("src", SpeedDial.prefs.getCharPref("extensions.speeddial.thumbnail-" + currentNumber + "-icon"));
      document.getElementById("multikeyCurrentDialURL").setAttribute("value", SpeedDial.prefs.getCharPref("extensions.speeddial.thumbnail-" + currentNumber + "-url"));
    } else {
      document.getElementById("multikeyCurrentDialLabel").setAttribute("value", SpeedDial.bundle.getString("unassigned.label"));
      document.getElementById("multikeyCurrentDialIcon").removeAttribute("src");
      document.getElementById("multikeyCurrentDialURL").setAttribute("value", " ");
    }
  },

  keyDownHandler: function(event) {
    var processed = false;
    
    if (event.keyCode == 16) {
      MultiKey.shiftPressed = true;
      processed = true;
    } else if (event.keyCode == 17) {
      MultiKey.ctrlPressed = true;
      processed = true;
    } else if ((event.keyCode == 18) || (event.keyCode == 224)) {  // Alt or Apple key
      MultiKey.altPressed = true;
      processed = true;
    } else if (event.keyCode == 13) { // Enter
      MultiKey.isClosing = true;
      MultiKey.hide();
      processed = true;
    } else if (event.keyCode == 8) { // Backspace
      MultiKey.processBackspace();
      processed = true;
    } else if (event.keyCode == 27) { // Escape
      MultiKey.cancelDialog();
      processed = true;
    } else if ((event.keyCode == 37) || (event.keyCode == 38) || (event.keyCode == 109)) { // Cursor up, left, and minus
      MultiKey.goPreviousDial();
      processed = true;
    } else if ((event.keyCode == 39) || (event.keyCode == 40) || (event.keyCode == 61)) { // Cursor down, right, and plus
      MultiKey.goNextDial();
      processed = true;
    }

    if (processed == true) {
      event.preventDefault();
      event.preventBubble();
      event.preventCapture();
      event.stopPropagation();
    }
  },

  keyUpHandler: function (event) {
    var processed = false;
    if (event.keyCode == 16) {
      processed = true;
      MultiKey.shiftPressed = false;
    } else if (event.keyCode == 17) {
      processed = true;
      MultiKey.ctrlPressed = false;
    } else if ((event.keyCode == 18) || (event.keyCode == 224)) {
      processed = true;
      MultiKey.altPressed = false;
    } else if ((event.keyCode == 13) || (event.keyCode == 8) || (event.keyCode == 27) ||(event.keyCode == 37) || (event.keyCode == 38) || (event.keyCode == 109) || (event.keyCode == 39) || (event.keyCode == 40) || (event.keyCode == 61)) {
      processed = true;
    }
    if (!MultiKey.ctrlPressed && !MultiKey.shiftPressed && !MultiKey.altPressed) {
      MultiKey.isClosing = true;
      MultiKey.hide();
    } else if (processed) {
      event.preventDefault();
      event.preventBubble();
      event.preventCapture();
      event.stopPropagation();
    }
  },

  processKey: function (event, typedNumber) {
    var firstDigit = document.getElementById("multikeyDigit" + MultiKey.numberDigits);
    
    for (var c=MultiKey.numberDigits; c>1; c--) {
      document.getElementById("multikeyDigit" + c).setAttribute("number", document.getElementById("multikeyDigit" + (c - 1)).getAttribute("number"));
    }
    
    // Set last digit
    document.getElementById("multikeyDigit1").setAttribute("number", typedNumber);
    
    MultiKey.updateCurrentDialData();
    
    if ((firstDigit.getAttribute("number") != "?") && (MultiKey.multikeySelectWhenComplete)) {
      // Completed! Process
      MultiKey.isClosing = true;
      MultiKey.hide();
    }
    
    event.preventDefault();
    event.preventBubble();
    event.preventCapture();
    event.stopPropagation();
  },

  processBackspace: function () {
    for (var c=1; c<=MultiKey.numberDigits; c++) {
      if (c<MultiKey.numberDigits) {
        document.getElementById("multikeyDigit" + c).setAttribute("number", document.getElementById("multikeyDigit" + (c + 1)).getAttribute("number"));
      } else {
        document.getElementById("multikeyDigit" + c).setAttribute("number", "?");
      }
    }
    MultiKey.updateCurrentDialData();
  },

  goPreviousDial: function () {
    var currentNumber = MultiKey.getCurrentNumber();
    var originalNumber = currentNumber;
    do {
      currentNumber--;
      if (currentNumber < 1) {
        currentNumber = MultiKey.numberThumbnails;
      }
    } while ((currentNumber != originalNumber) && !SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + currentNumber + "-url"));
  
    if (currentNumber != originalNumber) {
      MultiKey.setCurrentNumber(currentNumber);
    }
  },

  goNextDial: function () {
    var currentNumber = MultiKey.getCurrentNumber();
    var originalNumber = currentNumber;
    do {
      currentNumber++;
      if (currentNumber > MultiKey.numberThumbnails) {
        currentNumber = 1;
      }
    } while ((currentNumber != originalNumber) && !SpeedDial.prefs.prefHasUserValue("extensions.speeddial.thumbnail-" + currentNumber + "-url"));
    
    if (currentNumber != originalNumber) {
      MultiKey.setCurrentNumber(currentNumber);
    }
  },

  setCurrentNumber: function (currentNumber) {
    for (var c=1; c<=MultiKey.numberDigits; c++) {
      var currentDigit = document.getElementById("multikeyDigit" + c);
      if (currentNumber > 0) {
        currentDigit.setAttribute("number", parseInt(currentNumber % 10));
        currentNumber = Math.floor(currentNumber / 10);
      } else {
        currentDigit.setAttribute("number", "?");
      }
    }
    MultiKey.updateCurrentDialData();
  },

  getCurrentNumber: function () {
    var currentModifier = 1;
    var currentValue = 0;
    
    for (var c=1; c<=MultiKey.numberDigits; c++) {
      var digitValue = document.getElementById("multikeyDigit" + c).getAttribute("number");
      if (digitValue != "?") {
        currentValue += parseInt(digitValue) * currentModifier;
      }
      currentModifier *= 10;
    }
    
    return currentValue;
  },

  cancelDialog: function () {
    if (!MultiKey.isClosing) {
      MultiKey.cancelledMultikey = true;
      MultiKey.isClosing = true;
      MultiKey.hide();
    }
  },

  blurHandler: function (event) {
    MultiKey.cancelDialog();
  }
}