#!/bin/bash

oldabi="$( grep '^#define SPL_ABICKSUM ' spl.h | cut -f3 -d' '; )"
newabi="$( grep -v '^#define SPL_ABI' spl.h | cksum | cut -f1 -d' '; )"

echo "** Patching ABI checksum (new: $newabi, old: $oldabi) to spl.h."
sed -i 's,^\(#define SPL_ABICKSUM\).*,\1 '$newabi',' spl.h
sed -i '/^#define SPL_ABI(/ s,\(SPL_ABI\)_[0-9]*,\1_'$newabi',' spl.h

