/*
 *  SPL - The SPL Programming Language
 *  Copyright (C) 2004, 2005  Clifford Wolf <clifford@clifford.at>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  c-api-test3.c: More complex test for the assembler interface. Implements
 *  a real assembler which reads text input from a file and creates a
 *  bytecode file from it.
 */

#define _GNU_SOURCE

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>

#include "spl.h"

void assemble()
{
	FILE *f = fopen("c-api-test3.spla", "r");
	struct spl_asm *as = spl_asm_create();
	char line[1024];
	int lineno=1;

	while ( fgets(line, 1024, f) ) {
		if ( spl_asm_parse_line(as, line) < 0 ) {
			printf("... in line %d.\n", lineno);
			exit(1);
		}
		lineno++;
	}
	if ( spl_asm_resolve_labels(as) < 0 ) exit(1);
	fclose(f);

	int fd = open("c-api-test3.splb", O_WRONLY|O_CREAT|O_TRUNC, 0666);
	spl_asm_write(as, fd);
	close(fd);

	spl_asm_destroy(as);
}

void execute()
{
	struct spl_vm *vm = spl_vm_create();
	struct spl_task *task = spl_task_create(vm, 0);
	struct spl_code *code = spl_code_get(0);

	code->code_type = SPL_CODE_MAPPED;
	code->code = spl_mmap_file("c-api-test3.splb", 0);
	spl_task_setcode(task, code);

	while ( task->code && !spl_exec(task) ) {}
	spl_vm_destroy(vm);
}

int main()
{
	assemble();
	execute();
	return 0;
}

