#!/bin/bash

set -ue

oldabi="$( grep '^#define SPL_ABICKSUM ' spl.h | cut -f3 -d' '; )"
newabi="$( grep -v '^#define SPL_ABI' spl.h | cksum | cut -f1 -d' '; )"

echo "** Patching ABI checksum (new: $newabi, old: $oldabi) to spl.h."
rm -f spl.h.new
sed -e 's,^\(#define SPL_ABICKSUM\).*,\1 '"$newabi"',' \
    -e '/^#define SPL_ABI(/ s,\(SPL_ABI\)_[0-9]*,\1_'$newabi',' <spl.h >spl.h.new
mv spl.h.new spl.h
