# This file is sourced by /lib/lsb/init-fuctions
# it redefines the log_end_message function to
# call splashy_update.
#
# KNOWN BUGS
# Splashy and console-screen.sh don't work together.

# int log_end_message (int exitstatus)
log_end_msg () {
    # If no arguments were passed, return
    [ -z "${1:-}" ] && return 1
    # load some default variables
    [ -r /etc/default/splashy ] && . /etc/default/splashy

    # Only do the fancy stuff if we have an appropriate terminal
    # and if /usr is already mounted
    if log_use_fancy_output; then
        RED=`$TPUT setaf 1`
        NORMAL=`$TPUT op`
        if [ $1 -eq 0 ]; then
            echo "."
        else
            /bin/echo -e " ${RED}failed!${NORMAL}"
        fi
    else
        if [ $1 -eq 0 ]; then
            echo "."
        else
            echo " failed!"
        fi
    fi

    ##############################################################
    # Start splashy code 

    # Bug #400598,#401999
    if [ -z "${RUNLEVEL:-}" ]; then
        # we need only the current level
        RUNLEVEL=`runlevel | sed 's/^. //'`
    fi

    DIR=/lib/init/rw/splashy

    SPL_UPD=/sbin/splashy_update
    SPL_PRG=$DIR/$RUNLEVEL-progress

    [ -x $SPL_UPD ] || return $1;
    [ -f $SPL_PRG ] || return $1; 

    # It makes no sense for us to send this step if splashy is not running
    # Although then splashy_update would just return
    (pidof splashy > /dev/null) || return $1; 

    # Get progress percentage of this script
    # was calculated by update-progress-steps
    PER=`sed -n 's+'${0}' ++ p' $SPL_PRG`

    # This can not happen ...
    [ -n "$PER" ] || return $1;

    # Fix $PER, whenever any of these scripts
    # is detected, we need to set Splashy's progress to 100%
    # and exit:
    # Xgl, gdm, kdm, xdm, (add other dm's here)
    #
    # Also if X or Xgl is running, we do the same thing.

    #echo ${0} | egrep -q '(gdm$|kdm$|xdm$)' && PER=100
    case "${0##*/}" in
	S*gdm | S*kdm | S*xdm )
	PER=100
	;;
	# in Sid 2006-10-08 05:57 EDT the scripts after S99rc.local
	# do not call lsb* functions. So we don't know when the boot process is done
	S99rc.local )
	PER=100
	;;
	*)
	;;
    esac

    pidof X > /dev/null && PER=100
    pidof Xgl > /dev/null && PER=100

    # Update progress bar 
    $SPL_UPD "progress $PER" || true
    # Write name of script to the splashy textarea
    #$SPL_UPD "print ${0##*/} $PER" || true

    # Write to log (for testing)
    if [ "x$DEBUG" != "x0" ]; then
	uptime >> $DIR/splashy.log 2>&1
	echo "print ${0##*/} $PER" >> $DIR/splashy.log
    fi

    # Do some special things in the last update
    if [ $PER -eq 100 ]; then
	$SPL_UPD "exit" # && return $1 || sleep 1
	# Write to log (for testing)
	if [ "x$DEBUG" != "x0" ]; then
	    echo "calling exit" >> $DIR/splashy.log
	    uptime >> $DIR/splashy.log 2>&1
	fi
	if (pidof splashy > /dev/null); then
	    # wait until splashy exits before changing tty's
	    # this is because of the fade-out effect mostly
	    # so 200 ms should do it
	    sleep 0.2
	    # FIXME what if splashy never exits? infinite loop!
	    while `pidof splashy > /dev/null`; do
		sleep 0.2
		#echo "calling killall -9 splashy" >> $DIR/splashy.log
		# be thorough:
		killall -9 splashy > /dev/null 2>&1
	    done
	fi
	# do some magic with the TTYs
	if test -z "$CHVT_TTY"; then
	    CHVT_TTY=1
	fi
	# detect X, if not, go to CHVT_TTY
	X11_RUNNING=0
	pidof X > /dev/null && X11_RUNNING=1
	if [ $X11_RUNNING -eq 1 ]; then
	    splashy_chvt 7
	else
	    splashy_chvt $CHVT_TTY
	fi

	# Bug #400598
	# if Splashy was running from initramfs,
	# and our runlevel is currently a number between 2 and 5,
	# we need to re-run keymap.sh and console-screen.sh
	if [ $RUNLEVEL -gt 1 -a $RUNLEVEL -lt 6 ]; then 
	    if [ -x "/etc/init.d/keymap.sh" ]; then
		if [ "x$DEBUG" != "x0" ]; then
		    uptime >> $DIR/splashy.log 2>&1
		    echo "calling keymap.sh" >> $DIR/splashy.log
		fi
		/etc/init.d/keymap.sh start
	    fi
	    if [ -x "/etc/init.d/console-screen.sh" ]; then
		if [ "x$DEBUG" != "x0" ]; then
		    uptime >> $DIR/splashy.log 2>&1
		    echo "calling console-screen.sh" >> $DIR/splashy.log
		fi
		/etc/init.d/console-screen.sh start
	    fi
	fi 
    fi


    return $1
}

