// -*- c++ -*-
// pseudo-test.t  --  generate a sppc-file with Tela comands

output_filename = "pseudo-test.sppc";

function z = p(x, y) { z = (x**3 - y*x**2) * exp(-x) };

n = 20;
u = zeros(n);
v = zeros(n);
w = zeros(n, n);

for (i = 1; i <= n; i++) { u[i] = 4.0*i/n };
for (j = 1; j <= n; j++) { v[j] = 20.0*j/n };

for (i = 1; i <= n; i++)
{ 
        for (j = 1; j <= n; j++)
        {
                w[i, j] = p(u[i], v[j])
        };
};

sppcopts("title", "Modified Exponential",
         "usebinary", "false");
pseudo(u, v, w);
panel();
endpanels("output", output_filename);

