#ifndef BUTTON_H
#define BUTTON_H

#include <string>
#include <boost/signal.hpp>

#include "GuiElement.h"

namespace agui
{

class Button : public GuiElement
{
public:
	Button(const std::string& label = "", GuiElement* parent = NULL);
	
	void Label(const std::string& label);
	
	boost::signal<void (void)> Clicked;

private:
	virtual void DrawSelf();
	virtual bool HandleEventSelf(const SDL_Event& ev);

	bool hovered;
	bool clicked;

	std::string label;

};

}

#endif