
__doc__="a class for logging"

import sys
if not sys.modules.has_key('gtk'):
    import pygtk
    pygtk.require('1.2')

from gtk import *

import time
import os

#list of levels
LOG_VERBOSE=0
LOG_SQL=1
LOG_MESSAGE=2
LOG_INFO=2
LOG_DONE=3
LOG_WARNING=4
LOG_ERROR=5

__levels=['VERBOSE','SQL','INFO','DONE','WARNING','ERROR' ]

#sounds
__play=None

def  iss(z):
    try:
        f=open(z)
        f.close()
        return z
    except:
        return None
    
for i in [ '/usr/bin/esdplay', '/usr/bin/play' ] :
    __play=iss(i)
    if __play:
        break

done_snd=lambda x=1: 0
error_snd=lambda x=1: 0
warning_snd=lambda x=1: 0
generic_snd=lambda x=1: 0

if __play:   
    e=iss('/usr/share/sounds/error.wav')
    if e:
        e=__play+' '+e+' &'
        error_snd=lambda x=1,e=e,os=os: os.system(e)
    e=iss('/usr/share/sounds/info.wav')
    if e:
        e=__play+' '+e+' &'
        done_snd=lambda x=1,e=e,os=os: os.system(e)
    e=iss('/usr/share/sounds/warning.wav')
    if e:
        e=__play+' '+e+' &'
        warning_snd=lambda x=1,e=e,os=os: os.system(e)
    e=iss('/usr/share/sounds/generic.wav')
    if e:
        e=__play+' '+e+' &'
        generic_snd=lambda x=1,e=e,os=os: os.system(e)

        

class log_widget:
    #last log time
    __log_time=0.0
    

    __current_level=LOG_INFO
    
    #list of messages
    #__messages=[]

    #message
    __message=''
    
    #pop is running
    __popping=FALSE

    #if there is an extra main widget for loggin, we call it with
    main_log=None
    
    def __init__(self,main_log=None):
        self.main_log=main_log        


        st=GtkLabel()
        st.show()
        st.set_justify(JUSTIFY_LEFT)
        #for outside
        self.widget=st
        self.__widget=st


        st.connect("destroy",self.stop)

        #self.def_style=st.get_style()
        #FIXME: I dont really understand this
        #self.context=st.get_context_id ('any case')
        #st=GtkStatusbar()
        #self.statusbar_status=st            

    def __del__(self):
        self.__popping=FALSE
        
    def stop(self,data):
        self.__popping=FALSE
        
    #methods
    def pop(self,data):
        self.__message=''
        self.widget.set_text('')
        self.__popping=FALSE
        return FALSE

    def log(self,level,text):
        if self.main_log:
            self.main_log(level,text)

        if level < self.__current_level :
            return
            
        if level == LOG_INFO:
            generic_snd()
        if level == LOG_DONE:
            done_snd()
        if   level == LOG_WARNING:
            warning_snd()
        if level == LOG_ERROR:
            error_snd()
            

        if self.__message:
            self.__message=self.__message+'\n'
        if len(self.__message) > 200:
            self.__message='...'+self.__message[-200:]
        self.__message=self.__message+text
        self.widget.set_text(self.__message)
        
        if not self.__popping:
            self.__popping=TRUE
            timeout_add(3500,self.pop,self)

##     #HACK
##     def __old_pop_unused(self,data):
##         if self.__levels and self.__popping:
##             self.statusbar_status.pop(self.__levels[0])
##             self.__levels=self.__levels[1:]
##             self.__messages=self.__messages[1:]
##             if self.__levels and self.__popping:
##                 n=len(self.__levels)-1
##                 m=self.__messages[0]
##                 if n>0:
##                     m=m+ ('\n(%s more)' % n)
##                 self.statusbar_status.push(self.__levels[0],
##                                            m)
##             #FIXME doesnt work..
##             else:
##                 self.statusbar_status.bg = self.def_style.fg[STATE_NORMAL]
##             return TRUE
##         else:
##             self.__popping=FALSE
##             return FALSE
    

##     def __log_old():
##         #FIXME: I dont know the right way to use this... and it shows!
##         level=self.context
##         if text in self.__messages:
##             return        
##         self.__levels.append(level)
##         self.__messages.append(text)
##         if not self.__popping:
##             self.statusbar_status.push(self.__levels[0],
##                                        self.__messages[0])
##         #FIXME doesnt work..
##         self.statusbar_status.bg = self.def_style.black
        
##         #no:self.statusbar_status.push(level,text)
##         #it is a first in-first out
##         while events_pending():
##             #this is not main_iteration... but instead:
##             mainiteration()
##         self.__log_time=time.time()

    
        
