#include <iostream>
#include <sqlxx.h>
#include <unistd.h>
#include <strutilsxx.h>
#include <time.h>

using namespace std;
using namespace sqlxx;
using namespace strutilsxx;

#define MYSQLUSER	"root"
#define MYSQLPASS	""
#define MYSQLDB		"sqlxxtest"
#define MYSQLDEFDB	"mysql"
#define MYSQLHOST	"localhost"
#define MYSQLPORT	3128
#define MYSQLDRIVER     "/usr/lib/libmyodbc.so"
#define MYSQLSOCKET	"/var/run/mysqld/mysqld.sock"

#define PGSQLUSER	"postgres"
#define PGSQLPASS	""
#define PGSQLDB		"sqlxxtest"
#define PGSQLDEFDB      "postgres"
#define PGSQLHOST	"localhost"
#define PGSQLPORT	5432
#define PGSQLDRIVER	"/usr/lib/libpsqlodbc.so"
#define PGSQLSOCKET	"/var/run/postgresql/.s.PGSQL.5432"

#define CREATEDB "create database sqlxxtest;"
#define DROPDB "drop database sqlxxtest;"

#define CREATETABLE "create table test (id int4 not null, name text, zahli int8, zahlf float, nichts text null);"
#define DROPTABLE "drop table test;"

int iTime;

void main(void) {
  CSQL SQL;
  CSQLResult *Result;
  int iDBType, iConnectType, iAccessType, iCount;
  int iRows;
  short iCols;
  string sFields, sName, sNull;
  float fZahl;
  int iZahl, iID;
  bool bError;
  
  try {
    for(iDBType=0;iDBType<2;iDBType++) {
      // Loop DB Types (0=Mysql, 1=Postgres)
      for (iAccessType=0;iAccessType<2;iAccessType++) {
        // Loop Access Types (0=Native, 1=ODBC)
        for (iConnectType=0;iConnectType<2;iConnectType++) {
          // Loop Connect Types (0=Network, 1=Socket)

          // Postgres with ODBC and Socket is currently not working
          if (iDBType && iAccessType && iConnectType) continue;
                      
          switch (iDBType) {
            case 0:
              SQL.setUsername(MYSQLUSER);
              SQL.setPassword(MYSQLPASS);
              SQL.setDatabase("");
              if (iConnectType) {
                SQL.setSocket(MYSQLSOCKET);
                SQL.setHostname("");
                SQL.setPort(0);
              }
              else {
                SQL.setHostname(MYSQLHOST);
                SQL.setPort(MYSQLPORT);
                SQL.setSocket("");
              }
              if (iAccessType) {
                SQL.setDriver(MYSQLDRIVER);
                SQL.setType(SQLXX_ODBC);
              } else {
                SQL.setDriver("");
                SQL.setType(SQLXX_MYSQL);
              }
              break;
            case 1:
              SQL.setUsername(PGSQLUSER);
              SQL.setPassword(PGSQLPASS);
              SQL.setDatabase("");
              if (iConnectType) {
                SQL.setSocket(PGSQLSOCKET);
                SQL.setHostname("");
                SQL.setPort(0);
              }
              else {
                SQL.setHostname(PGSQLHOST);
                SQL.setPort(PGSQLPORT);
                SQL.setSocket("");
              }
              if (iAccessType) {
                SQL.setDriver(PGSQLDRIVER);
                SQL.setType(SQLXX_ODBC);
              } else {
                SQL.setType(SQLXX_POSTGRES);
                SQL.setDriver("");
              }
              break;
          }
          
          if (iDBType)
            cout << "Connecting to PostgreSQL";
          else
            cout << "Connecting to MySQL";
          if (iAccessType)
            cout << " (ODBC)";
          else
            cout << " (Native)";
          if (iConnectType)
            cout << " over Socket";
          else
            cout << " over Network";
            
          cout << "... ";

          if (iAccessType)          
            switch (iDBType) {
              case 0:
                SQL.setDatabase(MYSQLDEFDB);
                break;
              case 1:
               SQL.setDatabase(PGSQLDEFDB);
            }
          else
            SQL.setDatabase(""); 
          SQL.connect();
          cout << "OK" << endl;
          
          cout << "Creating test database... ";
          SQL.execQuery(CREATEDB);
          cout << "OK" << endl;

          cout << "Reconnecting with new database name... ";
          SQL.disconnect();

          switch (iDBType) {
            case 0:
              SQL.setDatabase(MYSQLDB);
              break;
            case 1:
              SQL.setDatabase(PGSQLDB);
          }
          SQL.connect();
          cout << "OK" << endl;

          cout << "Creating table test... ";
          SQL.execQuery(CREATETABLE);
          cout << "OK" << endl;

          cout << "Inserting 100 items... ";
          for (iCount=0;iCount<100;iCount++) {
            SQL.execQuery(format(
              "INSERT INTO test VALUES (%i,'Item %i',%i,%f,NULL);",
              SQL.getNewID("test","id"),iCount,iCount,25.4
            ));
          }
          cout << "OK" << endl;
          
          cout << "Open query... ";
          Result=SQL.openQuery("SELECT * from test");
          cout << "OK" << endl;
          
          cout << "Counting rows... ";
          iRows=Result->getNumRows();
          cout << iRows;
          if (iRows==100)
            cout << " -> OK" << endl;
          else
            cout << " -> ERROR!" << endl;
          
          cout << "Counting cols... ";
          iCols=Result->getNumCols();
          cout << iCols;
          if (iCols==5)
            cout << " -> OK" << endl;
          else
            cout << " -> ERROR!" << endl;
            
          cout << "Getting field names... ";
          sFields=Result->getColName(0);
          sFields+=" ";
          sFields+=Result->getColName(1);
          sFields+=" ";
          sFields+=Result->getColName(2);
          sFields+=" ";
          sFields+=Result->getColName(3);
          sFields+=" ";
          sFields+=Result->getColName(4);
          cout << sFields;
          if (sFields=="id name zahli zahlf nichts")
            cout << " -> OK" << endl;
          else
            cout << " -> ERROR!" << endl;
            
          cout << "Getting field types... ";
          Result->getColType(0);
          Result->getColType(1);
          Result->getColType(2);
          Result->getColType(3);
          Result->getColType(4);
          cout << "OK" << endl;
          
          cout << "Checking boundary in getColName... ";
          try {
            sFields=Result->getColName(5);
            cout << "ERROR!" << endl;
          }
          catch (sqlxx_error E) {
            cout << "OK" << endl;
          }
          
          cout << "Checking boundary in getColType... ";
          try {
            Result->getColType(5);
            cout << "ERROR!" << endl;
          }
          catch (sqlxx_error E) {
            cout << "OK" << endl;
          }
          
          cout << "Checking boundary in get... ";
          try {
            Result->get(5);
            cout << "ERROR!" << endl;
          }
          catch (sqlxx_error E) {
            cout << "OK" << endl;
          }

          cout << "Checking boundary in getInt... ";
          try {
            Result->getInt(5);
            cout << "ERROR!" << endl;
          }
          catch (sqlxx_error E) {
            cout << "OK" << endl;
          }


          cout << "Checking boundary in getFloat... ";
          try {
            Result->getFloat(5);
            cout << "ERROR!" << endl;
          }
          catch (sqlxx_error E) {
            cout << "OK" << endl;
          }
          

          cout << "Checking boundary in isNull... ";
          try {
            Result->isNull(5);
            cout << "ERROR!" << endl;
          }
          catch (sqlxx_error E) {
            cout << "OK" << endl;
          }

          cout << "Checking 'unknown field' name in get... ";
          try {
            Result->get("non-existant");
            cout << "ERROR!" << endl;
          }
          catch (sqlxx_error E) {
            cout << "OK" << endl;
          }

          cout << "Checking 'unknown field' name in getInt... ";
          try {
            Result->getInt("non-existant");
            cout << "ERROR!" << endl;
          }
          catch (sqlxx_error E) {
            cout << "OK" << endl;
          }

          cout << "Checking 'unknown field' name in getFloat... ";
          try {
            Result->getFloat("non-existant");
            cout << "ERROR!" << endl;
          }
          catch (sqlxx_error E) {
            cout << "OK" << endl;
          }

          cout << "Checking 'unknown field' name in isNull... ";
          try {
            Result->isNull("non-existant");
            cout << "ERROR!" << endl;
          }
          catch (sqlxx_error E) {
            cout << "OK" << endl;
          }

          cout << "Fetching data... ";
          bError=false;
          while (Result->fetch()) {
            iID=Result->getInt(0);
            sName=Result->get(1);
            iZahl=Result->getInt(2);
            fZahl=Result->getFloat(3);
            sNull=Result->get(4);
            if (!Result->isNull(4)) bError=true;
            if (fZahl!=25.4f) bError=true;
            if (iZahl!=iID-1) bError=true;
            if (sName!=format("Item %i",iZahl)) bError=true;
            iID=Result->getInt("id");
            sName=Result->get("name");
            iZahl=Result->getInt("zahli");
            fZahl=Result->getFloat("zahlf");
            sNull=Result->get("nichts");
            if (!Result->isNull("nichts")) bError=true;
            if (fZahl!=25.4f) bError=true;
            if (iZahl!=iID-1) bError=true;
            if (sName!=format("Item %i",iZahl)) bError=true;
          }
          if (!bError)
            cout << "OK" << endl;
          else
            cout << "ERROR!" << endl;
            
          cout << "Checking getQueries()... ";
          if (SQL.getQueries().size()==1)
            cout << "OK" << endl;
          else
            cout << "ERROR!" << endl;
          
            
          cout << "Checking countQueries()... ";
          if (SQL.countQueries()==1)
            cout << "OK" << endl;
          else
            cout << "ERROR!" << endl;
            
          cout << "Closing query... ";
          SQL.closeQuery(Result);
          cout << "OK" << endl;
          
          cout << "Checking countQueries()... ";
          if (SQL.countQueries()==0)
            cout << "OK" << endl;
          else
            cout << "ERROR!" << endl;
            
          cout << "Dropping table test... ";
          SQL.execQuery(DROPTABLE);
          cout << "OK" << endl;
          
          
          cout << "Checking isConnected... ";
          if (!SQL.isConnected())
            cout << "ERROR!" << endl;
          else
            cout << "OK" << endl;


          cout << "Reconnecting without database... ";
          SQL.disconnect();
          if (iAccessType)          
            switch (iDBType) {
              case 0:
                SQL.setDatabase(MYSQLDEFDB);
                break;
              case 1:
               SQL.setDatabase(PGSQLDEFDB);
            }
          else
            SQL.setDatabase(""); 
          SQL.connect();
          cout << "OK" << endl;
          
          cout << "Waiting 5 seconds... ";
          cout.flush();
          sleep(5);
          cout << "OK" << endl;
          
          cout << "Dropping test database... ";
          SQL.execQuery(DROPDB);
          cout << "OK" << endl;
          
          cout << "Disconnecting... ";
          SQL.disconnect();
          cout << "OK" << endl;

          cout << "Checking isConnected... ";
          if (SQL.isConnected())
            cout << "ERROR!" << endl;
          else
            cout << "OK" << endl;
        }
      }
    }
  }
  catch (sqlxx_error E) {
    cerr << E.what() << endl;
  }
}
