from unittest import makeSuite

from base import SquishdotBase

from Products.Squishdot.Utility import file_path

import re

class MailTests(SquishdotBase):

    def _mail(self,Posting):
        Site = self.Site
        mail =Site.mail_html(Site,
                             Site.REQUEST,
                             newItem=Posting,
                             email='test@address.com')
        f = open('%s/tests/%s.mailre' % (file_path,Posting.title),'r')
        mailre = re.compile('^%s' % f.read())
        f.close()
        assert mailre.match(mail)                

    def testMailHTMLArticle(self):
        "Check HTML Article Mailing"
        
        id = self._addPosting(title    = 'testMailHTMLArticle',
                              author   = 'tester',
                              body     = '<b>body</b><br><i>italic</i>',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'HTML',
                              subject  = 'test subject',
                              summary  = '<hr>summary<p>no way</p>',
                              dept     = 'dept')
        
        self._mail(self.Site[id])
        
    def testMailPlainArticle(self):
        "Check Plain Article Mailing"
        
        id = self._addPosting(title    = 'testMailPlainArticle',
                              author   = 'tester',
                              body     = '<b>body</b><br><i>italic</i>',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'Plain',
                              subject  = 'test subject',
                              summary  = '<hr>summary<p>no way</p>',
                              dept     = 'dept')
        
        self._mail(self.Site[id])

    def testMailSTXArticle(self):
        "Check STX Article Mailing"
        
        id = self._addPosting(title    = 'testMailSTXArticle',
                              author   = 'tester',
                              body     = '<b>body</b>\n*italic*',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'STX',
                              subject  = 'test subject',
                              summary  = '<hr>summary\n\nno way',
                              dept     = 'dept')
        
        self._mail(self.Site[id])

    def testMailHTMLComment(self):
        "Check HTML Comment Mailing"
        
        parent = self._getPosting()
        
        id = self._addPosting(object   = parent,
                              title    = 'testMailHTMLComment',
                              author   = 'tester',
                              body     = '<b>body</b><br><i>italic</i>',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'HTML')
        
        self._mail(self.Site[parent.getId()][id])

    def testMailPlainComment(self):
        "Check Plain Comment Mailing"
        
        parent = self._getPosting()
        
        id = self._addPosting(object   = parent,
                              title    = 'testMailPlainComment',
                              author   = 'tester',
                              body     = '<b>body</b><br><i>italic</i>',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'Plain')
        
        self._mail(self.Site[parent.getId()][id])

    def testMailSTXComment(self):
        "Check STX Comment Mailing"
        
        parent = self._getPosting()
        
        id = self._addPosting(object   = parent,
                              title    = 'testMailSTXComment',
                              author   = 'tester',
                              body     = '<b>body</b>\n*italic*',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'STX')
        
        self._mail(self.Site[parent.getId()][id])

def test_suite():
    return makeSuite(MailTests)

def debug():
   test_suite().debug()
    
