#include "header.h"

struct mixer *init_mixer(char *mixer_filename){
	struct mixer *mix;
	int fd, i;
    const char *names[] = SOUND_DEVICE_LABELS;
	
	mix=g_new0(struct mixer, 1);

	mix->mixer=g_strdup(mixer_filename);

	fd=open(mix->mixer, O_RDWR, 0);
	if (fd<0){
		return NULL;
	}

	if (ioctl(fd, SOUND_MIXER_READ_RECMASK, &mix->recmask) <0){
		close(fd);
		return NULL;
	}
	
	if (ioctl(fd, SOUND_MIXER_READ_RECSRC, &mix->recsrc) <0){
		close(fd);
		return NULL;
	}
	
    dbg("recmask=0x%x ( ", mix->recmask);
    for (i=0; i<SOUND_MIXER_NRDEVICES; i++){
        if (mix->recmask & (1<<i)) dbg("%s ", names[i]);
    }
    dbg(")\n");
    
    dbg("recsrc=0x%x ( ", mix->recsrc);
    for (i=0; i<SOUND_MIXER_NRDEVICES; i++){
        if (mix->recsrc & (1<<i)) dbg("%s ", names[i]);
    }
    dbg(")\n");
    
	close(fd);
	return mix;
}

void free_mixer(struct mixer *mix){
	if (!mix) return;
		
	CONDGFREE(mix->mixer);
	g_free(mix);
}

void mixer_set_filename(struct mixer *mix, char *mixer_filename){
	if (!mix) return;
	
	CONDGFREE(mix->mixer);
	mix->mixer=g_strdup(mixer_filename);
}

void mixer_set_source(struct mixer *mix, int source){
	int fd;
	
	if (!mix) return;
	
	fd=open(mix->mixer, O_RDWR, 0);
	if (fd<0){
		return;
	}

	if (ioctl(fd, SOUND_MIXER_WRITE_RECSRC, &source) <0){
		close(fd);
		return;
	}
    
	close(fd);
}





