/*
	writer	: Ma Su An
	E-Mail	: msa@wri.com.cn
	
	Copyright by Ma Su An.
	All rights reserved.
	Permission to use ,copy,modify,and distribute this software for
	individual use and without fee is granted with that condition:

    	Every copy of this software must have the writer's name displayed 
	on the top label.
*/

// filename: trans.cc
// msa 1999.1

#include "trans.h"
#include "image.h"
#include "regdef.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <string.h>
#include <Xm/DialogS.h>

// In HP_UX , MAP_FAILED is not defined. msa add 1999.9.26
#ifndef MAP_FAILED
#define MAP_FAILED	((void*)-1)
#endif

const char* const TOPLABEL_S="    1.31   :    ";

const char* const LIC_INFO_S="\
    Ȩ    1999    հ \n\
    Ϊ\n\
GNUͨù\n\
޸ĺ·һ,\n\
֤ڶ棬ߣѡ\n\
θµİ汾\n\
    ߲֤ƴд\n\
ȷԡ\n ";

const char* const HELP_MESS_S="\
    ӭʹáǼ\n\
ǼX-Window\n\
ӢֵСƥ䡱\n\
Ļѡȡģѯǿ\n\
ܡ\n\
\n\
    ֽ书ܼʹ÷˵£\n\
\n\
    1.ƥ\n\
     ´·Сƥ䡱\n\
ƹҰťƥ״̬û\n\
С*ַ͡\n\
Ϊƥ򡣡*ʾַ\n\
ʾĳһַ»س\n\
ұߵбмƥ˹\n\
ʡڲʾʮͬ\n\
ʱڴĴʾһ\n\
ʵ塣\n\
\n\
    2.Ļѡȡ\n\
     ´·СĻѡȡ\n\
ƹҰťĻѡȡ״̬û\n\
Ļѡȡ\n\
˫סʹʴ\n\
״̬ڴ˵ʸᵯһ\n\
,ʾ˵ʵ塣˹֧\n\
ڡnetscapeAcrobatȡ\n\
\n\
   3.ʹб\n\
     беĿΪ鵥\n\
ɵʣڹƥ״̬ʾ\n\
ƥɵʡ\n\
\n\
   4.˵\n\
    ȱʡĿ¼Ϊ/opt/dic\n\
/usr/local/dic/dic$HOME/dic\n\
ʹЩĿ¼û\n\
TRANSHOME ָ:\n\
     setenv TRANSHOME <your dir>\n\
\n\
   5.ʹ÷\n\
     ûʹ÷ֻ֣Ҫ޸\n\
<INSTALLDIR>/hzfont/fonts.dirļ\n\
        hz16.pcf hz16\n\
Ϊ  hz16ft.pcf hz16 \n\
ȻִУxset fp rehashX-Window\n\
ɡ\n\
\n\
    ߼:\n\
     հ,ҵйƼѧ\n\
ϵְֹ人ʵѧоԺ\n\
רҵµϵͳ\n\
     E-MAIL: \n\
      msa@wri.com.cn \n\n";

//====================================================================
// global object

char sErrorMessage[MAX_STR_LEN+1];
char sHomeDir[MAX_STR_LEN+1];
PixmapClass *poBackImage;
char* asSearchDirs[]={
	"/opt/dic",
	"/usr/local/dic",
	"/dic",
	NULL};

char *fallback[]={
//	"*background:grey90",
	"*background:white",
	"*foreground:black",
	"*wordtext.background:white",
	"*wordtext*fontList:9x15bold",
	"*scrolledlist*background:white",
	"*transrc.width:510",
	"*transrc.height:280",
	"*transrc.x:400",
	"*transrc.y:50",
	"*fontList:9x15bold=English,hz16=Chinese,yb10x20=YB",
	"*list*fontList:9x15bold",
//	"*list*doubleClickInterval:500",
	NULL};

//===================================================================
Boolean bIsChinese(char ch)
{
	return((unsigned)ch>160);
}

//===================================================================
// mystrcmp ignore case.

int mystrcmp(const char *s1,const char *s2)
{
	assert(s1!=NULL && s2!=NULL);

	int i;
	for(i=0;s1[i]!='\0' && s2[i]!='\0';++i)
	{
	     	char c1 = tolower((unsigned char)s1[i]);  
	     	char c2 = tolower((unsigned char)s2[i]);
	     	if (c1 > c2) return (1);
	     	else if (c1 < c2) return (-1);
	}

	if(s1[i]!='\0') return(1); 	// s2[i] must be '\0' so s1>s2
	else if(s2[i]!='\0') return(-1);// s1[i] must be '\0' so s1<s2
	else return(0);	// s1[i]=='\0' and s2[i]=='\0',so s1==s2
}

//===================================================================
MyString::MyString(char *str)
{
	sContent=str;
	return;
}

/********************************************************************/
MyString::MyString()
{
	sContent=NULL;
	return;
}

/********************************************************************/
int MyString::operator==(const char *sString)
{
	return(mystrcmp(sContent,sString)==0); 
}

/********************************************************************/
int MyString::operator<(const char *sString)
{
	return(mystrcmp(sContent,sString)<0); 
}

//===================================================================
int operator==(const MyString &oLItem,const MyString &oRItem)
{
	return(mystrcmp(oLItem.sContent,oRItem.sContent)==0);
}

/********************************************************************/
int operator<(const MyString &oLItem,const MyString &oRItem)
{
	return(mystrcmp(oLItem.sContent,oRItem.sContent)<0);
}

//===================================================================
WordItem::WordItem(char *sNewEnglish,char *sNewChinese):
	msEnglish(sNewEnglish),msChinese(sNewChinese)
{
	return;
}

/********************************************************************/
int WordItem::operator==(const char* sString)
{
	return(msEnglish==sString); 
}

/********************************************************************/
int WordItem::operator<(const char* sString)
{
	return(msEnglish<sString); 
}

/********************************************************************/
const char *WordItem::sGetWord() const
{
	return(msEnglish.data());
}

/********************************************************************/
const char *WordItem::sGetMeaning() const
{
	return(msChinese.data());
}

//===================================================================
int operator==(const WordItem &oLItem,const WordItem &oRItem)
{
	return(oLItem.msEnglish==oRItem.msEnglish);
}

/********************************************************************/
int operator<(const WordItem &oLItem,const WordItem &oRItem)
{
	return(oLItem.msEnglish<oRItem.msEnglish);
}

//===================================================================
Lib::Lib()
{
	aWordLib=new (WordItem*[START_CAPACITY]);
	iCapacity=START_CAPACITY;
	iLength=0;
	return;
}

/********************************************************************/
/*
        read words from dictionary file.
*/
 
Boolean Lib::bGetLib(const char *sDictionaryFile)
{
	int fd=open(sDictionaryFile,O_RDONLY);
        if(fd==-1)
        {
                sprintf(sErrorMessage,"can't open %s !",sDictionaryFile);
		return(False);
        }

	// get length of dicfile.
	struct stat stStat;
	if(fstat(fd,&stStat)!=0)
	{
                strcpy(sErrorMessage,"can't get dictionary stat !");
		return(False);
        }

	// mmap the file to memory
	caddr_t pFileMem=(caddr_t)mmap((caddr_t)0,stStat.st_size,
		PROT_READ | PROT_WRITE,MAP_PRIVATE,fd,0);
	if(pFileMem==MAP_FAILED)
	{
                strcpy(sErrorMessage,"mmap error !");
		return(False);
        }

        // begin to read items.
	caddr_t p=pFileMem;
	while(p<pFileMem+stStat.st_size && iLength<iCapacity)
	{
		WordItem *pWordItem=new WordItem(p,p+strlen(p)+1);
		aWordLib[iLength++]=pWordItem;
		p+=strlen(p)+1;
		p+=strlen(p)+1;
        }

	close(fd);

        return(True);
}

/********************************************************************/
// to find the index of the word.
// if not found,return the index with which some similar words could be found.
// return True if found,else return False.

Boolean Lib::bLookup(const char* sWord,int *pIndex)
{
	assert(length()!=0);

	int iThisIndex;
	int iFrom=0;
	int iTo=length()-1;
	Boolean bFound=False;
	while( !bFound && iFrom<=iTo )
	{
		iThisIndex=(iFrom+iTo)>>1;
		if(*aWordLib[iThisIndex]==sWord)
		{
			bFound=True;
		}
		else if(*aWordLib[iThisIndex]<sWord)
		{
			iFrom=iThisIndex+1;
		}
		else 
		{
			iTo=iThisIndex-1;
		}
	}

	*pIndex=iThisIndex;

	return(bFound);
}

/********************************************************************/
Boolean Lib::bLookupWithRule(const MSARegExp &rule,int *aIndex,int iBuffLen)
{
	int iIndexCount=0;
	int i;
	for(i=0;i<length() && iIndexCount<iBuffLen-1;i++)
	{
		if(rule.bIsEntireMatch(aWordLib[i]->sGetWord()))
		{
			aIndex[iIndexCount++]=i;
		}
	}
	aIndex[iIndexCount]=-1; // -1 is the end.

        return(iIndexCount>0);
}

/********************************************************************/
WordItem &Lib::operator[](int i)
{
	return(*aWordLib[i]); 
}

//===================================================================
FloatWin::FloatWin()
{
	wLabel=NULL;
	wShell=NULL;
	bMapped=False;
	return;
}

/********************************************************************/
FloatWin::~FloatWin()
{
	if(wShell!=NULL)
	{
		XtDestroyWidget(wShell);
	}
	return;
}

/********************************************************************/
void FloatWin::vSetBackground(Pixmap pixBack)
{
	XtVaSetValues( wLabel,
		XmNbackgroundPixmap,pixBack,
		NULL);
	return;
}

/********************************************************************/
void FloatWin::vShow(const char* sMessage)
{
	XmString xmsString=xmsCreateChinese(sMessage);
	vShow(xmsString);
	XmStringFree(xmsString);
	return;
}

/********************************************************************/
void FloatWin::vShow(const XmString xmsMessage)
{
	vPopdown();
	XtVaSetValues(wLabel,
		XmNlabelString,xmsMessage,
		NULL);
	vPopup();
	return;
}

/********************************************************************/
void FloatWin::vRecordXY()
{
	vGetPointerXY(XtDisplay(wShell),iRecordX,iRecordY);
	return;
}

/********************************************************************/
void FloatWin::vGoToRecordedXY()
{
	vGoTo(iRecordX,iRecordY);
	return;
}

/********************************************************************/
void FloatWin::vGoTo(int iX,int iY)
{
	int iRealX=iX+OFFSETX;
	int iRealY=iY+OFFSETY;

	Screen* screen=XtScreen(wShell);
	Dimension iScreenWidth=WidthOfScreen(screen);
	Dimension iScreenHeight=HeightOfScreen(screen);

	Dimension iWinWidth,iWinHeight;
	XtVaGetValues(wShell,
		XmNwidth,&iWinWidth,
		XmNheight,&iWinHeight,
		NULL);

	if(iRealX+iWinWidth>iScreenWidth) iRealX=iScreenWidth-iWinWidth;
	if(iRealY+iWinHeight>iScreenHeight) iRealY=iScreenHeight-iWinHeight;

	XtVaSetValues(wShell,
		XmNx,iRealX,
		XmNy,iRealY,
		NULL);
	
	return;
}

/********************************************************************/
Widget FloatWin::wCreate(Widget wParent)
{
        wShell=XtVaCreateManagedWidget("floatwin",
                xmDialogShellWidgetClass,wParent,
		XmNmappedWhenManaged,False,
		XmNoverrideRedirect,True,
		NULL);

        wLabel=XtVaCreateManagedWidget("floatlabel",
                xmLabelWidgetClass,wShell,
		XmNalignment,XmALIGNMENT_BEGINNING,
		XmNmarginTop,3,
		XmNmarginLeft,3,
		XmNmarginRight,3,
		XmNmarginBottom,2,
                NULL);

	XtAppAddTimeOut(XtWidgetToApplicationContext(wShell),
		FLOAT_TIMEOUT,vTimeOutCallback,this);

	return(wShell);
}

/********************************************************************/
void FloatWin::vTimeOutCallback(XtPointer thisObj,XtIntervalId *)
{
	((FloatWin*)thisObj)->vTimeOut();
        return;
}

/********************************************************************/
void FloatWin::vTimeOut()
{
	if(bMapped)
	{
		int iCurrentX,iCurrentY;
		vGetPointerXY(XtDisplay(wShell),iCurrentX,iCurrentY);
		if(abs(iCurrentX-iRecordX)>DISAPPEAR_DISTANCE || 
			abs(iCurrentY-iRecordY)>DISAPPEAR_DISTANCE)
		{
			vPopdown();
		}
	}

	XtAppAddTimeOut(XtWidgetToApplicationContext(wShell),
		FLOAT_TIMEOUT,vTimeOutCallback,this);

	return;
}

/********************************************************************/
void FloatWin::vPopup()
{
	vRecordXY();
	XtManageChild(wLabel);
	vGoToRecordedXY(); // must be here (after XtManageChild).
	XMapRaised(XtDisplay(wShell),XtWindow(wShell));
	XFlush(XtDisplay(wShell));
	bMapped=True;
	return;
}

/********************************************************************/
void FloatWin::vPopdown()
{
	XtUnmapWidget(wShell);
	XtUnmanageChild(wLabel);
	bMapped=False;
	return;
}

//===================================================================
HistoryList::HistoryList(AppCore* pAppCore)
{
	poAppCore=pAppCore;
	return;
}

/********************************************************************/
Widget HistoryList::wCreate(Widget wParent)
{
        wList=XtVaCreateWidget("list",
                xmListWidgetClass,wParent,
		XmNselectionPolicy,XmSINGLE_SELECT,
                XmNvisibleItemCount,1,
		XmNtraversalOn,False,
                NULL);
	XtAddCallback(wList,XmNsingleSelectionCallback,vChooseCallback,this);
	XtAddEventHandler(wList,ButtonReleaseMask|ButtonPressMask,False,
		vButtonEventCallback,this);

	return(wList);
}

/********************************************************************/
void HistoryList::vChooseCallback(Widget,XtPointer thisObj,XtPointer cbs)
{
	XmListCallbackStruct *pCbs=(XmListCallbackStruct *)cbs;
	((HistoryList*)thisObj)->vChoose(pCbs->item);
	return;
}

/********************************************************************/
void HistoryList::vChoose(XmString xmsWord)
{
	char *text;
	XmStringGetLtoR(xmsWord,XmSTRING_DEFAULT_CHARSET,&text);
	poAppCore->vHistoryChoose(text);
	XtFree(text);
	vPopdown();
	return;
}

/********************************************************************/
void HistoryList::vButtonEventCallback(Widget ,XtPointer thisObj,XEvent* ,
	Boolean* continue_to)
{
	((HistoryList*)thisObj)->vButtonEvent(continue_to);
	return;
}

/********************************************************************/
void HistoryList::vButtonEvent(Boolean* continue_to)
{
	Window root,child;
	int rootx,rooty,winx,winy;
	unsigned int buttons;

	XQueryPointer(XtDisplay(wList),XtWindow(XtParent(wList)),&root,&child,
		&rootx,&rooty,&winx,&winy,&buttons);
	if(child!=XtWindow(wList))
	{
		*continue_to=False;
		vPopdown();
	}

	return;
}

/********************************************************************/
void HistoryList::vPopup()
{
	int iVisibleNum;
	if(iLength()==0)
	{
		iVisibleNum=1;
	}
	else
	{
		iVisibleNum=iLength();
	}

	XtVaSetValues(wList,
		XmNvisibleItemCount,iVisibleNum,
		NULL);

	XtManageChild(wList);
	XRaiseWindow(XtDisplay(wList),XtWindow(wList));
	XtGrabPointer(wList,False,ButtonPressMask|ButtonReleaseMask,
		GrabModeAsync,GrabModeAsync,None,None,CurrentTime);
	return;
}

/********************************************************************/
void HistoryList::vPopdown()
{
	XtUngrabPointer(wList,CurrentTime);
	XtUnmanageChild(wList);
	return;
}

/********************************************************************/
void HistoryList::vToggle()
{
	if(XtIsManaged(wList))
	{
		vPopdown();
	}
	else
	{
		vPopup();
	}

	return;
}

/********************************************************************/
int HistoryList::iVisibleCount()
{
	int iCount;
	XtVaGetValues(wList,
		XmNvisibleItemCount,&iCount,
		NULL);
	return(iCount);
}

/********************************************************************/
int HistoryList::iLength()
{
	int iCount;
	XtVaGetValues(wList,
		XmNitemCount,&iCount,
		NULL);
	return(iCount);
}

/********************************************************************/
void HistoryList::vInsert(const char* sNewItem)
{
	if(iLength()>=MAX_HIS_NUM) XmListDeletePos(wList,0);

	XmString xmsItem=XmStringCreateSimple((char *)sNewItem);
	if(!XmListItemExists(wList,xmsItem))
	{
		XmListAddItem(wList,xmsItem,1);
	}
	XmStringFree(xmsItem);
	
	return;
}

//===================================================================
Widget AD::wCreate(Widget wParent)
{
	wForm=XtVaCreateWidget("messageform",
                xmFormWidgetClass,wParent,
		XmNshadowThickness,0,
		NULL);

	wJoyo=XtVaCreateManagedWidget("linux.joyo.com",
                xmPushButtonWidgetClass,wForm,
		XmNhighlightThickness,0,
		XmNshadowThickness,0,
                NULL);
	wWuhan=XtVaCreateManagedWidget("www.wuhan.net.cn",
                xmPushButtonWidgetClass,wForm,
		XmNhighlightThickness,0,
		XmNshadowThickness,0,
                NULL);
	wSina=XtVaCreateManagedWidget("www.sina.com.cn",
                xmPushButtonWidgetClass,wForm,
		XmNhighlightThickness,0,
		XmNshadowThickness,0,
                NULL);
	wChinabyte=XtVaCreateManagedWidget("www.chinabyte.com",
                xmPushButtonWidgetClass,wForm,
		XmNhighlightThickness,0,
		XmNshadowThickness,0,
                NULL);
	wWri=XtVaCreateManagedWidget("www.wri.com.cn",
                xmPushButtonWidgetClass,wForm,
		XmNhighlightThickness,0,
		XmNshadowThickness,0,
                NULL);
	XtAddCallback(wJoyo,XmNactivateCallback,vCallNetscape,this);
	XtAddCallback(wWuhan,XmNactivateCallback,vCallNetscape,this);
	XtAddCallback(wSina,XmNactivateCallback,vCallNetscape,this);
	XtAddCallback(wChinabyte,XmNactivateCallback,vCallNetscape,this);
	XtAddCallback(wWri,XmNactivateCallback,vCallNetscape,this);

	XtVaSetValues(wJoyo,
		XmNtopAttachment,XmATTACH_FORM,
		XmNleftAttachment,XmATTACH_FORM,
		NULL);
	XtVaSetValues(wSina,
		XmNtopAttachment,XmATTACH_FORM,
		XmNleftAttachment,XmATTACH_WIDGET,
		XmNleftWidget,wJoyo,
		NULL);
	XtVaSetValues(wWuhan,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,wJoyo,
		XmNleftAttachment,XmATTACH_FORM,
		NULL);
	XtVaSetValues(wChinabyte,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,wSina,
		XmNleftAttachment,XmATTACH_WIDGET,
		XmNleftWidget,wWuhan,
		NULL);
	XtVaSetValues(wWri,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,wSina,
		XmNleftAttachment,XmATTACH_WIDGET,
		XmNleftWidget,wChinabyte,
		NULL);

	return(wForm);
}

/********************************************************************/
void AD::vCallNetscape(Widget w,XtPointer,XtPointer)
{
	char sCommand[256];
	strcpy(sCommand,"netscape http://");
	strcat(sCommand,XtName(w));
	strcat(sCommand," &");
	system(sCommand);
	return;
}

/********************************************************************/
void AD::vSetPixmap()
{
	Pixmap pixJoyo=pixForceGetPixmap(wJoyo,JOYOLINUX_S);
	if(pixJoyo!=XmUNSPECIFIED_PIXMAP)
	{
		XtVaSetValues(wJoyo,
			XmNlabelPixmap,pixJoyo,
			XmNlabelType,XmPIXMAP,
			NULL);
	}

	Pixmap pixWuhan=pixForceGetPixmap(wWuhan,WUHAN_S);
	if(pixWuhan!=XmUNSPECIFIED_PIXMAP)
	{
		XtVaSetValues(wWuhan,
			XmNlabelPixmap,pixWuhan,
			XmNlabelType,XmPIXMAP,
			NULL);
	}

	Pixmap pixSina=pixForceGetPixmap(wSina,SINA_S);
	if(pixSina!=XmUNSPECIFIED_PIXMAP)
	{
		XtVaSetValues(wSina,
			XmNlabelPixmap,pixSina,
			XmNlabelType,XmPIXMAP,
			NULL);
	}

	Pixmap pixChinabyte=pixForceGetPixmap(wChinabyte,CHINABYTE_S);
	if(pixChinabyte!=XmUNSPECIFIED_PIXMAP)
	{
		XtVaSetValues(wChinabyte,
			XmNlabelPixmap,pixChinabyte,
			XmNlabelType,XmPIXMAP,
			NULL);
	}

	Pixmap pixWri=pixForceGetPixmap(wWri,WRI_S);
	if(pixWri!=XmUNSPECIFIED_PIXMAP)
	{
		XtVaSetValues(wWri,
			XmNlabelPixmap,pixWri,
			XmNlabelType,XmPIXMAP,
			NULL);
	}

	return;
}

/********************************************************************/
void AD::vShow()
{
	XtManageChild(wForm);
	XMapRaised(XtDisplay(wForm),XtWindow(wForm));
	return;
}

/********************************************************************/
void AD::vHide()
{
	XtUnmanageChild(wForm);
	return;
}

//===================================================================
UserWin::UserWin(AppCore *pAppCore):oHistoryList(pAppCore)
{
	poAppCore=pAppCore;
	return;
}

/********************************************************************/
Widget UserWin::wCreate(Widget wParent)
{
	Widget wForm=XtVaCreateManagedWidget("messageform",
                xmFormWidgetClass,wParent,
		XmNmarginWidth,2,
		XmNmarginHeight,2,
		XmNshadowType,XmSHADOW_OUT,
		XmNshadowThickness,0,
		XmNverticalSpacing,2,
		NULL);

	Widget wHistoryList=oHistoryList.wCreate(wForm);

	Widget wTextForm=XtVaCreateManagedWidget("textform",
                xmFormWidgetClass,wForm,
		XmNshadowThickness,0,
		NULL);

	wWordText=XtVaCreateManagedWidget("wordtext",
                xmTextFieldWidgetClass,wTextForm,
		XmNhighlightThickness,1,
                NULL);
      	XtAddCallback(wWordText,XmNvalueChangedCallback,
		vWordChangeCallback,this);
	XtAddCallback(wWordText,XmNactivateCallback,
		vEnterWordCallback,this);

	wArrow=XtVaCreateManagedWidget("arrow",
		xmArrowButtonWidgetClass,wTextForm,
		XmNarrowDirection,XmARROW_DOWN,
		XmNhighlightThickness,0,
		XmNtraversalOn,False,
		NULL);
	XtAddCallback(wArrow,XmNactivateCallback,vArrowCallback,this);

	// set position in text form
	XtVaSetValues(wWordText,
		XmNtopAttachment,XmATTACH_FORM,
		XmNleftAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_WIDGET,
		XmNrightWidget,wArrow,
		XmNbottomAttachment,XmATTACH_FORM,
		NULL);
	XtVaSetValues(wArrow,
		XmNtopAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		XmNbottomAttachment,XmATTACH_FORM,
		NULL);

	Widget wSeparator=XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass,wForm,
		XmNheight,3,
		NULL);

	Widget wMeaningWin=wCreateMeaningWin(wForm);
	Widget wADWin=oAD.wCreate(wForm);

	// set position
	XtVaSetValues(wTextForm,
		XmNtopAttachment,XmATTACH_FORM,
		XmNleftAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		NULL);
	XtVaSetValues(wSeparator,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,wTextForm,
		XmNleftAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		NULL);
	XtVaSetValues(wMeaningWin,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,wSeparator,
	//	XmNtopWidget,wWordText,
		XmNleftAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		XmNbottomAttachment,XmATTACH_FORM,
		NULL);
	XtVaSetValues(wADWin,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,wSeparator,
		XmNleftAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		XmNbottomAttachment,XmATTACH_FORM,
		NULL);

	// History list position
	XtVaSetValues(wHistoryList,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,wTextForm,
		XmNleftAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		NULL);

	return(wForm);
}

/********************************************************************/
Widget UserWin::wCreateMeaningWin(Widget wParent)
{
	Widget wForm=XtVaCreateManagedWidget("messageform",
                xmFormWidgetClass,wParent,
		XmNmarginWidth,0,
		XmNmarginHeight,0,
		XmNshadowType,XmSHADOW_OUT,
		XmNshadowThickness,2,
		// XmNverticalSpacing,2,
		NULL);

	wWordLabel=XtVaCreateManagedWidget("wordlabel",
		xmLabelWidgetClass,wForm,
		XmNmarginWidth,15,
		XmNalignment,XmALIGNMENT_BEGINNING,
		NULL);

	Widget wScrolledWin=XtVaCreateManagedWidget("scrolledWin",
                xmScrolledWindowWidgetClass,wForm,
		XmNscrollingPolicy,XmAUTOMATIC,
                NULL);

	wMeaning=XtVaCreateManagedWidget("meaning",
               // xmLabelGadgetClass,wScrolledWin,
                xmLabelWidgetClass,wScrolledWin,
		XmNmarginTop,10,
		XmNmarginLeft,10,
		XmNmarginRight,10,
		XmNmarginBottom,10,
		XmNalignment,XmALIGNMENT_BEGINNING,
                NULL);

	XtVaSetValues(wWordLabel,
		XmNtopAttachment,XmATTACH_FORM,
		XmNleftAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		NULL);
	XtVaSetValues(wScrolledWin,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,wWordLabel,
		XmNleftAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		XmNbottomAttachment,XmATTACH_FORM,
		NULL);

	return(wForm);
}

/********************************************************************/
Boolean UserWin::bTextSelected()
{
	XmTextPosition left,right;
	Boolean bSelected;
	bSelected=XmTextFieldGetSelectionPosition(wWordText,&left,&right);
	return(bSelected);
}

/********************************************************************/
void UserWin::vSetTextSelection()
{
	int iLastPosition=XmTextFieldGetLastPosition(wWordText);
	XmTextFieldSetSelection(wWordText,0,iLastPosition,CurrentTime);
	return;
}

/********************************************************************/
void UserWin::vSetADPixmap()
{
	oAD.vSetPixmap();
	return;
}

/********************************************************************/
void UserWin::vADShow()
{
	oAD.vShow();
	return;
}

/********************************************************************/
void UserWin::vADHide()
{
	oAD.vHide();
	return;
}

/********************************************************************/
void UserWin::vActivateText()
{
	XmProcessTraversal(wWordText,XmTRAVERSE_CURRENT);
	return;
}

/********************************************************************/
void UserWin::vSetBackground(Pixmap pixBack)
{
	XtVaSetValues(wWordLabel,
		XmNbackgroundPixmap,pixBack,
		NULL);

	XtVaSetValues(XtParent(XtParent(wWordText)),
		XmNbackgroundPixmap,pixBack,
		NULL);

	Widget wHScrollBar,wVScrollBar,wClipWin;
	Widget wScrolledWin=XtParent(XtParent(wMeaning));
	XtVaGetValues( wScrolledWin,
		XmNclipWindow,&wClipWin,
		XmNhorizontalScrollBar,&wHScrollBar,
		XmNverticalScrollBar,&wVScrollBar,
		NULL);
	XtVaSetValues(wScrolledWin,
		XmNbackgroundPixmap,pixBack,
		NULL);
	XtVaSetValues(wHScrollBar,
		XmNbackgroundPixmap,pixBack,
		NULL);
	XtVaSetValues(wVScrollBar,
		XmNbackgroundPixmap,pixBack,
		NULL);
	XtVaSetValues(wArrow,
		XmNbackgroundPixmap,pixBack,
		NULL);
/*
	XtVaSetValues(wClipWin,
		XmNbackgroundPixmap,pixBack,
		NULL);
*/

	return;
}

/********************************************************************/
void UserWin::vInsertHisList(const char* sWord)
{
	oHistoryList.vInsert(sWord);
	return;
}

/********************************************************************/
void UserWin::vToggleHisList()
{
	oHistoryList.vToggle();
	return;
}

/********************************************************************/
void UserWin::vShowToLabel(const char* sWord)
{
	XmString xmsLabelString=xmsCreateChinese(sWord);
	XtVaSetValues(wWordLabel,
		XmNlabelString,xmsLabelString,
		NULL);
	XmStringFree(xmsLabelString);
	return;
}

/********************************************************************/
void UserWin::vShowToLabel(XmString xmsLabelString)
{
	oAD.vHide();
	XtVaSetValues(wWordLabel,
		XmNlabelString,xmsLabelString,
		NULL);
	return;
}

/********************************************************************/
void UserWin::vShowToMeaningWin(const char *sMessage)
{
	//XClearWindow(XtDisplay(wMeaning),XtWindow(wMeaning));
	oAD.vHide();
	XmString xmsString=xmsCreateChinese(sMessage);
	XtVaSetValues(wMeaning,
		XmNlabelString,xmsString,
		NULL);
	XmStringFree(xmsString);
	return;
}

/********************************************************************/
void UserWin::vPutToText(const char *sWord)
{
	assert(sWord!=NULL);
	if(sWord==NULL) return;

	XmTextFieldSetString(wWordText,(char *)sWord);

	return;
}

/********************************************************************/
void UserWin::vClearMeaningWin()
{
	vShowToLabel("  ");
	vShowToMeaningWin(" ");
	return;
}

/********************************************************************/
void UserWin::vClearText()
{
	XmTextFieldSetString(wWordText,"");
	return;
}

/********************************************************************/
void UserWin::vArrowCallback(Widget,XtPointer thisObj,XtPointer )
{
        ((UserWin *)thisObj)->vArrowActivate();
        return;
}

/********************************************************************/
void UserWin::vArrowActivate()
{
	poAppCore->vArrowActivate();
	return;
}

/********************************************************************/
void UserWin::vEnterWordCallback(Widget,XtPointer thisObj,XtPointer )
{
        ((UserWin *)thisObj)->vEnterWord();
        return;
}

/********************************************************************/
void UserWin::vEnterWord()
{
        char *sWord=XmTextFieldGetString(wWordText);
	if(sWord[0]!='\0')
	{
		poAppCore->vUserWinEnterWord(sWord);
	}
	XtFree(sWord);
	return;
}

/********************************************************************/
void UserWin::vWordChangeCallback(Widget,XtPointer thisObj,XtPointer )
{
        ((UserWin *)thisObj)->vWordChange();
        return;
}

/********************************************************************/
void UserWin::vWordChange()
{
        char *sWord=XmTextFieldGetString(wWordText);
	if(sWord[0]!='\0')
	{
		poAppCore->vUserWinWordChange(sWord);
	}
	else
	{
		oAD.vShow();
	}

	XtFree(sWord);
	return;
}

//===================================================================
Libs::Libs()
{
	return;
}

/********************************************************************/
int Libs::iLength()
{
	return(oLib.length());
}

/********************************************************************/
Boolean Libs::bGetWordsWithRule(const char* sWord,int* aiIndexes,int iLen)
{
        // change rule to regular exp.
	char sRule[MAX_STR_LEN+1];
        if(!bMakeRule(sWord,sRule,MAX_STR_LEN+1))
	{
                strcpy(sErrorMessage,RULE_ERR_S);
                return(False);
	}

	MSARegExp rule(sRule);
        if(rule.iStatus()!=MSARegExp::OK)
	{
                strcpy(sErrorMessage,RULE_ERR_S);
                return(False);
	}

        if(!oLib.bLookupWithRule(rule,aiIndexes,iLen))
        {
                strcpy(sErrorMessage,NOTFOUND_S);
                return(False);
        }

        return(True);
}

/********************************************************************/
Boolean Libs::bGetLib()
{
	char sHomeDirFile[MAX_STR_LEN+1];
	strcpy(sHomeDirFile,sHomeDir);
	strcat(sHomeDirFile,DICFILE_S);
	Boolean bGetLibOK=oLib.bGetLib(sHomeDirFile);

	strcpy(sHomeDirFile,sHomeDir);
	strcat(sHomeDirFile,YBFILE_S);
	Boolean bGetYBOK=oYBLib.bGetLib(sHomeDirFile);

	return(bGetLibOK && bGetYBOK);
}

/********************************************************************/
const WordItem* Libs::poGetWordItem(int iIndex)
{
	return(&oLib[iIndex]);
}

/********************************************************************/
Boolean Libs::bSimpleGetWord(const char* sWord,int& iWordIndex)
{
	int iIndex;
	int iSimilarIndex;
	Boolean bFound=False;
	if(oLib.bLookup(sWord,&iIndex))
	{
		bFound=True;
	}
	iSimilarIndex=iIndex;

	// If not Found , try other status of sWord.

	char sNewWord[MAX_STR_LEN+1];
	int iWordLen=strlen(sWord);

	//cut one char "s" or "d"
	strcpy(sNewWord,sWord);
	if(!bFound && iWordLen>1 && 
		(sWord[iWordLen-1]=='s' ||
		!strncasecmp(&sWord[iWordLen-2],"ed",2)) )
	{
		sNewWord[iWordLen-1]='\0'; // cut "s" or "d"
		if(oLib.bLookup(sNewWord,&iIndex))
		{
			bFound=True;
		}
	}

	//cut "ing"
	strcpy(sNewWord,sWord);
	if(!bFound && iWordLen>3 && 
		!strncasecmp(&sWord[iWordLen-3],"ing",3) )
	{
		sNewWord[iWordLen-3]='\0';
		if(oLib.bLookup(sNewWord,&iIndex))
		{
			bFound=True;
		}

		if(!bFound)
		{
			strcat(sNewWord,"e"); // add a char "e"
			if(oLib.bLookup(sNewWord,&iIndex))
			{
				bFound=True;
			}
		}
	}

	//cut two char "es" or "ed"
	strcpy(sNewWord,sWord);
	if(!bFound && iWordLen>3 &&
		(!strncasecmp(&sWord[iWordLen-2],"ed",2) ||
		!strncasecmp(&sWord[iWordLen-3],"ses",3) ||
		!strncasecmp(&sWord[iWordLen-3],"oes",3) ||
		!strncasecmp(&sWord[iWordLen-3],"xes",3)) )
	{
		sNewWord[iWordLen-2]='\0';
		if(oLib.bLookup(sNewWord,&iIndex))
		{
			bFound=True;
		}
	}

	// cut "ies" , add "y".
	strcpy(sNewWord,sWord);
	if(!bFound && iWordLen>3 && 
		!strncasecmp(&sWord[iWordLen-3],"ies",3) )
	{
		sNewWord[iWordLen-3]='\0';
		strcat(sNewWord,"y"); // add a char "y"
		if(oLib.bLookup(sNewWord,&iIndex))
		{
			bFound=True;
		}
	}

	if(bFound)
	{
		iWordIndex=iIndex;
	}
	else
	{
		iWordIndex=iSimilarIndex;
		strcpy(sErrorMessage,NOTFOUND_S);
	}

        return(bFound);
}

/********************************************************************/
// change "*" to "[!-~]*" and "?" to "[!-~]"

Boolean Libs::bMakeRule(const char* sWord,char* sRule,int iLength)
{
        char *sOneAnyChar="[!-~]";
        char *sAnyChar="[!-~]*";
	int iOneAnyCharLen=strlen(sOneAnyChar);
	int iAnyCharLen=strlen(sAnyChar);

	int iUseLen=0;
	Boolean bRuleOK=True;
	int i;
	for(i=0;sWord[i]!='\0' && bRuleOK;i++)
	{
		const char* sAddString;
		int iAddLen;

		if(sWord[i]=='?')
		{
			sAddString=sOneAnyChar;
			iAddLen=iOneAnyCharLen;
		}
		else if(sWord[i]=='*')
		{
			sAddString=sAnyChar;
			iAddLen=iAnyCharLen;
		}
		else
		{
			sAddString=sWord+i;
			iAddLen=1;
		}

		if(iAddLen+iUseLen<=iLength-1)
		{
			memcpy(sRule+iUseLen,sAddString,iAddLen);
			iUseLen+=iAddLen;
		}
		else
		{
			bRuleOK=False;
		}
	}
	sRule[iUseLen]='\0';

        return(bRuleOK);
}

/********************************************************************/
const char* Libs::sGetYB(const char* sWord)
{
	int iIndex;
	const char* sYB=NULL;
	if(oYBLib.bLookup(sWord,&iIndex))
	{
		sYB=oYBLib[iIndex].sGetMeaning();
	}

	return(sYB);
}

//===================================================================
Selection::Selection(AppCore* pAppCore)
{
	poAppCore=pAppCore;
	bSelectionReach=True;
	iSelTimeCount=0;
	sLastClipWord[0]='\0';
	return;
}

/********************************************************************/
Boolean Selection::bEnable()
{
	return(poAppCore->bScreenFetchEnable());
}

/********************************************************************/
void Selection::vStart(Widget wToUse)
{
	w=wToUse;
	XtAppAddTimeOut(XtWidgetToApplicationContext(w),INTERVAL,
		vTimeOutCallback,this);
	return;
}

/********************************************************************/
void Selection::vTimeOutCallback(XtPointer thisObj,XtIntervalId *)
{
	((Selection *)thisObj)->vTimeOut();
        return;
}

/********************************************************************/
void Selection::vTimeOut()
{
	if(bEnable()) 
	{
		vRequireSelection();
	}

	XtAppAddTimeOut(XtWidgetToApplicationContext(w),INTERVAL,
		vTimeOutCallback,this);

	return;
}

/********************************************************************/
void Selection::vRequireSelection()
{
	if(!bSelectionReach && iSelTimeCount<MAX_SELTIME_COUNT)
	{
		iSelTimeCount++;
		return;
	}

	XtGetSelectionValue(w,XA_PRIMARY,XA_STRING,vSelectionCallback,
		this,CurrentTime);
	bSelectionReach=False;
	iSelTimeCount=0;

	return;
}

/********************************************************************/
void Selection::vSelectionCallback(Widget ,XtPointer thisObj,Atom *,
	Atom *,XtPointer value,unsigned long *length,int *)
{
	((Selection *)thisObj)->vSelectionReceived((char*)value,(int)*length);
	return;
}

/********************************************************************/
void Selection::vSelectionReceived(char* sValue,int iLength)
{
	bSelectionReach=True;

	if(iLength==0) 
	{
		sLastClipWord[0]='\0';
		return;
	}

	char sToken[MAX_STR_LEN+1];

	int iRealLen;
	if(iLength<MAX_STR_LEN) iRealLen=iLength;	
	else		iRealLen=MAX_STR_LEN;

	memcpy(sToken,sValue,iRealLen);
	sToken[iRealLen]='\0';

	MSARegExp reg("[A-Za-z_]+");
	assert(reg.iStatus()==MSARegExp::OK);

	if(reg.bIsMatch(sToken,sToken,MAX_STR_LEN+1) && 
		strcmp(sToken,sLastClipWord))
	{
		strcpy(sLastClipWord,sToken);
		poAppCore->vWordSelected(sToken);
	}

	return;
}

//===================================================================
ListWin::ListWin(AppCore* pAppCore)
{
	poAppCore=pAppCore;
	return;
}

/********************************************************************/
Widget ListWin::wCreate(Widget wParent)
{
	Widget wScrolledWin=XtVaCreateManagedWidget("scrolledlist",
                xmScrolledWindowWidgetClass,wParent,
                NULL);
        wList=XtVaCreateManagedWidget("list",
                xmListWidgetClass,wScrolledWin,
		XmNselectionPolicy,XmSINGLE_SELECT,
                XmNvisibleItemCount,8,
		XmNtraversalOn,False,
                NULL);
	XtAddCallback(wList,XmNdefaultActionCallback,vClickCallback,this);
	XtAddCallback(wList,XmNsingleSelectionCallback,vChooseCallback,this);

	return(wScrolledWin);
}
	
/********************************************************************/
void ListWin::vSetBackground(Pixmap pixBack)
{
	// this scrolled window has no clip window and horizontal scrollbar.
	Widget wVScrollBar;
	Widget wScrolledWin=XtParent(wList);
	XtVaGetValues( wScrolledWin,
		XmNverticalScrollBar,&wVScrollBar,
		NULL);
	XtVaSetValues(wScrolledWin,
		XmNbackgroundPixmap,pixBack,
		NULL);
	XtVaSetValues(wVScrollBar,
		XmNbackgroundPixmap,pixBack,
		NULL);

	return;
}

/********************************************************************/
void ListWin::vClickCallback(Widget,XtPointer thisObj,XtPointer cbs)
{
	XmListCallbackStruct *pCbs=(XmListCallbackStruct *)cbs;
	((ListWin *)thisObj)->vClick(pCbs->item);
	return;
}

/********************************************************************/
void ListWin::vClick(XmString xmsWord)
{
	char *text;
	XmStringGetLtoR(xmsWord,XmSTRING_DEFAULT_CHARSET,&text);
	poAppCore->vListClick(text);
	XtFree(text);
        return;
}

/********************************************************************/
void ListWin::vChooseCallback(Widget,XtPointer thisObj,XtPointer cbs)
{
	XmListCallbackStruct *pCbs=(XmListCallbackStruct *)cbs;
	((ListWin *)thisObj)->vChoose(pCbs->item);
	return;
}

/********************************************************************/
void ListWin::vChoose(XmString xmsWord)
{
	char *text;
	XmStringGetLtoR(xmsWord,XmSTRING_DEFAULT_CHARSET,&text);
	poAppCore->vListChoose(text);
	XtFree(text);
        return;
}

/********************************************************************/
void ListWin::vInsertFirst(const char *sItem)
{
	XmString xmsItem=XmStringCreateSimple((char *)sItem);
	XmListAddItem(wList,xmsItem,1);
	XmStringFree(xmsItem);
	return;
}

/********************************************************************/
void ListWin::vInsertLast(const char *sItem)
{
	XmString xmsItem=XmStringCreateSimple((char *)sItem);
	XmListAddItem(wList,xmsItem,0);
	XmStringFree(xmsItem);
	return;
}

/********************************************************************/
void ListWin::vDeleteFirst(int iCount)
{
	XmListDeleteItemsPos(wList,iCount,1);
	return;
}

/********************************************************************/
void ListWin::vDeleteLast(int iCount)
{
	int iFrom=iLength()-iCount+1;
	if(iFrom>1)
	{
		XmListDeleteItemsPos(wList,iCount,iFrom);
	}
	return;
}

/********************************************************************/
int ListWin::iLength()
{
	int iCount;
	XtVaGetValues(wList,
		XmNitemCount,&iCount,
		NULL);
	return(iCount);
}

/********************************************************************/
int ListWin::iVisibleCount()
{
	int iCount;
	XtVaGetValues(wList,
		XmNvisibleItemCount,&iCount,
		NULL);
	return(iCount);
}

/********************************************************************/
void ListWin::vClear()
{
	XmListDeleteAllItems(wList);
	return;
}

//===================================================================
CfgWin::CfgWin(AppCore *pAppCore)
{
	poAppCore=pAppCore;
	return;
}

/********************************************************************/
Widget CfgWin::wCreate(Widget wParent)
{
	Widget wForm=XtVaCreateManagedWidget("toggleroom",
                xmFormWidgetClass,wParent,
		XmNfractionBase,8,
		NULL);

	XmString xmsUseRule=xmsCreateChinese(RULE_MATCH_S);
	wUseRuleToggle=XtVaCreateManagedWidget("useruletoggle",
                xmToggleButtonWidgetClass,wForm,
		XmNlabelString,xmsUseRule,
		XmNindicatorType,XmONE_OF_MANY,
		XmNalignment,XmALIGNMENT_BEGINNING,
		XmNhighlightThickness,0,
		XmNtraversalOn,False,
                NULL);
	XmStringFree(xmsUseRule);

	XmString xmsScanClipBoard=xmsCreateChinese(SCAN_S);
	wScanClipBoardToggle=XtVaCreateManagedWidget("scanclipboardtoggle",
                xmToggleButtonWidgetClass,wForm,
		XmNlabelString,xmsScanClipBoard,
		XmNindicatorType,XmONE_OF_MANY,
		XmNalignment,XmALIGNMENT_BEGINNING,
		XmNhighlightThickness,0,
		XmNtraversalOn,False,
                NULL);
	XmStringFree(xmsScanClipBoard);

	XmString xmsHelp=xmsCreateChinese(HELP_S);
	wHelpButton=XtVaCreateManagedWidget("helpbutton",
                xmPushButtonWidgetClass,wForm,
		XmNlabelString,xmsHelp,
		XmNshadowThickness,0,
		XmNhighlightThickness,0,
		XmNmarginHeight,0,
		XmNtraversalOn,False,
                NULL);
	XmStringFree(xmsHelp);
	XtAddCallback(wHelpButton,XmNactivateCallback,vHelpCallback,this);

	XmString xmsLast=xmsCreateChinese(LAST_S);
	wLastButton=XtVaCreateManagedWidget("lastbutton",
                xmPushButtonWidgetClass,wForm,
		XmNlabelString,xmsLast,
		XmNshadowThickness,0,
		XmNhighlightThickness,0,
		XmNmarginHeight,0,
		XmNtraversalOn,False,
                NULL);
	XmStringFree(xmsLast);
	XtAddCallback(wLastButton,XmNactivateCallback,vLastCallback,this);

	XmString xmsNext=xmsCreateChinese(NEXT_S);
	wNextButton=XtVaCreateManagedWidget("nextbutton",
                xmPushButtonWidgetClass,wForm,
		XmNlabelString,xmsNext,
		XmNshadowThickness,0,
		XmNhighlightThickness,0,
		XmNmarginHeight,0,
		XmNtraversalOn,False,
                NULL);
	XmStringFree(xmsNext);
	XtAddCallback(wNextButton,XmNactivateCallback,vNextCallback,this);

	XmString xmsExit=xmsCreateChinese(EXIT_S);
	wExitButton=XtVaCreateManagedWidget("exitbutton",
                xmPushButtonWidgetClass,wForm,
		XmNlabelString,xmsExit,
		XmNshadowThickness,0,
		XmNhighlightThickness,0,
		XmNmarginHeight,0,
		XmNtraversalOn,False,
                NULL);
	XmStringFree(xmsExit);
	XtAddCallback(wExitButton,XmNactivateCallback,vExitCallback,this);

	// set position
        XtVaSetValues(wUseRuleToggle,
                XmNtopAttachment,XmATTACH_FORM,
                XmNleftAttachment,XmATTACH_FORM,
                XmNrightAttachment,XmATTACH_POSITION,
                XmNrightPosition,2,
                XmNbottomAttachment,XmATTACH_FORM,
                NULL);
        XtVaSetValues(wScanClipBoardToggle,
                XmNtopAttachment,XmATTACH_FORM,
                XmNleftAttachment,XmATTACH_WIDGET,
                XmNleftWidget,wUseRuleToggle,
                XmNrightAttachment,XmATTACH_POSITION,
                XmNrightPosition,4,
                XmNbottomAttachment,XmATTACH_FORM,
                NULL);
        XtVaSetValues(wHelpButton,
                XmNtopAttachment,XmATTACH_FORM,
                XmNbottomAttachment,XmATTACH_FORM,
                XmNleftAttachment,XmATTACH_POSITION,
                XmNleftPosition,4,
                NULL);
        XtVaSetValues(wLastButton,
                XmNtopAttachment,XmATTACH_FORM,
                XmNbottomAttachment,XmATTACH_FORM,
                XmNleftAttachment,XmATTACH_POSITION,
                XmNleftPosition,5,
                NULL);
        XtVaSetValues(wNextButton,
                XmNtopAttachment,XmATTACH_FORM,
                XmNbottomAttachment,XmATTACH_FORM,
                XmNleftAttachment,XmATTACH_POSITION,
                XmNleftPosition,6,
                NULL);
        XtVaSetValues(wExitButton,
                XmNtopAttachment,XmATTACH_FORM,
                XmNbottomAttachment,XmATTACH_FORM,
                XmNleftAttachment,XmATTACH_POSITION,
                XmNleftPosition,7,
                NULL);

	return(wForm);
}

/********************************************************************/
void CfgWin::vHelpCallback(Widget,XtPointer thisObj,XtPointer)
{
	((CfgWin *)thisObj)->vHelp();
	return;
}

/********************************************************************/
void CfgWin::vHelp()
{
	poAppCore->vShowHelp();
	return;
}

/********************************************************************/
void CfgWin::vLastCallback(Widget,XtPointer thisObj,XtPointer)
{
	((CfgWin *)thisObj)->vLast();
	return;
}

/********************************************************************/
void CfgWin::vLast()
{
	poAppCore->vLast();
	return;
}

/********************************************************************/
void CfgWin::vNextCallback(Widget,XtPointer thisObj,XtPointer)
{
	((CfgWin *)thisObj)->vNext();
	return;
}

/********************************************************************/
void CfgWin::vNext()
{
	poAppCore->vNext();
	return;
}

/********************************************************************/
void CfgWin::vExitCallback(Widget,XtPointer thisObj,XtPointer)
{
	((CfgWin *)thisObj)->vExit();
	return;
}

/********************************************************************/
void CfgWin::vExit()
{
	poAppCore->vQuit();
	return;
}

/********************************************************************/
void CfgWin::vSetButtonPixmap()
{
	Pixmap pixHelp=pixGetPixmap(wHelpButton,HELPIMAGEFILE_S);
	Pixmap pixHelpMask=pixGetBitmap(wHelpButton,HELPMASKFILE_S);
	if(pixHelp!=XmUNSPECIFIED_PIXMAP && pixHelpMask!=XmUNSPECIFIED_PIXMAP)
	{
		XtVaSetValues(wHelpButton,
			XmNlabelPixmap,pixHelp,
			XmNlabelType,XmPIXMAP,
			NULL);
        	XShapeCombineMask(XtDisplay(wHelpButton),XtWindow(wHelpButton),
                	ShapeBounding,0,0,pixHelpMask,ShapeSet);
	}
	else
	{
	//	vShowErrorToTerm("can't get Help pixmap !");
	}

	Pixmap pixExit=pixGetPixmap(wExitButton,EXITIMAGEFILE_S);
	Pixmap pixExitMask=pixGetBitmap(wExitButton,EXITMASKFILE_S);
	if(pixExit!=XmUNSPECIFIED_PIXMAP && pixExitMask!=XmUNSPECIFIED_PIXMAP)
	{
		XtVaSetValues(wExitButton,
			XmNlabelPixmap,pixExit,
			XmNlabelType,XmPIXMAP,
			NULL);
        	XShapeCombineMask(XtDisplay(wExitButton),XtWindow(wExitButton),
                	ShapeBounding,0,0,pixExitMask,ShapeSet);
	}
	else
	{
	//	vShowErrorToTerm("can't get Exit pixmap !");
	}

	Pixmap pixLast=pixGetPixmap(wLastButton,LASTIMAGEFILE_S);
	Pixmap pixLastMask=pixGetBitmap(wLastButton,LASTMASKFILE_S);
	if(pixLast!=XmUNSPECIFIED_PIXMAP && pixLastMask!=XmUNSPECIFIED_PIXMAP)
	{
		XtVaSetValues(wLastButton,
			XmNlabelPixmap,pixLast,
			XmNlabelType,XmPIXMAP,
			NULL);
        	XShapeCombineMask(XtDisplay(wLastButton),XtWindow(wLastButton),
                	ShapeBounding,0,0,pixLastMask,ShapeSet);
	}
	else
	{
	//	vShowErrorToTerm("can't get Last pixmap !");
	}

	Pixmap pixNext=pixGetPixmap(wNextButton,NEXTIMAGEFILE_S);
	Pixmap pixNextMask=pixGetBitmap(wNextButton,NEXTMASKFILE_S);
	if(pixNext!=XmUNSPECIFIED_PIXMAP && pixNextMask!=XmUNSPECIFIED_PIXMAP)
	{
		XtVaSetValues(wNextButton,
			XmNlabelPixmap,pixNext,
			XmNlabelType,XmPIXMAP,
			NULL);
        	XShapeCombineMask(XtDisplay(wNextButton),XtWindow(wNextButton),
                	ShapeBounding,0,0,pixNextMask,ShapeSet);
	}
	else
	{
	//	vShowErrorToTerm("can't get Next pixmap !");
	}

	return;
}

/********************************************************************/
void CfgWin::vSetBackground(Pixmap pixBack)
{
	XtVaSetValues(XtParent(wUseRuleToggle),
		XmNbackgroundPixmap,pixBack,
		NULL);
	XtVaSetValues(wUseRuleToggle,
		XmNbackgroundPixmap,pixBack,
		NULL);
	XtVaSetValues(wScanClipBoardToggle,
		XmNbackgroundPixmap,pixBack,
		NULL);
	XtVaSetValues(wHelpButton,
		XmNbackgroundPixmap,pixBack,
		NULL);
	XtVaSetValues(wExitButton,
		XmNbackgroundPixmap,pixBack,
		NULL);
	XtVaSetValues(wLastButton,
		XmNbackgroundPixmap,pixBack,
		NULL);
	XtVaSetValues(wNextButton,
		XmNbackgroundPixmap,pixBack,
		NULL);
	return;
}

/********************************************************************/
Boolean CfgWin::bScanClipBoard()
{
	return(XmToggleButtonGetState(wScanClipBoardToggle));
}

/********************************************************************/
Boolean CfgWin::bUseRule()
{
	return(XmToggleButtonGetState(wUseRuleToggle));
}

//===================================================================
AppCore::AppCore(AppFrame* pAppFrame):oUserWin(this),oListWin(this),
	oCfgWin(this),oSelection(this)
{
	poAppFrame=pAppFrame;
	iCurrentIndex=-1;
	return;
}

/********************************************************************/
Widget AppCore::wCreate(Widget wParent)
{
	if(!oLibs.bGetLib()) 
	{
		vShowErrorToTerm(sErrorMessage);
		vQuit();
	}

        Widget wForm=XtVaCreateWidget("mainform",
                xmFormWidgetClass,wParent,
		XmNfractionBase,4,
		XmNmarginWidth,0,
		XmNmarginHeight,0,
		XmNshadowType,XmSHADOW_OUT,
		XmNshadowThickness,0,
                NULL);

	Widget wTopWin=wCreateTopLabel(wForm);
	Widget wListWin=oListWin.wCreate(wForm);
	Widget wUserWin=oUserWin.wCreate(wForm);
	Widget wCfgWin=oCfgWin.wCreate(wForm);

	// set position
	XtVaSetValues(wTopWin,
		XmNtopAttachment,XmATTACH_FORM,
		XmNleftAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_FORM,
		NULL);
	XtVaSetValues(wListWin,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,wTopWin,
		XmNleftAttachment,XmATTACH_POSITION,
		XmNleftPosition,3,
		XmNrightAttachment,XmATTACH_FORM,
		XmNbottomAttachment,XmATTACH_FORM,
		NULL);
	XtVaSetValues(wUserWin,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget,wTopWin,
		XmNleftAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_WIDGET,
		XmNrightWidget,wListWin,
		XmNbottomAttachment,XmATTACH_WIDGET,
		XmNbottomWidget,wCfgWin,
		NULL);
	XtVaSetValues(wCfgWin,
		XmNleftAttachment,XmATTACH_FORM,
		XmNrightAttachment,XmATTACH_WIDGET,
		XmNrightWidget,wListWin,
		XmNbottomAttachment,XmATTACH_FORM,
		NULL);

        XtManageChild(wForm);

	oFloatWin.wCreate(wParent);

	return(wForm);
}

/********************************************************************/
Widget AppCore::wCreateTopLabel(Widget wParent)
{
        Widget wFrame=XtVaCreateManagedWidget("frame",
                xmFrameWidgetClass,wParent,
		NULL);

	XmString xmsTopLabel=xmsCreateChinese(TOPLABEL_S);
	wTopLabel=XtVaCreateManagedWidget("toplabel",
		xmLabelWidgetClass,wFrame,
		XmNlabelString,xmsTopLabel,
		NULL);
	XmStringFree(xmsTopLabel);

	return(wFrame);
}

/********************************************************************/
void AppCore::vSetBackground()
{
	Pixmap pixBack=pixGetPixmap(wTopLabel,BACKIMAGEFILE_S);
	if(pixBack==XmUNSPECIFIED_PIXMAP)
	{
	//	vShowErrorToTerm("can't get background pixmap or no color !");
		return;
	}

	XtVaSetValues(wTopLabel,
		XmNbackgroundPixmap,pixBack,
		NULL);

	oUserWin.vSetBackground(pixBack);
	oListWin.vSetBackground(pixBack);
	oCfgWin.vSetBackground(pixBack);
	oFloatWin.vSetBackground(pixBack);

	XFreePixmap(XtDisplay(wTopLabel),pixBack);

	return;
}

/********************************************************************/
void AppCore::vAfterRealize() // must be done after realized.
{
	vSetBackground();
	oCfgWin.vSetButtonPixmap(); 
	oSelection.vStart(wTopLabel);
	oUserWin.vActivateText();
	oUserWin.vSetADPixmap();
	oUserWin.vADShow();
	return;
}

/********************************************************************/
void AppCore::vQuit()
{
	poAppFrame->vQuit();
	return;
}

/********************************************************************/
void AppCore::vShowHelp()
{
	char* sAllMessage=new char[strlen(HELP_MESS_S)+strlen(LIC_INFO_S)+1];
	strcpy(sAllMessage,HELP_MESS_S);
	strcat(sAllMessage,LIC_INFO_S);
	oUserWin.vShowToMeaningWin(sAllMessage);
	delete []sAllMessage;

	return;
}

/********************************************************************/
void AppCore::vShowNotFoundToFloat(const char* sWord,const char* sReason)
{
	XmString xmsWord=xmsCreateChinese(sWord);
	XmString xmsNewLine=xmsCreateChinese("\n");
	XmString xmsMessage=XmStringConcat(xmsWord,xmsNewLine);
	XmStringFree(xmsWord);
	XmStringFree(xmsNewLine);

	XmString xmsOldMessage=xmsMessage;
	XmString xmsReason=xmsCreateChinese(sReason);
	xmsMessage=XmStringConcat(xmsOldMessage,xmsReason);
	XmStringFree(xmsOldMessage);
	XmStringFree(xmsReason);

	oFloatWin.vShow(xmsMessage);
	XmStringFree(xmsMessage);

	return;
}

/********************************************************************/
void AppCore::vShowNotFoundToUserWin(const char* sWord,const char* sReason)
{
	oUserWin.vShowToLabel(sWord);
	oUserWin.vShowToMeaningWin(sReason);
	return;
}

/********************************************************************/
XmString AppCore::xmsWordWithYB(const char *sWord,const char* sYB)
{
	if(sWord==NULL) return(NULL);

	XmString xmsWord=XmStringCreateSimple((char *)sWord);
	if(sYB!=NULL)
	{
		XmString xmsYB=xmsGetYBWithBracket(sYB);
		XmString xmsOldWord=xmsWord;
		xmsWord=XmStringConcat(xmsOldWord,xmsYB);
		XmStringFree(xmsYB);
		XmStringFree(xmsOldWord);
	}

	return(xmsWord);
}
/********************************************************************/
void AppCore::vShowWordToUserWin(const WordItem &oWordToShow,const char* sYB)
{
	XmString xmsWord=xmsWordWithYB(oWordToShow.sGetWord(),sYB);
	oUserWin.vShowToLabel(xmsWord);
	oUserWin.vShowToMeaningWin(oWordToShow.sGetMeaning());
	XmStringFree(xmsWord);
	return;
}

/********************************************************************/
void AppCore::vShowWordToFloat(const WordItem &oWordToShow,const char* sYB)
{
	XmString xmsMessage=xmsWordWithYB(oWordToShow.sGetWord(),sYB);

	// add a '\n'
	XmString xmsOldMessage=xmsMessage;
	XmString xmsNewLine=xmsCreateChinese("\n");
	xmsMessage=XmStringConcat(xmsOldMessage,xmsNewLine);
	XmStringFree(xmsOldMessage);
	XmStringFree(xmsNewLine);

	// add meaning
	xmsOldMessage=xmsMessage;
	XmString xmsMeaning=xmsCreateChinese(oWordToShow.sGetMeaning());
	xmsMessage=XmStringConcat(xmsOldMessage,xmsMeaning);
	XmStringFree(xmsOldMessage);
	XmStringFree(xmsMeaning);

	oFloatWin.vShow(xmsMessage);
	XmStringFree(xmsMessage);

	return;
}

/********************************************************************/
void AppCore::vLookupWithRuleToUserWin(const char* sWord)
{
        int aiIndex[MAX_MATCH_ITEM+1];
        if(oLibs.bGetWordsWithRule(sWord,aiIndex,MAX_MATCH_ITEM+1))
        {
		oListWin.vClear();

		int i;
                for(i=0;aiIndex[i]!=-1;i++)
                {
			const char *sMatchWord;
			sMatchWord=oLibs.poGetWordItem(aiIndex[i])->sGetWord();
                        oListWin.vInsertLast(sMatchWord);
                }
		iCurrentIndex=-1;	// iCurrentIndex is ineffective now.

		// show the first word.
		const WordItem* pWordItem=oLibs.poGetWordItem(aiIndex[0]); 
		const char* sYB=oLibs.sGetYB(pWordItem->sGetWord());
                vShowWordToUserWin(*pWordItem,sYB);
        }
        else
        {
		vShowNotFoundToUserWin(sWord,sErrorMessage);
        }

	return;
}

/********************************************************************/
void AppCore::vSimpleLookupToUserWin(const char* sWord,int* piIndex)
{
	int iRetIndex;
	if(oLibs.bSimpleGetWord(sWord,iRetIndex))
	{
		const WordItem* pWordItem=oLibs.poGetWordItem(iRetIndex); 
		const char* sYB=oLibs.sGetYB(pWordItem->sGetWord());
		vShowWordToUserWin(*pWordItem,sYB);
	}
	else
	{
		vShowNotFoundToUserWin(sWord,sErrorMessage);
	}

	if(piIndex!=NULL) *piIndex=iRetIndex;

	return;
}

/********************************************************************/
void AppCore::vSimpleLookupToFloat(const char* sWord)
{
	int iIndex;
	if(oLibs.bSimpleGetWord(sWord,iIndex))
	{
		const WordItem* pWordItem=oLibs.poGetWordItem(iIndex); 
		const char* sYB=oLibs.sGetYB(pWordItem->sGetWord());
		vShowWordToFloat(*pWordItem,sYB);
	}
	else
	{
		vShowNotFoundToFloat(sWord,sErrorMessage);
	}

	return;
}

/********************************************************************/
void AppCore::vUserWinWordChange(const char* sWord)
{
	// user want to use rule , do nothing now.
	if(oCfgWin.bUseRule() && bContainRule(sWord)) return;

	int iIndex;
        vSimpleLookupToUserWin(sWord,&iIndex);
	vListWords(iIndex);

	return;
}

/********************************************************************/
void AppCore::vUserWinEnterWord(const char* sWord)
{
	if(oCfgWin.bUseRule() && bContainRule(sWord))
        {
                vLookupWithRuleToUserWin(sWord);
        }
	else
	{
		oUserWin.vSetTextSelection();
	}

	oUserWin.vInsertHisList(sWord);

	return;
}

/********************************************************************/
void AppCore::vWordSelected(const char* sWord)
{
	// do not use rule.
        vSimpleLookupToFloat(sWord);
	oUserWin.vInsertHisList(sWord);
	return;
}

/********************************************************************/
void AppCore::vArrowActivate()
{
	oUserWin.vToggleHisList();
	return;
}

/********************************************************************/
void AppCore::vListClick(const char* sWord)
{
	oUserWin.vPutToText(sWord);
	return;
}

/********************************************************************/
void AppCore::vListChoose(const char* sWord)
{
	vSimpleLookupToUserWin(sWord);
	return;
}

/********************************************************************/
void AppCore::vHistoryChoose(const char* sWord)
{
	oUserWin.vPutToText(sWord);
	return;
}

/********************************************************************/
void AppCore::vNext()
{
	if(iCurrentIndex>=oLibs.iLength()-1) return;

	int iNextIndex;
	if(iCurrentIndex<0)
	{
		iNextIndex=0;
	}
	else
	{
		iNextIndex=iCurrentIndex+1;
	}

	vUserWinWordChange(oLibs.poGetWordItem(iNextIndex)->sGetWord());

	return;
}

/********************************************************************/
void AppCore::vLast()
{
	if(iCurrentIndex==0) return;

	int iLastIndex;
	if(iCurrentIndex<0)
	{
		iLastIndex=0;
	}
	else
	{
		iLastIndex=iCurrentIndex-1;
	}

	vUserWinWordChange(oLibs.poGetWordItem(iLastIndex)->sGetWord());

	return;
}

/********************************************************************/
void AppCore::vListWords(int iStartIndex)
{
	assert(iStartIndex>=0 && iStartIndex<=oLibs.iLength()-1);

	if(iCurrentIndex<0) 
	{
		vFillList(iStartIndex);
		return;
	}

	int iShowCount=oListWin.iVisibleCount();
	int iLibLen=oLibs.iLength();
	int iEndIndex;
	if(iStartIndex+iShowCount<=iLibLen)
	{
		iEndIndex=iStartIndex+iShowCount-1;
	}
	else
	{
		iEndIndex=iLibLen-1;
	}

	int iCurrentEndIndex=iCurrentIndex+oListWin.iLength()-1;

	if(iStartIndex>iCurrentEndIndex || iCurrentIndex>iEndIndex)
	{
		vFillList(iStartIndex);
		return;
	}

	if(iEndIndex<iCurrentEndIndex)
	{
		oListWin.vDeleteLast(iCurrentEndIndex-iEndIndex);
	}

	if(iStartIndex>iCurrentIndex)
	{
		oListWin.vDeleteFirst(iStartIndex-iCurrentIndex);
	}

	if(iEndIndex>iCurrentEndIndex)
	{
		vAddListLast(iCurrentEndIndex+1,iEndIndex-iCurrentEndIndex);
	}

	if(iStartIndex<iCurrentIndex)
	{
		vAddListFirst(iStartIndex,iCurrentIndex-iStartIndex);
	}

	iCurrentIndex=iStartIndex;

	return;
}

/********************************************************************/
void AppCore::vAddListFirst(int iIndex,int iCount)
{
	int iLibLen=oLibs.iLength();
	int iEndIndex;
	if(iIndex+iCount<=iLibLen)
	{
		iEndIndex=iIndex+iCount-1;
	}
	else
	{
		iEndIndex=iLibLen-1;
	}

	int i;
	for(i=iEndIndex;i>=iIndex;i--)
	{
		oListWin.vInsertFirst(oLibs.poGetWordItem(i)->sGetWord());
	}

	return;
}

/********************************************************************/
void AppCore::vAddListLast(int iIndex,int iCount)
{
	int iLibLen=oLibs.iLength();
	int iEndIndex;
	if(iIndex+iCount<=iLibLen)
	{
		iEndIndex=iIndex+iCount-1;
	}
	else
	{
		iEndIndex=iLibLen-1;
	}

	int i;
	for(i=iIndex;i<=iEndIndex;i++)
	{
		oListWin.vInsertLast(oLibs.poGetWordItem(i)->sGetWord());
	}

	return;
}

/********************************************************************/
void AppCore::vFillList(int iIndex)
{
	oListWin.vClear();

	int iShowCount=oListWin.iVisibleCount();
	int iLibLen=oLibs.iLength();
	int iEndIndex;
	if(iIndex+iShowCount<=iLibLen)
	{
		iEndIndex=iIndex+iShowCount-1;
	}
	else
	{
		iEndIndex=iLibLen-1;
	}

	int i;
	for(i=iIndex;i<=iEndIndex;i++)
	{
		oListWin.vInsertLast(oLibs.poGetWordItem(i)->sGetWord());
	}

	iCurrentIndex=iIndex;
		
	return;
}

/********************************************************************/
Boolean AppCore::bScreenFetchEnable()
{
	return(oCfgWin.bScanClipBoard() && !oUserWin.bTextSelected());
}

//===================================================================
AppFrame::AppFrame():oAppCore(this)
{
	return;
}

/********************************************************************/
void AppFrame::vInit(int argc,char **argv)
{
        Atom DELETE_WIN;

        wToplevel=XtVaAppInitialize(&app,"transrc",
                NULL,0,&argc,argv,fallback,
                XmNdeleteResponse,XmDO_NOTHING,
                NULL);
	vSetFontPath();

        //set Shell's delete menu callbackfunc.
        DELETE_WIN=XmInternAtom(XtDisplay(wToplevel),"WM_DELETE_WINDOW",False);
        XmAddWMProtocolCallback(wToplevel,DELETE_WIN,vDeleteCallback,this);

	oAppCore.wCreate(wToplevel);

	vSetIcon(); // must be here , can't be after XtRealizedWidget().
        XtRealizeWidget(wToplevel);
	oAppCore.vAfterRealize();

	return;
}

/********************************************************************/
void AppFrame::vRaiseUp()
{
	XRaiseWindow(XtDisplay(wToplevel),XtWindow(wToplevel));
	return;
}

/********************************************************************/
void AppFrame::vSetIcon()
{
	Pixmap pixIcon=pixGetPixmap(wToplevel,ICONIMAGEFILE_S);
	Pixmap pixIconMask=pixGetBitmap(wToplevel,ICONMASKFILE_S);
	if(pixIcon==XmUNSPECIFIED_PIXMAP || pixIconMask==XmUNSPECIFIED_PIXMAP)
	{
	//	vShowErrorToTerm("can't get icon pixmap !");
		return;
	}

	Window iconWin,root;
	int x,y;
	unsigned int width,height,border_width,depth;
	Display *display=XtDisplay(wToplevel);
	XGetGeometry(display,pixIcon,&root,&x,&y,&width,&height,
		&border_width,&depth);
	iconWin=XCreateSimpleWindow(display,root,0,
		0,width,height,0,CopyFromParent,CopyFromParent);
	XtVaSetValues(wToplevel,		// set icon Window for toplevel.
		XmNiconWindow,iconWin,
		NULL);
	XSetWindowBackgroundPixmap(display,iconWin,pixIcon);
	XShapeCombineMask(display,iconWin,ShapeBounding,0,0,
		pixIconMask,ShapeSet);
	XClearWindow(display,iconWin);
	XFreePixmap(display,pixIcon);

	return;
}

/********************************************************************/
void AppFrame::vSetFontPath()
{
	Display* display=XtDisplay(wToplevel);

	if(bHaveFont(display,HZFONT_S) && bHaveFont(display,YBFONT_S) )	
	{
		return;	// font path has been set.
	}

	// get old font path.
	int iOldDirs;
	char **olddirs=XGetFontPath(display,&iOldDirs);

	// copy old dirs
	char **newdirs=new char*[iOldDirs+1];
	int i;
	for(i=0;i<iOldDirs;i++)
	{
		newdirs[i]=olddirs[i];
	}

	// add $TRANSHOME/hzfont to font path.
	char sFontPath[MAX_STR_LEN+1];
	strcpy(sFontPath,sHomeDir);
	strcat(sFontPath,FONTDIR_S);
	newdirs[iOldDirs]=sFontPath;
	XSetFontPath(display,newdirs,iOldDirs+1);
	XFreeFontPath(olddirs);
	delete []newdirs;

	return;
}

/********************************************************************/
void AppFrame::vDeleteCallback(Widget ,XtPointer thisObj,XtPointer )
{
        ((AppFrame *)thisObj)->vQuit();
        return;
}

/********************************************************************/
void AppFrame::vQuit()
{
	exit(0);
}

/********************************************************************/
void AppFrame::vLoop()
{
        while(1)
        {
                XEvent event;
                XtAppNextEvent(app,&event);
                XtDispatchEvent(&event);
        }
}

//===================================================================
void vShowErrorToTerm(const char *sMessage)
{
	cout<<sMessage<<endl;
	return;
}

//*******************************************************************
// change sMessage to 2 byte string , so I can use Chinese font on it.

char* sChangeTo2Byte(const char* sMessage)
{
        if(sMessage==NULL || sMessage[0]=='\0') return(NULL);
	
	char* sResult=new char[strlen(sMessage)*2+1];
	int iByte;
	int iResultLen=0;
	for(iByte=0;sMessage[iByte]!='\0';iByte++)
	{
		if(bIsChinese(sMessage[iByte]) || sMessage[iByte]=='\n')
		{
			sResult[iResultLen++]=sMessage[iByte]&0x7f;
		}
		else
		{
			sResult[iResultLen++]=0x23;
			sResult[iResultLen++]=sMessage[iByte];
		}
	}
	sResult[iResultLen]='\0';

	return(sResult);
}

//*******************************************************************
// xmsCreateChinese change string to XmString,it allow English chars appear
// in a Chinese word.
 
XmString xmsCreateChinese(const char *sMessage)
{
        if(sMessage==NULL || sMessage[0]=='\0') return(NULL);

	char* sResult=sChangeTo2Byte(sMessage);
	XmString xmsResult=XmStringCreateLtoR(sResult,"Chinese");
	delete []sResult;

        return(xmsResult);
}

//*******************************************************************
XmString xmsGetYB(const char *sMessage)
{
        return(XmStringCreateLtoR((char *)sMessage,"YB"));
}

/********************************************************************/
XmString xmsGetYBWithBracket(const char* sMessage)
{
	if(sMessage==NULL) return(NULL);

	// 20>strlen("   []")+1
	char *sResult=new char[strlen(sMessage)+20];
	sprintf(sResult,"  [%s]",sMessage);
	XmString xmsResult=xmsGetYB(sResult);
	delete []sResult;

	return(xmsResult);
}

//*******************************************************************
Boolean bHaveFont(Display* display,const char* sFontName)
{
	int count;
	char **list=XListFonts(display,sFontName,1,&count);
	XFreeFontNames(list);

	return(count>0);
}

//*******************************************************************
Boolean bGetHomeDir()
{
	// check $TRANSHOME
	char* pTransHome=getenv("TRANSHOME");
	if( pTransHome!=NULL && bDirOK(pTransHome) )
	{
		strcpy(sHomeDir,pTransHome);
		return(True);
	}

	// check default Dir in search paths.
	int i;
	for(i=0;asSearchDirs[i]!=NULL;i++)
	{
		if(bDirOK(asSearchDirs[i])) 
		{
			strcpy(sHomeDir,asSearchDirs[i]);
			return(True);
		}
	}

	// check current User Home Dir
	char* pUserHome=getenv("HOME");
	if(pUserHome!=NULL)
	{
		char sUserHomeDic[MAX_STR_LEN+1];
		strcpy(sUserHomeDic,pUserHome);
		strcat(sUserHomeDic,"/dic");
		if( bDirOK(sUserHomeDic) )
		{
			strcpy(sHomeDir,sUserHomeDic);
			return(True);
		}
	}

	// check current work Dir
	char sCwd[MAX_STR_LEN+1];
	char* pPwd=getcwd(sCwd,MAX_STR_LEN);
	if( pPwd!=NULL && bDirOK(pPwd) )
	{
		strcpy(sHomeDir,pPwd);
		return(True);
	}

	strcpy(sErrorMessage,"TRANSHOME error,please see readme !");

	return(False);
}

/********************************************************************/
// check whether the Dir is the correct one.
// If there is DICFILE_S in "sPath",I assume that the Dir is what I want.

Boolean bDirOK(const char* sPath)
{
	if(sPath==NULL) return(False);

	char sFullPath[MAX_STR_LEN+1];
	strcpy(sFullPath,sPath);
	strcat(sFullPath,DICFILE_S);

	struct stat stFileStat;
	int iResult=stat(sFullPath,&stFileStat);

	return(iResult!=-1);
}

/********************************************************************/
void vGetPointerXY(Display* display,int& iX,int& iY)
{
        Window rootwindow,child;
	int winx,winy;
        unsigned int buttons;

        XQueryPointer(display,DefaultRootWindow(display),&rootwindow,
                &child,&iX,&iY,&winx,&winy,&buttons);

	return;
}

/********************************************************************/
Boolean bPointerIn(Widget w)
{
        Window rootwindow,child;
        int rootx,rooty;
	int winx,winy;
        unsigned int buttons;
	Dimension width,height;

        XQueryPointer(XtDisplay(w),XtWindow(w),&rootwindow,
                &child,&rootx,&rooty,&winx,&winy,&buttons);

	XtVaGetValues(w,
		XmNwidth,&width,
		XmNheight,&height,
		NULL);

	return(winx>0 && winx<width && winy>0 && winy<height);
}

/********************************************************************/
Pixmap pixGetBitmap(Widget w,const char *sImageFile)
{
	int status,iX_Hot,iY_Hot;
	unsigned int width,height;
	Pixmap pixmap;

	char sFullImageFile[MAX_STR_LEN+1];
	strcpy(sFullImageFile,sHomeDir);
	strcat(sFullImageFile,sImageFile);

	Display *display=XtDisplay(w);
	status=XReadBitmapFile(display,DefaultRootWindow(display),
		sFullImageFile,&width,&height,&pixmap,&iX_Hot,&iY_Hot);

	if(status!=BitmapSuccess)
	{
		pixmap=XmUNSPECIFIED_PIXMAP;
	}

	return(pixmap);
}

/********************************************************************/
Pixmap pixCreatePixmap(Widget w,const char *sImageFile,int* piColorLost)
{
	Colormap colormap;
	XtVaGetValues(w,
		XmNcolormap,&colormap,
		NULL);

	char sImageFullFile[MAX_STR_LEN+1];
	strncpy(sImageFullFile,sHomeDir,MAX_STR_LEN);
	strncat(sImageFullFile,sImageFile,MAX_STR_LEN-strlen(sImageFullFile));

	PixmapClass oImage(sImageFullFile);
	oImage.vSet(XtScreen(w),colormap);
	oImage.vCreate();

	if(piColorLost!=NULL) *piColorLost=oImage.iGetColorLost();

	return(oImage.pixGetPixmap());
}

/********************************************************************/
Pixmap pixGetPixmap(Widget w,const char *sImageFile)
{
	int iColorLost;
	Pixmap pixmap=pixCreatePixmap(w,sImageFile,&iColorLost);
	if(iColorLost>MAX_COLOR_LOST) pixmap=XmUNSPECIFIED_PIXMAP;
	return(pixmap);
}

/********************************************************************/
Pixmap pixForceGetPixmap(Widget w,const char* sImageFile)
{
	return(pixCreatePixmap(w,sImageFile,NULL));
}

/********************************************************************/
Boolean bContainRule(const char* sWord)
{
	int i;
	for(i=0;sWord[i]!=0;i++)
	{
		if(sWord[i]=='*' || sWord[i]=='?')
		{
			return(True);
		}
	}

	return(False);
}

//====================================================================
int main(int argc,char **argv)
{
	if(!bGetHomeDir())
	{
		vShowErrorToTerm(sErrorMessage);
		exit(1);
	}

	AppFrame oAppFrame;
	oAppFrame.vInit(argc,argv);
	oAppFrame.vLoop();

	return(1);
}

/************************** END *************************************/
