#ifndef __SD_CONF_H__
#define __SD_CONF_H__

#include <glib.h>
#include <memory>
#include <string>

#if defined(_WIN32) || defined(WITHOUT_GNOME)
struct ConfigLine {
  gchar *key;
  gchar *value;
};

struct ConfigSection {
  gchar *name;
  GList *lines;
  ConfigLine *CreateString(const gchar * key, const gchar * value);
  ConfigLine *FindString(const gchar * key);
};
#else
#  include <gconf/gconf.h>
#  include <gconf/gconf-client.h>
#endif

/*
 * TBaseConf class encapsule methods
 * for geting access to variables in some config repository,
 * it can be gconf server or file.
*/

class TBaseConf {
public:  
  explicit TBaseConf(const gchar *conf_path);
  ~TBaseConf();
  
  bool ReadBool(const gchar *section, const gchar *key, gboolean *value, gboolean def);
  bool ReadInt(const gchar *section, const gchar *key, gint *value, gint def);
  bool ReadString(const gchar * section, const gchar *key, gchar **value);
  bool ReadStrList(const gchar * section, const gchar * key, GSList **slist);

  void WriteBool(const gchar *section, const gchar *key, gboolean value);
  void WriteInt(const gchar *section, const gchar *key, gint value);
  void WriteString(const gchar *section, const gchar *key, const gchar *value);
  void WriteStrList(const gchar *section, const gchar *key, GSList *slist);

protected:
  gchar *cfgfilename;
#if defined(_WIN32) || defined(WITHOUT_GNOME)
  GList *sections;

  ConfigSection *CreateSection(const gchar * name);
  ConfigSection *FindSection(const gchar * name);
  bool Open(const gchar * filename);
  bool Write(const gchar * filename);
  inline void Save(void){ Write(cfgfilename); }
#else
	GConfClient *gconf_client;
#endif
};

/*
 * AppConf class encapsulate 
 * all preference of stardict.
*/

class AppConf : private TBaseConf {
private:
  gint hpaned_pos;
  gint window_width, window_height;
  gint lock_x, lock_y;
  gboolean maximized;
  gboolean use_custom_font;
  gchar *custom_font;
  gboolean hide_on_startup;
  gboolean enable_sound_event;
  gboolean hide_list;
  GSList *search_website_list;
  gboolean scan_selection;
  gboolean query_in_floatwin;
  gboolean only_scan_while_modifier_key;
  gboolean hide_floatwin_when_modifier_key_released;
  gint scan_modifier_key;
  gboolean pronounce_when_popup;
  gint max_window_width, max_window_height;
  GSList *treedict_order_list, *treedict_disable_list;
  GSList *dict_order_list, *dict_disable_list;
  gboolean lock;

#if !defined(_WIN32) && !defined(WITHOUT_GNOME)
	static void dictionary_scan_selection_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
	static void main_window_hide_list_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);	
	static void floatwin_lock_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
	static void floatwin_lock_x_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
	static void floatwin_lock_y_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
#endif

public:
  explicit AppConf(const gchar *conf_path);
	~AppConf();
  void Load(void);

  gint get_hpaned_pos(void) const{return hpaned_pos;}
  void set_hpaned_pos(gint value);
  gint get_window_width(void) const{return window_width;}
  void set_window_width(gint value);
  gint get_window_height(void) const{return window_height;}
  void set_window_height(gint value);
  gint get_lock_x(void) const{return lock_x;}
  void set_lock_x(gint value);
  gint get_lock_y(void) const{return lock_y;}
  void set_lock_y(gint value);
  gboolean get_maximized(void) const{return maximized;}
  void set_maximized(gboolean value);
  gboolean get_use_custom_font(void) const{return use_custom_font;}
  void set_use_custom_font(gboolean value);
  const gchar *get_custom_font(void) const{return custom_font;}
  void set_custom_font(const gchar *value);
  gboolean get_hide_on_startup(void) const{return hide_on_startup;}
  void set_hide_on_startup(gboolean value);
  gboolean get_enable_sound_event(void) const{return enable_sound_event;}
  void set_enable_sound_event(gboolean value);
  gboolean get_hide_list(void) const{return hide_list;}
  void set_hide_list(gboolean value);
  const GSList *get_search_website_list(void) const{return search_website_list;}
  void set_search_website_list(GSList *value);
  gboolean get_scan_selection(void) const{return scan_selection;}
  void set_scan_selection(gboolean value);
  gboolean get_query_in_floatwin(void) const{return query_in_floatwin;}
  void set_query_in_floatwin(gboolean value);
  gboolean get_only_scan_while_modifier_key(void) const{return only_scan_while_modifier_key;}
  void set_only_scan_while_modifier_key(gboolean value);
  gboolean get_hide_floatwin_when_modifier_key_released(void) const{return hide_floatwin_when_modifier_key_released;}
  void set_hide_floatwin_when_modifier_key_released(gboolean value);
  gint get_scan_modifier_key(void) const{return scan_modifier_key;}
  void set_scan_modifier_key(gint value);
  gboolean get_pronounce_when_popup(void) const{return pronounce_when_popup;}
  void set_pronounce_when_popup(gboolean value);
  gint get_max_window_width(void) const{return max_window_width;}
  void set_max_window_width(gint value);
  gint get_max_window_height(void) const{return max_window_height;}
  void set_max_window_height(gint value);
  const GSList *get_treedict_order_list(void) const{return treedict_order_list;}
  void set_treedict_order_list(GSList *value);
  const GSList *get_treedict_disable_list(void) const{return treedict_disable_list;}
  void set_treedict_disable_list(GSList *value);
  const GSList *get_dict_order_list(void) const{return dict_order_list;}
  void set_dict_order_list(GSList *value);
  const GSList *get_dict_disable_list(void) const{return dict_disable_list;}
  void set_dict_disable_list(GSList *value);
  gboolean get_lock(void) const{return lock;}
  void set_lock(gboolean value);
};

extern std::auto_ptr<AppConf> conf;//global exemplar of AppConf class
extern std::string gStarDictDataDir;

#endif
