/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#ifndef __CONFIGURECOORDS_H__
#define __CONFIGURECOORDS_H__

#include "configure.h"
#include "glade/glade.h"
#include "coordsys.h"

struct coordsconfig
{
	GtkWidget *coordcombo;
	GtkWidget *coordentry;
	GtkWidget *coordlist;
	GtkWidget *coordframe;
	GtkWidget *gridbutton;
	GtkWidget *equbutton;
	GtkWidget *polesbutton;
	GtkWidget *gridcolor;
	GtkWidget *equcolor;
	GtkWidget *polescolor;
	GtkWidget *gridlabelcombo;
	GtkWidget *gridlabelentry;
	GtkWidget *gridlabellist;
	GtkWidget *equlabelcombo;
	GtkWidget *equlabelentry;
	GtkWidget *equlabellist;
	GtkWidget *poleslabelbutton;
	GtkWidget *griddegbutton;
	GtkWidget *gridnumbutton;
	GtkWidget *equdegbutton;
	GtkWidget *equnumbutton;
	GtkWidget *griddegspin;
	GtkWidget *gridnumspin;
	GtkWidget *equdegspin;
	GtkWidget *equnumspin;

	gint coordpropscount;
	gint curslot;
	struct coordprops *oldprops;	// Array of pointers to new data
	struct coordprops *curprops;
};

struct coordsconfig *newcoordsconfig(GladeXML *configxml);
void deletecoordsconfig(struct coordsconfig *cc);
void coordsconfigupdate(struct coordsconfig *cc);
void coordsconfigsetup(struct configurator *cfg);
void coordsconfigtry(struct configurator *cfg);
void coordsconfigrevert(struct configurator *cfg);

#endif
