/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#include <string.h>
#include <gtk/gtk.h>
#include "stars.h"
#include "printgui.h"
#include "print.h"

GtkWidget *file_selector = 0;

void print_filename_callback(GtkWidget *button, gpointer v) 
{
	gchar *selected_filename;

	if(file_selector == 0)
	{
		fprintf(stderr, "print_filename_callback : file_selector is NULL\n");
		return;
	}

	if(v)
	{
		selected_filename = gtk_file_selection_get_filename (
			GTK_FILE_SELECTION(file_selector));

		if(strlen(selected_filename) > 0)
			printview(catalogs, (struct viewer *)v, selected_filename);

		g_free(selected_filename);	
	}
	gtk_window_set_modal(GTK_WINDOW(file_selector), FALSE);
	gtk_widget_hide(file_selector);
}

void printviewgui(GtkWidget *widget, struct viewer *v)
{
	/* Create the selector */
	
	if(file_selector == 0)
	{
		file_selector = gtk_file_selection_new("Please select print file.");

		gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(file_selector));
		gtk_file_selection_set_filename (GTK_FILE_SELECTION(file_selector), "stars.ps");
		gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
			"clicked", GTK_SIGNAL_FUNC (print_filename_callback), v);
		gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->cancel_button),
			"clicked", GTK_SIGNAL_FUNC (print_filename_callback), 0);
	}

	/* Display that dialog */

	gtk_window_set_modal(GTK_WINDOW(file_selector), TRUE);
	gtk_widget_show (file_selector);

}
