/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#ifndef __RGBDRAW__
#define __RGBDRAW__

#include <gdk-pixbuf/gdk-pixbuf.h>
#include "picture.h"

void drawvline(GdkPixbuf *image, int x, int y1, int y2, int r, int g, int b);

void drawhline(GdkPixbuf *image, int x1, int y, int x2, int r, int g, int b);

void drawicon(GdkPixbuf *image, int x, int y, struct picture *icon);

void fillcircle(GdkPixbuf *image, int x, int y, float rad, 
        int r, int g, int b);

void drawcircle(GdkPixbuf *image, int x, int y, float rad, 
        int r, int g, int b);

void _drawline(GdkPixbuf *image, int x1, int y1, int x2, int y2, float w,
        int r, int g, int b);

void drawline(GdkPixbuf *image, int x1, int y1, int x2, int y2, float w,
        int r, int g, int b);

void drawvertellipse(GdkPixbuf *image, int x0, int y0, float m, float n,
        int r, int g, int b);

void drawellipse(GdkPixbuf *image, int x0, int y0, float maj, float min,
        float pa, int r, int g, int b);

#endif
