/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#include <stdio.h>
#include <unistd.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glade/glade.h>
#include "stars.h"
#include "plugin.h"
#include "viewer.h"
#include "object.h"
#include "location.h"
#include "vista.h"
#include "coordsys.h"

struct iconlist *icons = 0;
GList *catalogs = 0;
double epoch = 2000.0;

int init(int argc, char **argv)
{
//	if(chdir("../data") != 0)
//	{
//		/* This needs work */
//		fprintf(stderr, "Please make sure env variable STARS is set\n");
//		exit(0);
//	}

	initcoordinates();
	initlocations();
	initvistarefs();	/* Must call after initcoordinates() */
	initplugins();
	
	loadclassheaders(PREFIXDIR "/share/stars/data/classes.dat");
	icons = newiconlist(PREFIXDIR "/share/stars/data/icons.dat");
	if(loadallcatalogs(PREFIXDIR "/share/stars/data/catalogs.dat") == 0) return -1;
	newviewer();

	return 0;
}

int main(int argc, char **argv)
{
	gtk_init(&argc, &argv);
	gdk_rgb_init();
	glade_init();

	if(init(argc, argv) < 0) return 0;
	gtk_main();

	return 0;
}
