/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#ifndef __VISTA_H__
#define __VISTA_H__

#include <glib.h>

struct vista
{
	double ra_center, dec_center;
	double zoom;
	double uprotation;
	gint uprefid;
	gint fliplr;
};

struct vistaref
{
	gchar *name;
	double x[3];
};

struct vista *newvista();
void deletevista(struct vista *v);
struct vista *copyvista(const struct vista *view);

struct vistaref *newvistaref(const gchar *name,
	double x, double y, double z);
void deletevistaref(struct vistaref *vr);
void addtovistareflist(const gchar *name, double x, double y, double z);
gint getvistarefid(const gchar *name);
double *getvistarefcoords(gint vistarefid);
const gchar *getvistarefname(gint vistarefid);
void initvistarefs();

#endif
