inherit Service.Service;

#include <events.h>

string compose_value_expression(mapping st)
{
  string query;
  if ( st->storage == "attrib" ) 
    query = " (ob_ident = 'attrib' and ob_attr='"+st->key+"' and ob_data "+
      st->value[0]+" '"+st->value[1]+"') ";
  else if ( st->storage == "doc_ft" ) 
    query = " (match(doc_data) against ('"+st->value +"')) ";
  else {
    query = " (ob_ident = '"+st->storage+"' and ob_attr='"+st->key+
      "' and ob_data ";
    switch ( st->value[0] ) {
    case ">":
    case "<":
    case "=":
      query += st->value[0]+" " + st->value[1]+") ";
      break;
    case "like":
    default:
      query += st->value[0]+" '" + st->value[1]+"') ";
    }
  }
  return query;
}

string compose_value_expressions(array tokens, string andor)
{
  string query = "";

  mapping last = tokens[0];
  string exp = compose_value_expression(last);

  for ( int i = 1; i < sizeof(tokens); i++ ) {
    mapping token = tokens[i];
    query += exp + " " + andor + " ";
    exp = compose_value_expression(token);
  }
  query += exp;
  
  return query;
}

mixed run_query(object handle, string query)
{
  werror("Query: %s\n", query);
  return handle->big_query(query);
}


void call_service(mixed args)
{
  werror("Search Service called with %O\n", args);
  object handle = Sql.Sql(serverCfg["database"]);

  if ( sizeof(handle->list_tables("temp_search")) )
    handle->big_query("drop table temp_search");

  array res = ({});
  object user = args[0];
  array classes = args[3];
  array extends = args[4];
  array limits = args[5];
  array fulltext = args[6];  
  string _query;

  if ( sizeof(fulltext) ) {
    _query = "create table temp_search as select ob_id from ( doc_ft ";
    classes = ({ }); // classes are documents
  }
  else 
    _query = "select distinct ob_data.ob_id from ( ob_data ";
  
  
  if ( arrayp(classes) && sizeof(classes) > 0 ) {
    _query += "INNER JOIN ob_class on ob_class.ob_id=ob_data.ob_id and ("+
      ( "ob_class = "+classes*" or ob_class=")+")";
  }
  _query += ") where";

  if ( sizeof(fulltext) )
    _query += compose_value_expressions(fulltext, "or");
  else
    _query += compose_value_expressions(extends, "or");
  
  object result;

  result = run_query(handle, _query);  
  
  if ( sizeof(fulltext) > 0 ) {
    _query = "select distinct ob_id from temp_search";
    result = run_query(handle, _query);
  }


  mixed row;
  while (row = result->fetch_row()) {
    if ( !arrayp(row) )
      row = ({ row });
    foreach(row, int oid) {
      int ok = 1;
      // check limits here
      foreach ( limits, mapping limit ) {
	_query = "select distinct ob_id from ob_data where ob_id="+oid+" and "+
	  compose_value_expression(limit);
	object lres = run_query(handle, _query);
	if ( !lres->fetch_row() ) {
	  ok = 0;
	}
      }
      if ( ok ) 
	res += ({ oid });
    }
  }
  werror("Result is %O\n",res);

  callback_service(user, args[1], args[2], res);
}

static void run()
{
}

static private void got_kill(int sig)
{
    _exit(1);  
}

int main(int argc, array argv)
{
  signal(signum("QUIT"), got_kill);
  start(argv[1], "search");
  return -17;
}

