/* Copyright (C) 2000-2004  Thomas Bopp, Thorsten Hampel, Ludger Merkens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * $Id: ObjectFactory.pike,v 1.1.1.1 2005/09/21 14:22:14 exodusd Exp $
 */

constant cvs_version="$Id: ObjectFactory.pike,v 1.1.1.1 2005/09/21 14:22:14 exodusd Exp $";

inherit "/kernel/factory";

//! This factory creates Objects.

import Attributes;

#include <classes.h>
#include <macros.h>
#include <events.h>
#include <access.h>
#include <database.h>
#include <attributes.h>
#include <types.h>

static void init_factory()
{
    ::init_factory();
}

/**
 * The execute function - create a new instance of type "Object"
 *  
 * @param mapping vars - variables like name and description
 *                'name' - the name
 *                'attributes' - default attributes
 *                'transient' - for temporary objects
 * @return the newly created object
 * @author <a href="mailto:astra@upb.de">Thomas Bopp</a>) 
 */
object execute(mapping vars)
{
    object obj;

    string name = vars["name"];
    try_event(EVENT_EXECUTE, CALLER, obj);

    if ( !mappingp(vars->attributes) )
      vars->attributes = ([ ]);
    if ( vars->transient )
      vars->attributes[OBJ_TEMP] = 1;
    obj = ::object_create(name, get_class_name(), 0, 
			  vars["attributes"], vars["attributesAcquired"],
			  vars["attributesLocked"]);

    if ( stringp(vars["description"]) )
	obj->set_attribute(OBJ_DESC, vars["description"]);
    string language = this_user()->query_attribute(USER_LANGUAGE);
    if ( stringp(language) )
      obj->set_attribute(OBJ_LANGUAGE, language);

    run_event(EVENT_EXECUTE, CALLER, obj);
    return obj->this();
}

string get_identifier() { return "Object.factory"; }
string get_class_name() { return "Object"; }
int get_class_id() { return CLASS_OBJECT; }

bool test() 
{
    Attribute attr = Attribute("test", "test", CMD_TYPE_STRING,0,this());
    register_attribute(attr);
    object o = execute( (["name": "test", ]) );
    if ( o->get_acquire_attribute("test") != this() )
	steam_error("Acquire of test object does not match !");
    destruct(attr);
    return true;
    
}

