/*
 * StelConfig.m
 * Stellarium
 *
 * Created by Da Woon Jung on 3/16/05.
 * Copyright 2005 dwj. All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#import <Cocoa/Cocoa.h>
#import "StelConfig.h"


bool setDirectories(const char **cdir, const char **data_root)
{
    NSBundle *appBundle = [NSBundle mainBundle];
    NSString *dataRoot = [appBundle resourcePath];
    NSString *defaultConfig = nil;
    NSFileManager *fm = [NSFileManager defaultManager];
    BOOL isDirectory = YES;

    static short domains[] = { kUserDomain, kLocalDomain, kNetworkDomain };
    FSRef fref;
    NSString *prefPath = nil;
    unsigned i;
    
    if (dataRoot)
    {
        if (!([fm fileExistsAtPath:dataRoot isDirectory:&isDirectory] && isDirectory))
            return NO;
        
        if (data_root)
            *data_root = [dataRoot UTF8String];

        defaultConfig = [appBundle pathForResource:@"default_config" ofType:@"ini" inDirectory:@"data"];
    }

    // Find the (possibly localized) Preferences folder
    for (i = 0; i < (sizeof domains / sizeof(short)); ++i)
    {
        if (FSFindFolder(domains[i], kPreferencesFolderType, TRUE, &fref) == noErr)
        {
            CFURLRef url = CFURLCreateFromFSRef(nil, &fref);
            prefPath = [[[(NSURL *)url path] stringByAppendingString: @"/"] stringByAppendingString: @STELLARIUM_CONF_DIR];
            CFRelease(url);
            break;
        }
    }

    if (prefPath)
    {
        const char *cdirStr = [[prefPath stringByAppendingString: @"/"]  UTF8String];
		
		if (cdir)
            *cdir = cdirStr;

		isDirectory = NO;
		
		if ( [fm fileExistsAtPath:prefPath isDirectory:&isDirectory] && isDirectory )
		{
			// noop
		} else {
			[fm createDirectoryAtPath:prefPath attributes:nil];
		}
		
        prefPath = [prefPath stringByAppendingPathComponent:@STELLARIUM_CONF_FILE];
        if ([fm fileExistsAtPath:prefPath isDirectory:&isDirectory])
        {
            if (isDirectory)
                return NO;
        }
        else if (defaultConfig)
        {
            // If the config file doesn't exist yet, copy a default one
            if (![fm copyPath:defaultConfig toPath:prefPath handler:nil])
            {
                NSRunAlertPanel(nil, [NSString stringWithFormat: NSLocalizedString(@"Can't create the file %s%s\n\
If the directory %s is missing please create it by hand.\n\
If not, check that you have access to %s\n", @""), cdirStr, STELLARIUM_CONF_FILE, cdirStr, cdirStr], nil, nil, nil);
                return NO;
            }
        }
        else
        {
            return NO;
        }

        return YES;
    }

    return NO;
}
